/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.player.inspector;

import java.sql.Connection;
import java.sql.Statement;
import net.coreprotect.database.lookup.BlockLookup;
import net.coreprotect.listener.player.inspector.BaseInspector;
import net.coreprotect.utility.Chat;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BlockInspector
extends BaseInspector {
    public void performBlockLookup(final Player player, final BlockState blockState) {
        class BasicThread
        implements Runnable {
            final /* synthetic */ BlockInspector this$0;

            BasicThread() {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.this$0.checkPreconditions(player);
                    try (Connection connection = this.this$0.getDatabaseConnection(player);){
                        Statement statement = connection.createStatement();
                        String resultData = BlockLookup.performLookup(null, statement, blockState, (CommandSender)player, 0, 1, 7);
                        if (resultData.contains("\n")) {
                            for (String b : resultData.split("\n")) {
                                Chat.sendComponent((CommandSender)player, b);
                            }
                        } else if (resultData.length() > 0) {
                            Chat.sendComponent((CommandSender)player, resultData);
                        }
                        statement.close();
                        if (blockState instanceof Sign && player.getGameMode() != GameMode.CREATIVE) {
                            Thread.sleep(1500L);
                            Sign sign = (Sign)blockState;
                            player.sendSignChange(sign.getLocation(), sign.getLines(), sign.getColor());
                        }
                    }
                }
                catch (BaseInspector.InspectionException e) {
                    Chat.sendMessage((CommandSender)player, e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.this$0.finishInspection(player);
                }
            }
        }
        BasicThread runnable = new BasicThread();
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void performAirBlockLookup(final Player player, final BlockState finalBlock) {
        class BasicThread
        implements Runnable {
            final /* synthetic */ BlockInspector this$0;

            BasicThread() {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.this$0.checkPreconditions(player);
                    try (Connection connection = this.this$0.getDatabaseConnection(player);){
                        Statement statement = connection.createStatement();
                        if (finalBlock.getType().name().endsWith("AIR")) {
                            String blockData = BlockLookup.performLookup(null, statement, finalBlock, (CommandSender)player, 0, 1, 7);
                            if (blockData.contains("\n")) {
                                for (String b : blockData.split("\n")) {
                                    Chat.sendComponent((CommandSender)player, b);
                                }
                            } else if (blockData.length() > 0) {
                                Chat.sendComponent((CommandSender)player, blockData);
                            }
                        } else {
                            String blockData = BlockLookup.performLookup(null, statement, finalBlock, (CommandSender)player, 0, 1, 7);
                            if (blockData.contains("\n")) {
                                for (String splitData : blockData.split("\n")) {
                                    Chat.sendComponent((CommandSender)player, splitData);
                                }
                            } else if (blockData.length() > 0) {
                                Chat.sendComponent((CommandSender)player, blockData);
                            }
                        }
                        statement.close();
                    }
                }
                catch (BaseInspector.InspectionException e) {
                    Chat.sendMessage((CommandSender)player, e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.this$0.finishInspection(player);
                }
            }
        }
        BasicThread runnable = new BasicThread();
        Thread thread = new Thread(runnable);
        thread.start();
    }
}

