/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.player;

import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.utility.WorldUtils;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBucketEmptyEvent;

public final class PlayerBucketEmptyListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        String player = event.getPlayer().getName();
        World world = event.getPlayer().getWorld();
        boolean inspect = false;
        if (ConfigHandler.inspecting.get(player) != null && ConfigHandler.inspecting.get(player).booleanValue()) {
            inspect = true;
            event.setCancelled(true);
        }
        if (!event.isCancelled() && Config.getConfig((World)world).BUCKETS && !inspect) {
            boolean isWaterlogged;
            Block block = event.getBlockClicked();
            BlockData blockData = block.getBlockData();
            Material type = Material.WATER;
            if (event.getBucket().equals((Object)Material.LAVA_BUCKET)) {
                type = Material.LAVA;
            }
            boolean getRelative = true;
            if (blockData instanceof Waterlogged && type.equals((Object)Material.WATER) && !(isWaterlogged = ((Waterlogged)blockData).isWaterlogged())) {
                getRelative = false;
            }
            if (getRelative) {
                block = block.getRelative(event.getBlockFace());
                blockData = block.getBlockData();
            }
            BlockState blockState = block.getState();
            int worldId = WorldUtils.getWorldId(block.getWorld().getName());
            int unixTimestamp = (int)(System.currentTimeMillis() / 1000L);
            if (type.equals((Object)Material.WATER) && blockData instanceof Waterlogged) {
                blockState = null;
            }
            CacheHandler.lookupCache.put(block.getX() + "." + block.getY() + "." + block.getZ() + "." + worldId, new Object[]{unixTimestamp, player, type});
            PlayerBucketEmptyListener.queueBlockPlace(player, block.getState(), block.getType(), blockState, type, 1, 1, null);
        }
    }
}

