/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.entity;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Locale;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.database.lookup.BlockLookup;
import net.coreprotect.language.Phrase;
import net.coreprotect.listener.player.PlayerInteractEntityListener;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.MaterialUtils;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.inventory.ItemStack;

public final class HangingBreakByEntityListener
extends Queue
implements Listener {
    static void inspectItemFrame(final BlockState block, final Player player) {
        class BasicThread
        implements Runnable {
            BasicThread() {
            }

            @Override
            public void run() {
                Object[] lookupThrottle;
                if (!player.hasPermission("coreprotect.inspect")) {
                    Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                    ConfigHandler.inspecting.put(player.getName(), false);
                    return;
                }
                if (ConfigHandler.converterRunning) {
                    Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
                    return;
                }
                if (ConfigHandler.purgeRunning) {
                    Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
                    return;
                }
                if (ConfigHandler.lookupThrottle.get(player.getName()) != null && (((Boolean)(lookupThrottle = ConfigHandler.lookupThrottle.get(player.getName()))[0]).booleanValue() || System.currentTimeMillis() - (Long)lookupThrottle[1] < 100L)) {
                    Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                    return;
                }
                ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{true, System.currentTimeMillis()});
                try (Connection connection = Database.getConnection(true);){
                    if (connection != null) {
                        Statement statement = connection.createStatement();
                        String blockData = BlockLookup.performLookup(null, statement, block, (CommandSender)player, 0, 1, 7);
                        if (blockData.contains("\n")) {
                            for (String b : blockData.split("\n")) {
                                Chat.sendComponent((CommandSender)player, b);
                            }
                        } else if (blockData.length() > 0) {
                            Chat.sendComponent((CommandSender)player, blockData);
                        }
                        statement.close();
                    } else {
                        Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{false, System.currentTimeMillis()});
            }
        }
        BasicThread runnable = new BasicThread();
        Thread thread = new Thread(runnable);
        thread.start();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        Player player;
        Hanging entity = event.getEntity();
        Entity remover = event.getRemover();
        BlockState blockEvent = event.getEntity().getLocation().getBlock().getState();
        boolean logDrops = true;
        boolean inspecting = false;
        if (event.getRemover() instanceof Player && ConfigHandler.inspecting.get((player = (Player)event.getRemover()).getName()) != null && ConfigHandler.inspecting.get(player.getName()).booleanValue()) {
            HangingBreakByEntityListener.inspectItemFrame(blockEvent, player);
            event.setCancelled(true);
            inspecting = true;
        }
        if (entity instanceof ItemFrame || entity instanceof Painting) {
            Material material;
            Object culprit = "#entity";
            if (remover != null) {
                if (remover instanceof Player) {
                    Player player2 = (Player)remover;
                    culprit = player2.getName();
                    logDrops = player2.getGameMode() != GameMode.CREATIVE;
                } else if (remover.getType() != null) {
                    culprit = "#" + remover.getType().name().toLowerCase(Locale.ROOT);
                }
            }
            String blockData = null;
            int itemData = 0;
            if (entity instanceof ItemFrame) {
                material = BukkitAdapter.ADAPTER.getFrameType((Entity)entity);
                ItemFrame itemframe = (ItemFrame)entity;
                blockData = "FACING=" + itemframe.getFacing().name();
                if (!event.isCancelled() && Config.getConfig((World)entity.getWorld()).ITEM_TRANSACTIONS && !inspecting && itemframe.getItem().getType() != Material.AIR) {
                    ItemStack[] oldState = new ItemStack[]{itemframe.getItem().clone()};
                    ItemStack[] newState = new ItemStack[]{new ItemStack(Material.AIR)};
                    PlayerInteractEntityListener.queueContainerSpecifiedItems((String)culprit, Material.ITEM_FRAME, new Object[]{oldState, newState, itemframe.getFacing()}, itemframe.getLocation(), logDrops);
                }
            } else {
                material = Material.PAINTING;
                Painting painting = (Painting)entity;
                blockData = "FACING=" + painting.getFacing().name();
                try {
                    itemData = MaterialUtils.getArtId(painting.getArt().toString(), true);
                }
                catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                    // empty catch block
                }
            }
            if (!event.isCancelled() && Config.getConfig((World)blockEvent.getWorld()).BLOCK_BREAK && !inspecting) {
                Queue.queueBlockBreak((String)culprit, blockEvent, material, blockData, itemData);
            }
        }
    }
}

