/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.block;

import java.util.ArrayList;
import java.util.Locale;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.listener.block.BlockUtil;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.paper.PaperAdapter;
import net.coreprotect.utility.BlockUtils;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Bell;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public final class BlockBreakListener
extends Queue
implements Listener {
    private static boolean isAttached(Block block, Block scanBlock, int scanMin) {
        BlockData blockData = scanBlock.getBlockData();
        if (blockData instanceof Directional && !(blockData instanceof Bisected) && scanMin != 6 && scanMin != 5) {
            Directional directional = (Directional)blockData;
            BlockFace blockFace = directional.getFacing();
            if (blockData instanceof Bed) {
                blockFace = ((Bed)blockData).getPart() == Bed.Part.FOOT ? blockFace.getOppositeFace() : blockFace;
            }
            return scanBlock.getRelative(blockFace.getOppositeFace()).getLocation().equals((Object)block.getLocation());
        }
        if (blockData instanceof MultipleFacing) {
            MultipleFacing multipleFacing = (MultipleFacing)blockData;
            for (BlockFace blockFace : multipleFacing.getFaces()) {
                boolean adjacent = scanBlock.getRelative(blockFace).getLocation().equals((Object)block.getLocation());
                if (!adjacent) continue;
                return true;
            }
            return false;
        }
        if (blockData instanceof Lantern) {
            boolean scan = false;
            switch (scanMin) {
                case 5: {
                    scan = !((Lantern)blockData).isHanging();
                    break;
                }
                case 6: {
                    scan = ((Lantern)blockData).isHanging();
                    break;
                }
            }
            return scan;
        }
        return BukkitAdapter.ADAPTER.isAttached(block, scanBlock, blockData, scanMin);
    }

    protected static void processBlockBreak(Player player, String user, Block block, boolean logBreak, int skipScan) {
        ArrayList<Block> placementMap = new ArrayList<Block>();
        Material type = block.getType();
        World world = block.getWorld();
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        int physics = 0;
        Location[] locationMap = new Location[]{new Location(world, (double)(x + 1), (double)y, (double)z), new Location(world, (double)(x - 1), (double)y, (double)z), new Location(world, (double)x, (double)y, (double)(z + 1)), new Location(world, (double)x, (double)y, (double)(z - 1)), new Location(world, (double)x, (double)(y + 1), (double)z), new Location(world, (double)x, (double)(y - 1), (double)z)};
        int scanMin = 1;
        int scanMax = 8;
        if (!Config.getConfig((World)world).NATURAL_BREAK) {
            scanMin = 7;
        }
        if (!logBreak) {
            scanMax = 7;
        }
        while (scanMin < scanMax) {
            Block blockLog = block;
            boolean scanDown = false;
            boolean log = true;
            if (scanMin == skipScan) {
                ++scanMin;
                continue;
            }
            if (scanMin < 7) {
                Location scanLocation = locationMap[scanMin - 1];
                Block scanBlock = world.getBlockAt(scanLocation);
                Material scanType = scanBlock.getType();
                if (scanMin == 5 && (scanType.hasGravity() || BukkitAdapter.ADAPTER.isSuspiciousBlock(scanType)) && Config.getConfig((World)world).BLOCK_MOVEMENT) {
                    int scanY = y + 2;
                    boolean topFound = false;
                    while (!topFound) {
                        Block topBlock = world.getBlockAt(x, scanY, z);
                        Material topMaterial = topBlock.getType();
                        if (!topMaterial.hasGravity() && !BukkitAdapter.ADAPTER.isSuspiciousBlock(topMaterial)) {
                            scanLocation = new Location(world, (double)x, (double)(scanY - 1), (double)z);
                            topFound = true;
                        }
                        ++scanY;
                    }
                    placementMap.add(scanBlock);
                }
                if (!BlockGroup.TRACK_ANY.contains(scanType)) {
                    if (scanMin != 5 && scanMin != 6 && !scanDown) {
                        if (!BlockGroup.TRACK_SIDE.contains(scanType)) {
                            log = false;
                        } else if (scanType.equals((Object)Material.RAIL) || scanType.equals((Object)Material.POWERED_RAIL) || scanType.equals((Object)Material.DETECTOR_RAIL) || scanType.equals((Object)Material.ACTIVATOR_RAIL)) {
                            BlockData blockData = scanBlock.getBlockData();
                            Rail rail = (Rail)blockData;
                            Rail.Shape shape = rail.getShape();
                            if (scanMin == 1 && shape != Rail.Shape.ASCENDING_WEST) {
                                log = false;
                            } else if (scanMin == 2 && shape != Rail.Shape.ASCENDING_EAST) {
                                log = false;
                            } else if (scanMin == 3 && shape != Rail.Shape.ASCENDING_NORTH) {
                                log = false;
                            } else if (scanMin == 4 && shape != Rail.Shape.ASCENDING_SOUTH) {
                                log = false;
                            }
                        } else if (scanType.name().endsWith("_BED") && !type.name().endsWith("_BED")) {
                            log = false;
                        } else if (!BlockBreakListener.isAttached(block, scanBlock, scanMin)) {
                            log = false;
                        }
                    } else if (BlockUtil.verticalBreakScan(player, user, block, scanBlock, scanType, scanMin)) {
                        log = false;
                    } else if (scanMin == 5 && !BlockGroup.TRACK_TOP.contains(scanType) && !BlockGroup.TRACK_TOP_BOTTOM.contains(scanType)) {
                        log = false;
                    } else if (scanMin == 6 && !BlockGroup.TRACK_BOTTOM.contains(scanType) && !BlockGroup.TRACK_TOP_BOTTOM.contains(scanType)) {
                        log = false;
                    } else if (scanMin == 4 && !BlockGroup.TRACK_TOP.contains(scanType)) {
                        log = false;
                    } else if (!BlockBreakListener.isAttached(block, scanBlock, scanMin)) {
                        log = false;
                    }
                    if (!log) {
                        if (type.equals((Object)Material.PISTON_HEAD)) {
                            if (scanType.equals((Object)Material.STICKY_PISTON) || scanType.equals((Object)Material.PISTON)) {
                                log = true;
                            }
                        } else if (scanMin == 5 && (scanType.hasGravity() || BukkitAdapter.ADAPTER.isSuspiciousBlock(scanType))) {
                            log = true;
                        }
                    }
                } else if (scanType.equals((Object)Material.PISTON_HEAD)) {
                    if (!type.equals((Object)Material.STICKY_PISTON) && !type.equals((Object)Material.PISTON)) {
                        log = false;
                    }
                } else if (scanType.equals((Object)Material.BELL)) {
                    boolean scanBell = false;
                    BlockData blockData = scanBlock.getBlockData();
                    Bell bell = (Bell)blockData;
                    switch (bell.getAttachment()) {
                        case SINGLE_WALL: {
                            scanBell = scanMin < 5 && scanBlock.getRelative(bell.getFacing()).getLocation().equals((Object)block.getLocation());
                            break;
                        }
                        case FLOOR: {
                            scanBell = scanMin == 5;
                            break;
                        }
                        case CEILING: {
                            scanBell = scanMin == 6;
                            break;
                        }
                    }
                    if (!scanBell) {
                        log = false;
                    }
                } else if (BlockGroup.BUTTONS.contains(scanType) || scanType == Material.LEVER) {
                    boolean scanButton = BukkitAdapter.ADAPTER.isAttached(block, scanBlock, scanBlock.getBlockData(), scanMin);
                    if (!scanButton) {
                        log = false;
                    }
                } else if (!BlockBreakListener.isAttached(block, scanBlock, scanMin)) {
                    log = false;
                }
                if (log) {
                    blockLog = world.getBlockAt(scanLocation);
                }
            }
            int blockNumber = scanMin;
            Material blockType = blockLog.getType();
            BlockState blockState = blockLog.getState();
            if (log && (blockType.name().toUpperCase(Locale.ROOT).endsWith("_BANNER") || blockType.equals((Object)Material.SKELETON_SKULL) || blockType.equals((Object)Material.SKELETON_WALL_SKULL) || blockType.equals((Object)Material.WITHER_SKELETON_SKULL) || blockType.equals((Object)Material.WITHER_SKELETON_WALL_SKULL) || blockType.equals((Object)Material.ZOMBIE_HEAD) || blockType.equals((Object)Material.ZOMBIE_WALL_HEAD) || blockType.equals((Object)Material.PLAYER_HEAD) || blockType.equals((Object)Material.PLAYER_WALL_HEAD) || blockType.equals((Object)Material.CREEPER_HEAD) || blockType.equals((Object)Material.CREEPER_WALL_HEAD) || blockType.equals((Object)Material.DRAGON_HEAD) || blockType.equals((Object)Material.DRAGON_WALL_HEAD))) {
                try {
                    if (blockState instanceof Banner || blockState instanceof Skull) {
                        Queue.queueAdvancedBreak(user, blockState, blockType, blockState.getBlockData().getAsString(), 0, type, blockNumber);
                    }
                    log = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (log && BukkitAdapter.ADAPTER.isSign(blockType) && Config.getConfig((World)world).SIGN_TEXT) {
                try {
                    Location location = blockState.getLocation();
                    Sign sign = (Sign)blockLog.getState();
                    String line1 = PaperAdapter.ADAPTER.getLine(sign, 0);
                    String line2 = PaperAdapter.ADAPTER.getLine(sign, 1);
                    String line3 = PaperAdapter.ADAPTER.getLine(sign, 2);
                    String line4 = PaperAdapter.ADAPTER.getLine(sign, 3);
                    String line5 = PaperAdapter.ADAPTER.getLine(sign, 4);
                    String line6 = PaperAdapter.ADAPTER.getLine(sign, 5);
                    String line7 = PaperAdapter.ADAPTER.getLine(sign, 6);
                    String line8 = PaperAdapter.ADAPTER.getLine(sign, 7);
                    boolean isFront = true;
                    int color = BukkitAdapter.ADAPTER.getColor(sign, isFront);
                    int colorSecondary = BukkitAdapter.ADAPTER.getColor(sign, !isFront);
                    boolean frontGlowing = BukkitAdapter.ADAPTER.isGlowing(sign, isFront);
                    boolean backGlowing = BukkitAdapter.ADAPTER.isGlowing(sign, !isFront);
                    boolean isWaxed = BukkitAdapter.ADAPTER.isWaxed(sign);
                    Queue.queueSignText(user, location, 0, color, colorSecondary, frontGlowing, backGlowing, isWaxed, isFront, line1, line2, line3, line4, line5, line6, line7, line8, 5);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (log) {
                Waterlogged waterlogged;
                BlockData blockDataB1;
                Database.containerBreakCheck(user, blockType, blockLog, null, blockLog.getLocation());
                Queue.queueBlockBreak(user, blockState, blockType, blockState.getBlockData().getAsString(), type, physics, blockNumber);
                if (player != null && BlockUtils.iceBreakCheck(blockState, user, blockType)) {
                    ItemStack handItem = player.getInventory().getItemInMainHand();
                    if (!(player.getGameMode().equals((Object)GameMode.CREATIVE) || handItem != null && handItem.containsEnchantment(Enchantment.SILK_TOUCH))) {
                        Queue.queueBlockPlaceValidate(user, blockState, blockLog, null, Material.WATER, -1, 0, null, 0);
                    }
                }
                if ((blockDataB1 = blockState.getBlockData()) instanceof Waterlogged && (waterlogged = (Waterlogged)blockDataB1).isWaterlogged()) {
                    Queue.queueBlockPlace(user, blockState, blockLog.getType(), null, Material.WATER, -1, 0, null);
                }
            }
            ++scanMin;
        }
        for (Block placementBlock : placementMap) {
            Material placementType = placementBlock.getType();
            if (!placementType.hasGravity()) continue;
            BlockBreakListener.queueBlockPlace(user, block.getState(), placementType, null, null, -1, 0, placementBlock.getBlockData().getAsString());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockBreak(BlockBreakEvent event) {
        if (!event.isCancelled()) {
            String user = event.getPlayer().getName();
            Block block = event.getBlock();
            BlockBreakListener.processBlockBreak(event.getPlayer(), user, event.getBlock(), Config.getConfig((World)block.getWorld()).BLOCK_BREAK, 0);
        }
    }
}

