/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database.rollback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.database.rollback.RollbackBlockHandler;
import net.coreprotect.database.rollback.RollbackEntityHandler;
import net.coreprotect.database.rollback.RollbackItemHandler;
import net.coreprotect.database.rollback.RollbackUtil;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.utility.BlockUtils;
import net.coreprotect.utility.ItemUtils;
import net.coreprotect.utility.MaterialUtils;
import net.coreprotect.utility.Teleport;
import net.coreprotect.utility.WorldUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Jukebox;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RollbackProcessor {
    public static boolean processChunk(int finalChunkX, int finalChunkZ, long chunkKey, ArrayList<Object[]> blockList, ArrayList<Object[]> itemList, int rollbackType, int preview, String finalUserString, Player finalUser, World bukkitRollbackWorld, boolean inventoryRollback) {
        try {
            boolean clearInventories = Config.getGlobal().ROLLBACK_ITEMS;
            ArrayList data = blockList != null ? blockList : new ArrayList();
            ArrayList itemData = itemList != null ? itemList : new ArrayList();
            LinkedHashMap<Block, BlockData> chunkChanges = new LinkedHashMap<Block, BlockData>();
            for (Object[] row : data) {
                Block block;
                World bukkitWorld;
                String world;
                int[] rollbackHashData = ConfigHandler.rollbackHash.get(finalUserString);
                int itemCount = rollbackHashData[0];
                int blockCount = rollbackHashData[1];
                int entityCount = rollbackHashData[2];
                int scannedWorlds = rollbackHashData[4];
                int rowX = (Integer)row[3];
                int rowY = (Integer)row[4];
                int rowZ = (Integer)row[5];
                int n = (Integer)row[6];
                int rowData = (Integer)row[7];
                int rowAction = (Integer)row[8];
                int rowRolledBack = MaterialUtils.rolledBack((Integer)row[9], false);
                int rowWorldId = (Integer)row[10];
                byte[] rowMeta = (byte[])row[12];
                byte[] rowBlockData = (byte[])row[13];
                String blockDataString = BlockUtils.byteDataToString(rowBlockData, n);
                Material rowType = MaterialUtils.getType(n);
                List<Object> meta = null;
                if (rowMeta != null) {
                    meta = RollbackUtil.deserializeMetadata(rowMeta);
                }
                BlockData blockData = null;
                if (blockDataString != null && blockDataString.contains(":")) {
                    try {
                        blockData = Bukkit.getServer().createBlockData(blockDataString);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                BlockData rawBlockData = null;
                if (blockData != null) {
                    rawBlockData = blockData.clone();
                }
                if (rawBlockData == null && rowType != null && rowType.isBlock()) {
                    rawBlockData = BlockUtils.createBlockData(rowType);
                }
                String rowUser = ConfigHandler.playerIdCacheReversed.get((Integer)row[2]);
                int oldTypeRaw = n;
                Material oldTypeMaterial = MaterialUtils.getType(oldTypeRaw);
                if (rowAction == 1 && rollbackType == 0) {
                    rowType = Material.AIR;
                    blockData = null;
                    n = 0;
                } else if (rowAction == 0 && rollbackType == 1) {
                    rowType = Material.AIR;
                    blockData = null;
                    n = 0;
                } else if (rowAction == 4 && rollbackType == 0) {
                    rowType = null;
                    n = 0;
                } else if (rowAction == 3 && rollbackType == 1) {
                    rowType = null;
                    n = 0;
                }
                if (preview > 0) {
                    if (rowAction != 3) {
                        world = WorldUtils.getWorldName(rowWorldId);
                        if (world.length() == 0 || (bukkitWorld = Bukkit.getServer().getWorld(world)) == null) continue;
                        block = new Location(bukkitWorld, (double)rowX, (double)rowY, (double)rowZ).getBlock();
                        if (preview == 2) {
                            Material blockType = block.getType();
                            if (!(BukkitAdapter.ADAPTER.isItemFrame(blockType) || blockType.equals((Object)Material.PAINTING) || blockType.equals((Object)Material.ARMOR_STAND) || blockType.equals((Object)Material.END_CRYSTAL))) {
                                BlockUtils.prepareTypeAndData(chunkChanges, block, blockType, block.getBlockData(), true);
                            }
                        } else if (!BukkitAdapter.ADAPTER.isItemFrame(rowType) && rowType != Material.PAINTING && rowType != Material.ARMOR_STAND && rowType != Material.END_CRYSTAL) {
                            BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                            ++blockCount;
                        }
                    }
                } else if (rowAction == 3) {
                    entityCount += RollbackEntityHandler.processEntity(row, rollbackType, finalUserString, oldTypeRaw, n, rowData, rowAction, MaterialUtils.rolledBack((Integer)row[9], false), rowX, rowY, rowZ, rowWorldId, (Integer)row[2], rowUser);
                } else {
                    world = WorldUtils.getWorldName(rowWorldId);
                    if (world.length() == 0 || (bukkitWorld = Bukkit.getServer().getWorld(world)) == null) continue;
                    block = bukkitWorld.getBlockAt(rowX, rowY, rowZ);
                    if (!bukkitWorld.isChunkLoaded(block.getChunk())) {
                        bukkitWorld.getChunkAt(block.getLocation());
                    }
                    boolean changeBlock = true;
                    boolean countBlock = true;
                    Material changeType = block.getType();
                    BlockData changeBlockData = block.getBlockData();
                    BlockData pendingChangeData = (BlockData)chunkChanges.get(block);
                    Material pendingChangeType = changeType;
                    if (pendingChangeData != null) {
                        pendingChangeType = pendingChangeData.getMaterial();
                    } else {
                        pendingChangeData = changeBlockData;
                    }
                    if (rowRolledBack == 1 && rollbackType == 0) {
                        countBlock = false;
                    }
                    if (rowType == pendingChangeType && !BukkitAdapter.ADAPTER.isItemFrame(oldTypeMaterial) && oldTypeMaterial != Material.PAINTING && oldTypeMaterial != Material.ARMOR_STAND && oldTypeMaterial != Material.END_CRYSTAL) {
                        BlockData checkData;
                        BlockData blockData2 = checkData = rowType == Material.AIR ? blockData : rawBlockData;
                        if (checkData != null) {
                            if ((checkData.getAsString().equals(pendingChangeData.getAsString()) || checkData instanceof MultipleFacing || checkData instanceof Stairs || checkData instanceof RedstoneWire) && rowType != Material.CHEST && rowType != Material.TRAPPED_CHEST && !BukkitAdapter.ADAPTER.isCopperChest(rowType)) {
                                changeBlock = false;
                            }
                        } else if (rowType == Material.AIR) {
                            changeBlock = false;
                        }
                        countBlock = false;
                    } else if (pendingChangeType != Material.AIR && pendingChangeType != Material.CAVE_AIR) {
                        countBlock = true;
                    }
                    if (pendingChangeType == Material.WATER && rowType != Material.AIR && rowType != Material.CAVE_AIR && blockData != null && blockData instanceof Waterlogged && Material.WATER.createBlockData().equals((Object)block.getBlockData())) {
                        Waterlogged waterlogged = (Waterlogged)blockData;
                        waterlogged.setWaterlogged(true);
                    }
                    if (RollbackBlockHandler.processBlockChange(bukkitWorld, block, row, rollbackType, clearInventories, chunkChanges, countBlock, oldTypeMaterial, pendingChangeType, pendingChangeData, finalUserString, rawBlockData, changeType, changeBlock, changeBlockData, meta != null ? new ArrayList<Object>(meta) : null, blockData, rowUser, rowType, rowX, rowY, rowZ, n, rowData, rowAction, rowWorldId, BlockUtils.byteDataToString((byte[])row[13], n)) && countBlock) {
                        ++blockCount;
                    }
                }
                ConfigHandler.rollbackHash.put(finalUserString, new int[]{itemCount, ++blockCount, ++entityCount, 0, scannedWorlds});
            }
            data.clear();
            RollbackBlockHandler.applyBlockChanges(chunkChanges, preview, (Player)(finalUser instanceof Player ? finalUser : null));
            HashMap<Player, List> sortPlayers = new HashMap<Player, List>();
            Object container = null;
            Material containerType = null;
            boolean containerInit = false;
            int lastX = 0;
            int lastY = 0;
            int lastZ = 0;
            int lastWorldId = 0;
            String lastFace = "";
            for (Object[] objectArray : itemData) {
                int[] rollbackHashData1 = ConfigHandler.rollbackHash.get(finalUserString);
                int itemCount1 = rollbackHashData1[0];
                int blockCount1 = rollbackHashData1[1];
                int entityCount1 = rollbackHashData1[2];
                int scannedWorlds = rollbackHashData1[4];
                int rowX = (Integer)objectArray[3];
                int rowY = (Integer)objectArray[4];
                int rowZ = (Integer)objectArray[5];
                int rowTypeRaw = (Integer)objectArray[6];
                int rowData = (Integer)objectArray[7];
                int rowAction = (Integer)objectArray[8];
                int rowRolledBack = MaterialUtils.rolledBack((Integer)objectArray[9], false);
                int rowWorldId = (Integer)objectArray[10];
                int rowAmount = (Integer)objectArray[11];
                byte[] rowMetadata = (byte[])objectArray[12];
                Material rowType = MaterialUtils.getType(rowTypeRaw);
                int rolledBackInventory = MaterialUtils.rolledBack((Integer)objectArray[9], true);
                if (rowType != null) {
                    if (inventoryRollback && (rollbackType == 0 && rolledBackInventory == 0 || rollbackType == 1 && rolledBackInventory == 1)) {
                        int modifiedArmor;
                        Player player;
                        String uuid;
                        Material inventoryItem = ItemUtils.itemFilter(rowType, (Integer)objectArray[14] == 0);
                        int rowUserId = (Integer)objectArray[2];
                        String rowUser = ConfigHandler.playerIdCacheReversed.get(rowUserId);
                        if (rowUser == null || (uuid = ConfigHandler.uuidCache.get(rowUser.toLowerCase(Locale.ROOT))) == null || (player = Bukkit.getServer().getPlayer(UUID.fromString(uuid))) == null) continue;
                        int inventoryAction = 0;
                        inventoryAction = rowAction == 2 || rowAction == 3 || rowAction == 6 || rowAction == 7 || rowAction == 8 || rowAction == 9 || rowAction == 10 || rowAction == 11 || rowAction == 12 ? (rowAction == 3 || rowAction == 10 || rowAction == 12 ? 1 : 0) : (rowAction == 4 || rowAction == 5 ? (rowAction == 4 ? 1 : 0) : (rowAction == 0 ? 1 : 0));
                        int action = rollbackType == 0 ? inventoryAction ^ 1 : inventoryAction;
                        ItemStack itemstack = new ItemStack(inventoryItem, rowAmount);
                        Object[] populatedStack = RollbackItemHandler.populateItemStack(itemstack, rowMetadata);
                        if (rowAction == 4 || rowAction == 5) {
                            RollbackUtil.modifyContainerItems(containerType, player.getEnderChest(), (Integer)populatedStack[0], ((ItemStack)populatedStack[2]).clone(), action ^ 1);
                        }
                        if ((modifiedArmor = RollbackUtil.modifyContainerItems(containerType, player.getInventory(), (Integer)populatedStack[0], (ItemStack)populatedStack[2], action)) > -1) {
                            List currentSortList = sortPlayers.getOrDefault(player, new ArrayList());
                            if (!currentSortList.contains(modifiedArmor)) {
                                currentSortList.add(modifiedArmor);
                            }
                            sortPlayers.put(player, currentSortList);
                        }
                        ConfigHandler.rollbackHash.put(finalUserString, new int[]{itemCount1 += rowAmount, blockCount1, entityCount1, 0, scannedWorlds});
                        continue;
                    }
                    if (inventoryRollback || rowAction > 1) continue;
                    if (rollbackType == 0 && rowRolledBack == 0 || rollbackType == 1 && rowRolledBack == 1) {
                        ItemStack itemstack = new ItemStack(rowType, rowAmount);
                        Object[] populatedStack = RollbackItemHandler.populateItemStack(itemstack, rowMetadata);
                        String faceData = (String)populatedStack[1];
                        if (!containerInit || rowX != lastX || rowY != lastY || rowZ != lastZ || rowWorldId != lastWorldId || !faceData.equals(lastFace)) {
                            World bukkitWorld;
                            container = null;
                            String world = WorldUtils.getWorldName(rowWorldId);
                            if (world.length() == 0 || (bukkitWorld = Bukkit.getServer().getWorld(world)) == null) continue;
                            Block block = bukkitWorld.getBlockAt(rowX, rowY, rowZ);
                            if (!bukkitWorld.isChunkLoaded(block.getChunk())) {
                                bukkitWorld.getChunkAt(block.getLocation());
                            }
                            if (BlockGroup.CONTAINERS.contains(block.getType())) {
                                BlockState blockState = block.getState();
                                container = blockState instanceof Jukebox ? blockState : BlockUtils.getContainerInventory(blockState, false);
                                containerType = block.getType();
                            } else if (BlockGroup.CONTAINERS.contains(Material.ARMOR_STAND) || BlockGroup.CONTAINERS.contains(Material.ITEM_FRAME)) {
                                for (Entity entity : block.getChunk().getEntities()) {
                                    if (entity.getLocation().getBlockX() != rowX || entity.getLocation().getBlockY() != rowY || entity.getLocation().getBlockZ() != rowZ) continue;
                                    if (entity instanceof ArmorStand) {
                                        container = ItemUtils.getEntityEquipment((LivingEntity)entity);
                                        containerType = Material.ARMOR_STAND;
                                        continue;
                                    }
                                    if (!(entity instanceof ItemFrame)) continue;
                                    container = entity;
                                    containerType = Material.ITEM_FRAME;
                                    if (faceData.length() > 0 && BlockFace.valueOf((String)faceData) == ((ItemFrame)entity).getFacing()) break;
                                }
                            }
                            lastX = rowX;
                            lastY = rowY;
                            lastZ = rowZ;
                            lastWorldId = rowWorldId;
                            lastFace = faceData;
                        }
                        if (container != null) {
                            int action = 0;
                            if (rollbackType == 0 && rowAction == 0) {
                                action = 1;
                            }
                            if (rollbackType == 1 && rowAction == 1) {
                                action = 1;
                            }
                            int slot = (Integer)populatedStack[0];
                            itemstack = (ItemStack)populatedStack[2];
                            RollbackUtil.modifyContainerItems(containerType, container, slot, itemstack, action);
                            itemCount1 += rowAmount;
                        }
                        containerInit = true;
                    }
                }
                ConfigHandler.rollbackHash.put(finalUserString, new int[]{itemCount1, blockCount1, entityCount1, 0, scannedWorlds});
            }
            itemData.clear();
            for (Map.Entry entry : sortPlayers.entrySet()) {
                RollbackItemHandler.sortContainerItems(((Player)entry.getKey()).getInventory(), (List)entry.getValue());
            }
            sortPlayers.clear();
            int[] rollbackHashData = ConfigHandler.rollbackHash.get(finalUserString);
            int n = rollbackHashData[0];
            int blockCount = rollbackHashData[1];
            int entityCount = rollbackHashData[2];
            int scannedWorlds = rollbackHashData[4];
            ConfigHandler.rollbackHash.put(finalUserString, new int[]{n, blockCount, entityCount, 1, scannedWorlds + 1});
            if (preview == 0) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Location playerLocation = player.getLocation();
                    String playerWorld = playerLocation.getWorld().getName();
                    int chunkX = playerLocation.getBlockX() >> 4;
                    int chunkZ = playerLocation.getBlockZ() >> 4;
                    if (!bukkitRollbackWorld.getName().equals(playerWorld) || chunkX != finalChunkX || chunkZ != finalChunkZ) continue;
                    Teleport.performSafeTeleport(player, playerLocation, false);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            int[] rollbackHashData = ConfigHandler.rollbackHash.get(finalUserString);
            int itemCount = rollbackHashData[0];
            int blockCount = rollbackHashData[1];
            int entityCount = rollbackHashData[2];
            int scannedWorlds = rollbackHashData[4];
            ConfigHandler.rollbackHash.put(finalUserString, new int[]{itemCount, blockCount, entityCount, 2, scannedWorlds + 1});
            return false;
        }
    }
}

