/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database.rollback;

import java.util.ArrayList;
import java.util.Map;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.rollback.RollbackUtil;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.paper.PaperAdapter;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.utility.BlockUtils;
import net.coreprotect.utility.ChestTool;
import net.coreprotect.utility.EntityUtils;
import net.coreprotect.utility.ItemUtils;
import net.coreprotect.utility.Util;
import net.coreprotect.utility.entity.HangingUtil;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.block.data.type.Snow;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.block.data.type.TechnicalPiston;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RollbackBlockHandler
extends Queue {
    public static boolean processBlockChange(World bukkitWorld, Block block, Object[] row, int rollbackType, boolean clearInventories, Map<Block, BlockData> chunkChanges, boolean countBlock, Material oldTypeMaterial, Material pendingChangeType, BlockData pendingChangeData, String finalUserString, BlockData rawBlockData, Material changeType, boolean changeBlock, BlockData changeBlockData, ArrayList<Object> meta, BlockData blockData, String rowUser, Material rowType, int rowX, int rowY, int rowZ, int rowTypeRaw, int rowData, int rowAction, int rowWorldId, String blockDataString) {
        int unixtimestamp;
        block96: {
            unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            try {
                Bed bed;
                Object face;
                Inventory inventory;
                Waterlogged waterlogged;
                Entity entity;
                Location location1;
                if (!changeBlock) break block96;
                if (changeBlockData instanceof PistonHead) {
                    PistonHead pistonHead = (PistonHead)changeBlockData;
                    Block pistonBlock = block.getRelative(pistonHead.getFacing().getOppositeFace());
                    Entity[] pistonData = pistonBlock.getBlockData();
                    if (pistonData instanceof Piston) {
                        Piston piston = (Piston)pistonData;
                        piston.setExtended(false);
                        pistonBlock.setBlockData((BlockData)piston, false);
                    }
                } else if (rowType == Material.MOVING_PISTON && blockData instanceof TechnicalPiston && !(blockData instanceof PistonHead)) {
                    TechnicalPiston technicalPiston = (TechnicalPiston)blockData;
                    rowType = technicalPiston.getType() == TechnicalPiston.Type.STICKY ? Material.STICKY_PISTON : Material.PISTON;
                    blockData = rowType.createBlockData();
                    ((Piston)blockData).setFacing(technicalPiston.getFacing());
                }
                if (rowType == Material.AIR && (BukkitAdapter.ADAPTER.isItemFrame(oldTypeMaterial) || oldTypeMaterial == Material.PAINTING)) {
                    HangingUtil.removeHanging(block.getState(), blockDataString);
                    break block96;
                }
                if (BukkitAdapter.ADAPTER.isItemFrame(rowType) || rowType == Material.PAINTING) {
                    HangingUtil.spawnHanging(block.getState(), rowType, blockDataString, rowData);
                    break block96;
                }
                if (rowType == Material.ARMOR_STAND) {
                    location1 = block.getLocation();
                    location1.setX(location1.getX() + 0.5);
                    location1.setZ(location1.getZ() + 0.5);
                    location1.setYaw((float)rowData);
                    boolean exists = false;
                    for (Entity entity2 : block.getChunk().getEntities()) {
                        if (!(entity2 instanceof ArmorStand) || entity2.getLocation().getBlockX() != location1.getBlockX() || entity2.getLocation().getBlockY() != location1.getBlockY() || entity2.getLocation().getBlockZ() != location1.getBlockZ()) continue;
                        exists = true;
                    }
                    if (!exists) {
                        entity = block.getLocation().getWorld().spawnEntity(location1, EntityType.ARMOR_STAND);
                        PaperAdapter.ADAPTER.teleportAsync(entity, location1);
                    }
                    break block96;
                }
                if (rowType == Material.END_CRYSTAL) {
                    location1 = block.getLocation();
                    location1.setX(location1.getX() + 0.5);
                    location1.setZ(location1.getZ() + 0.5);
                    boolean exists = false;
                    for (Entity entity3 : block.getChunk().getEntities()) {
                        if (!(entity3 instanceof EnderCrystal) || entity3.getLocation().getBlockX() != location1.getBlockX() || entity3.getLocation().getBlockY() != location1.getBlockY() || entity3.getLocation().getBlockZ() != location1.getBlockZ()) continue;
                        exists = true;
                    }
                    if (!exists) {
                        entity = block.getLocation().getWorld().spawnEntity(location1, BukkitAdapter.ADAPTER.getEntityType(Material.END_CRYSTAL));
                        EnderCrystal enderCrystal = (EnderCrystal)entity;
                        enderCrystal.setShowingBottom(rowData != 0);
                        PaperAdapter.ADAPTER.teleportAsync(entity, location1);
                    }
                    break block96;
                }
                if (rowType == Material.AIR && oldTypeMaterial == Material.WATER) {
                    if (pendingChangeData instanceof Waterlogged) {
                        waterlogged = (Waterlogged)pendingChangeData;
                        waterlogged.setWaterlogged(false);
                        BlockUtils.prepareTypeAndData(chunkChanges, block, null, (BlockData)waterlogged, false);
                    } else {
                        BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                    }
                    return countBlock;
                }
                if (rowType == Material.AIR && oldTypeMaterial == Material.SNOW) {
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                    return countBlock;
                }
                if (rowType == Material.AIR && oldTypeMaterial == Material.END_CRYSTAL) {
                    for (Entity entity4 : block.getChunk().getEntities()) {
                        if (!(entity4 instanceof EnderCrystal) || entity4.getLocation().getBlockX() != rowX || entity4.getLocation().getBlockY() != rowY || entity4.getLocation().getBlockZ() != rowZ) continue;
                        entity4.remove();
                    }
                    break block96;
                }
                if (rollbackType == 0 && rowAction == 0 && rowType == Material.AIR) break block96;
                if (rowType == Material.AIR || rowType == Material.TNT) {
                    if (clearInventories) {
                        if (BlockGroup.CONTAINERS.contains(changeType)) {
                            inventory = BlockUtils.getContainerInventory(block.getState(), false);
                            if (inventory != null) {
                                inventory.clear();
                            }
                        } else if (BlockGroup.CONTAINERS.contains(Material.ARMOR_STAND) && oldTypeMaterial == Material.ARMOR_STAND) {
                            for (Entity entity4 : block.getChunk().getEntities()) {
                                if (!(entity4 instanceof ArmorStand)) continue;
                                Location entityLocation = entity4.getLocation();
                                entityLocation.setY(entityLocation.getY() + 0.99);
                                if (entityLocation.getBlockX() != rowX || entityLocation.getBlockY() != rowY || entityLocation.getBlockZ() != rowZ) continue;
                                ItemUtils.getEntityEquipment((LivingEntity)((ArmorStand)entity4)).clear();
                                entityLocation.setY(entityLocation.getY() - 1.99);
                                PaperAdapter.ADAPTER.teleportAsync(entity4, entityLocation);
                                entity4.remove();
                            }
                        }
                    }
                    boolean remove = true;
                    if (rowType == Material.AIR) {
                        Waterlogged waterlogged2;
                        if (pendingChangeData instanceof Waterlogged) {
                            waterlogged2 = (Waterlogged)pendingChangeData;
                            if (waterlogged2.isWaterlogged()) {
                                BlockUtils.prepareTypeAndData(chunkChanges, block, Material.WATER, Material.WATER.createBlockData(), true);
                                remove = false;
                            }
                        } else if (pendingChangeType == Material.WATER && rawBlockData instanceof Waterlogged && (waterlogged2 = (Waterlogged)rawBlockData).isWaterlogged()) {
                            remove = false;
                        }
                    }
                    if (remove) {
                        Bed bed2;
                        boolean physics = true;
                        if (changeType == Material.NETHER_PORTAL || changeBlockData instanceof MultipleFacing || changeBlockData instanceof Snow || changeBlockData instanceof Stairs || changeBlockData instanceof RedstoneWire || changeBlockData instanceof Chest) {
                            physics = true;
                        } else if (changeBlockData instanceof Bisected && !(changeBlockData instanceof TrapDoor)) {
                            Bisected bisected = (Bisected)changeBlockData;
                            Location bisectLocation = block.getLocation().clone();
                            if (bisected.getHalf() == Bisected.Half.TOP) {
                                bisectLocation.setY(bisectLocation.getY() - 1.0);
                            } else {
                                bisectLocation.setY(bisectLocation.getY() + 1.0);
                            }
                            int worldMaxHeight = bukkitWorld.getMaxHeight();
                            int worldMinHeight = BukkitAdapter.ADAPTER.getMinHeight(bukkitWorld);
                            if (bisectLocation.getBlockY() >= worldMinHeight && bisectLocation.getBlockY() < worldMaxHeight) {
                                Block bisectBlock = block.getWorld().getBlockAt(bisectLocation);
                                BlockUtils.prepareTypeAndData(chunkChanges, bisectBlock, rowType, null, false);
                                if (countBlock) {
                                    RollbackBlockHandler.updateBlockCount(finalUserString, 1);
                                }
                            }
                        } else if (changeBlockData instanceof Bed && (bed2 = (Bed)changeBlockData).getPart() == Bed.Part.FOOT) {
                            Block adjacentBlock = block.getRelative(bed2.getFacing());
                            BlockUtils.prepareTypeAndData(chunkChanges, adjacentBlock, rowType, null, false);
                        }
                        BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, null, physics);
                    }
                    return countBlock;
                }
                if (rowType == Material.SPAWNER) {
                    try {
                        BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                        CreatureSpawner mobSpawner = (CreatureSpawner)block.getState();
                        mobSpawner.setSpawnedType(EntityUtils.getSpawnerType(rowData));
                        mobSpawner.update();
                        return countBlock;
                    }
                    catch (Exception mobSpawner) {
                        break block96;
                    }
                }
                if (rowType == Material.SKELETON_SKULL || rowType == Material.SKELETON_WALL_SKULL || rowType == Material.WITHER_SKELETON_SKULL || rowType == Material.WITHER_SKELETON_WALL_SKULL || rowType == Material.ZOMBIE_HEAD || rowType == Material.ZOMBIE_WALL_HEAD || rowType == Material.PLAYER_HEAD || rowType == Material.PLAYER_WALL_HEAD || rowType == Material.CREEPER_HEAD || rowType == Material.CREEPER_WALL_HEAD || rowType == Material.DRAGON_HEAD || rowType == Material.DRAGON_WALL_HEAD) {
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                    if (rowData > 0) {
                        Queue.queueSkullUpdate(rowUser, block.getState(), rowData);
                    }
                    return countBlock;
                }
                if (BukkitAdapter.ADAPTER.isSign(rowType)) {
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                    Queue.queueSignUpdate(rowUser, block.getState(), rollbackType, (Integer)row[1]);
                    return countBlock;
                }
                if (BlockGroup.SHULKER_BOXES.contains(rowType)) {
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                    if (countBlock) {
                        RollbackBlockHandler.updateBlockCount(finalUserString, 1);
                    }
                    if (meta != null) {
                        inventory = BlockUtils.getContainerInventory(block.getState(), false);
                        for (Object value : meta) {
                            ItemStack item = ItemUtils.unserializeItemStackLegacy(value);
                            if (item == null) continue;
                            RollbackUtil.modifyContainerItems(rowType, inventory, 0, item, 1);
                        }
                    }
                    return false;
                }
                if (rowType == Material.COMMAND_BLOCK || rowType == Material.REPEATING_COMMAND_BLOCK || rowType == Material.CHAIN_COMMAND_BLOCK) {
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                    if (countBlock) {
                        RollbackBlockHandler.updateBlockCount(finalUserString, 1);
                    }
                    if (meta != null) {
                        CommandBlock commandBlock = (CommandBlock)block.getState();
                        for (Object value : meta) {
                            if (!(value instanceof String)) continue;
                            String string = (String)value;
                            commandBlock.setCommand(string);
                            commandBlock.update();
                        }
                    }
                    return false;
                }
                if (rowType == Material.WATER) {
                    if (pendingChangeData instanceof Waterlogged) {
                        waterlogged = (Waterlogged)pendingChangeData;
                        waterlogged.setWaterlogged(true);
                        BlockUtils.prepareTypeAndData(chunkChanges, block, null, (BlockData)waterlogged, false);
                    } else {
                        BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                    }
                    return countBlock;
                }
                if (rowType == Material.NETHER_PORTAL && rowAction == 0) {
                    BlockUtils.prepareTypeAndData(chunkChanges, block, Material.FIRE, null, true);
                    break block96;
                }
                if (blockData == null && rowData > 0 && (rowType == Material.IRON_DOOR || BlockGroup.DOORS.contains(rowType))) {
                    if (countBlock) {
                        RollbackBlockHandler.updateBlockCount(finalUserString, 1);
                    }
                    block.setType(rowType, false);
                    Door door = (Door)block.getBlockData();
                    if (rowData >= 8) {
                        door.setHalf(Bisected.Half.TOP);
                        rowData -= 8;
                    } else {
                        door.setHalf(Bisected.Half.BOTTOM);
                    }
                    if (rowData >= 4) {
                        door.setHinge(Door.Hinge.RIGHT);
                        rowData -= 4;
                    } else {
                        door.setHinge(Door.Hinge.LEFT);
                    }
                    face = BlockFace.NORTH;
                    switch (rowData) {
                        case 0: {
                            face = BlockFace.EAST;
                            break;
                        }
                        case 1: {
                            face = BlockFace.SOUTH;
                            break;
                        }
                        case 2: {
                            face = BlockFace.WEST;
                        }
                    }
                    door.setFacing((BlockFace)face);
                    door.setOpen(false);
                    block.setBlockData((BlockData)door, false);
                    return false;
                }
                if (blockData == null && rowData > 0 && rowType.name().endsWith("_BED")) {
                    if (countBlock) {
                        RollbackBlockHandler.updateBlockCount(finalUserString, 1);
                    }
                    block.setType(rowType, false);
                    bed = (Bed)block.getBlockData();
                    face = BlockFace.NORTH;
                    if (rowData > 4) {
                        bed.setPart(Bed.Part.HEAD);
                        rowData -= 4;
                    }
                    switch (rowData) {
                        case 2: {
                            face = BlockFace.WEST;
                            break;
                        }
                        case 3: {
                            face = BlockFace.EAST;
                            break;
                        }
                        case 4: {
                            face = BlockFace.SOUTH;
                        }
                    }
                    bed.setFacing((BlockFace)face);
                    block.setBlockData((BlockData)bed, false);
                    return false;
                }
                if (rowType.name().endsWith("_BANNER")) {
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                    if (countBlock) {
                        RollbackBlockHandler.updateBlockCount(finalUserString, 1);
                    }
                    if (meta != null) {
                        Banner banner = (Banner)block.getState();
                        for (Object value : meta) {
                            if (value instanceof DyeColor) {
                                banner.setBaseColor((DyeColor)value);
                                continue;
                            }
                            if (!(value instanceof Map)) continue;
                            Pattern pattern = new Pattern((Map)value);
                            banner.addPattern(pattern);
                        }
                        banner.update();
                    }
                    return false;
                }
                if (rowType != changeType && (BlockGroup.CONTAINERS.contains(rowType) || BlockGroup.CONTAINERS.contains(changeType))) {
                    block.setType(Material.AIR);
                    boolean isChest = blockData instanceof Chest;
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, isChest);
                    if (isChest) {
                        ChestTool.updateDoubleChest(block, blockData, false);
                    }
                    return countBlock;
                }
                if (BlockGroup.UPDATE_STATE.contains(rowType) || rowType.name().contains("CANDLE")) {
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                    ChestTool.updateDoubleChest(block, blockData, true);
                    return countBlock;
                }
                if (rowType != Material.AIR && rawBlockData instanceof Bisected && !(rawBlockData instanceof Stairs) && !(rawBlockData instanceof TrapDoor)) {
                    Bisected bisected = (Bisected)rawBlockData;
                    Bisected bisectData = (Bisected)rawBlockData.clone();
                    Location bisectLocation = block.getLocation().clone();
                    if (bisected.getHalf() == Bisected.Half.TOP) {
                        bisectData.setHalf(Bisected.Half.BOTTOM);
                        bisectLocation.setY(bisectLocation.getY() - 1.0);
                    } else {
                        bisectData.setHalf(Bisected.Half.TOP);
                        bisectLocation.setY(bisectLocation.getY() + 1.0);
                    }
                    int worldMaxHeight = bukkitWorld.getMaxHeight();
                    int worldMinHeight = BukkitAdapter.ADAPTER.getMinHeight(bukkitWorld);
                    if (bisectLocation.getBlockY() >= worldMinHeight && bisectLocation.getBlockY() < worldMaxHeight) {
                        Block bisectBlock = block.getWorld().getBlockAt(bisectLocation);
                        BlockUtils.prepareTypeAndData(chunkChanges, bisectBlock, rowType, (BlockData)bisectData, false);
                    }
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                    if (countBlock) {
                        RollbackBlockHandler.updateBlockCount(finalUserString, 2);
                    }
                    return false;
                }
                if (rowType != Material.AIR && rawBlockData instanceof Bed) {
                    bed = (Bed)rawBlockData;
                    if (bed.getPart() == Bed.Part.FOOT) {
                        Block adjacentBlock = block.getRelative(bed.getFacing());
                        Bed bedData = (Bed)rawBlockData.clone();
                        bedData.setPart(Bed.Part.HEAD);
                        BlockUtils.prepareTypeAndData(chunkChanges, adjacentBlock, rowType, (BlockData)bedData, false);
                        if (countBlock) {
                            RollbackBlockHandler.updateBlockCount(finalUserString, 1);
                        }
                    }
                    BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                    return countBlock;
                }
                boolean physics = true;
                BlockUtils.prepareTypeAndData(chunkChanges, block, rowType, blockData, physics);
                return countBlock;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (rowType != Material.AIR && changeBlock && rowUser.length() > 0) {
            CacheHandler.lookupCache.put(rowX + "." + rowY + "." + rowZ + "." + rowWorldId, new Object[]{unixtimestamp, rowUser, rowType});
        }
        return countBlock;
    }

    protected static void updateBlockCount(String userString, int increment) {
        int[] rollbackHashData = ConfigHandler.rollbackHash.get(userString);
        int itemCount = rollbackHashData[0];
        int blockCount = rollbackHashData[1];
        int entityCount = rollbackHashData[2];
        int scannedWorlds = rollbackHashData[4];
        ConfigHandler.rollbackHash.put(userString, new int[]{itemCount, blockCount += increment, entityCount, 0, scannedWorlds});
    }

    public static void applyBlockChanges(Map<Block, BlockData> chunkChanges, int preview, Player user) {
        for (Map.Entry<Block, BlockData> chunkChange : chunkChanges.entrySet()) {
            Block changeBlock = chunkChange.getKey();
            BlockData changeBlockData = chunkChange.getValue();
            if (preview > 0 && user != null) {
                Util.sendBlockChange(user, changeBlock.getLocation(), changeBlockData);
                continue;
            }
            BlockUtils.setTypeAndData(changeBlock, null, changeBlockData, true);
        }
        chunkChanges.clear();
    }
}

