/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.statement.UserStatement;
import net.coreprotect.listener.channel.PluginChannelHandshakeListener;
import net.coreprotect.utility.EntityUtils;
import net.coreprotect.utility.MaterialUtils;
import net.coreprotect.utility.WorldUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class LookupRaw
extends Queue {
    protected static List<Object[]> performLookupRaw(Statement statement, CommandSender user, List<String> checkUuids, List<String> checkUsers, List<Object> restrictList, Map<Object, Boolean> excludeList, List<String> excludeUserList, List<Integer> actionList, Location location, Integer[] radius, Long[] rowData, long startTime, long endTime, int limitOffset, int limitCount, boolean restrictWorld, boolean lookup) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        ArrayList<Integer> invalidRollbackActions = new ArrayList<Integer>();
        invalidRollbackActions.add(2);
        if (!Config.getGlobal().ROLLBACK_ENTITIES && !actionList.contains(3)) {
            invalidRollbackActions.add(3);
        }
        if (actionList.contains(4) && actionList.contains(11)) {
            invalidRollbackActions.clear();
        }
        try {
            while (Consumer.isPaused) {
                Thread.sleep(1L);
            }
            Consumer.isPaused = true;
            ResultSet results = LookupRaw.rawLookupResultSet(statement, user, checkUuids, checkUsers, restrictList, excludeList, excludeUserList, actionList, location, radius, rowData, startTime, endTime, limitOffset, limitCount, restrictWorld, lookup, false);
            while (results.next()) {
                Object[] dataArray;
                int resultAction;
                int resultZ;
                int resultY;
                int resultTime;
                if (actionList.contains(6) || actionList.contains(7)) {
                    long resultId = results.getLong("id");
                    resultTime = results.getInt("time");
                    int resultUserId = results.getInt("user");
                    String resultMessage = results.getString("message");
                    Object[] dataArray2 = new Object[]{resultId, resultTime, resultUserId, resultMessage};
                    if (PluginChannelHandshakeListener.getInstance().isPluginChannelPlayer(user)) {
                        int resultWorldId = results.getInt("wid");
                        int resultX = results.getInt("x");
                        int resultY2 = results.getInt("y");
                        int resultZ2 = results.getInt("z");
                        dataArray2 = new Object[]{resultId, resultTime, resultUserId, resultMessage, resultWorldId, resultX, resultY2, resultZ2};
                    }
                    list.add(dataArray2);
                    continue;
                }
                if (actionList.contains(8)) {
                    long resultId = results.getLong("id");
                    resultTime = results.getInt("time");
                    int resultUserId = results.getInt("user");
                    int resultWorldId = results.getInt("wid");
                    int resultX = results.getInt("x");
                    resultY = results.getInt("y");
                    resultZ = results.getInt("z");
                    resultAction = results.getInt("action");
                    Object[] dataArray3 = new Object[]{resultId, resultTime, resultUserId, resultWorldId, resultX, resultY, resultZ, resultAction};
                    list.add(dataArray3);
                    continue;
                }
                if (actionList.contains(9)) {
                    long resultId = results.getLong("id");
                    resultTime = results.getInt("time");
                    String resultUuid = results.getString("uuid");
                    String resultUser = results.getString("user");
                    Object[] dataArray4 = new Object[]{resultId, resultTime, resultUuid, resultUser};
                    list.add(dataArray4);
                    continue;
                }
                if (actionList.contains(10)) {
                    long resultId = results.getLong("id");
                    resultTime = results.getInt("time");
                    int resultUserId = results.getInt("user");
                    int resultWorldId = results.getInt("wid");
                    int resultX = results.getInt("x");
                    resultY = results.getInt("y");
                    resultZ = results.getInt("z");
                    boolean isFront = results.getInt("face") == 0;
                    String line1 = results.getString("line_1");
                    String line2 = results.getString("line_2");
                    String line3 = results.getString("line_3");
                    String line4 = results.getString("line_4");
                    String line5 = results.getString("line_5");
                    String line6 = results.getString("line_6");
                    String line7 = results.getString("line_7");
                    String line8 = results.getString("line_8");
                    StringBuilder message = new StringBuilder();
                    if (isFront && line1 != null && line1.length() > 0) {
                        message.append(line1);
                        if (!line1.endsWith(" ")) {
                            message.append(" ");
                        }
                    }
                    if (isFront && line2 != null && line2.length() > 0) {
                        message.append(line2);
                        if (!line2.endsWith(" ")) {
                            message.append(" ");
                        }
                    }
                    if (isFront && line3 != null && line3.length() > 0) {
                        message.append(line3);
                        if (!line3.endsWith(" ")) {
                            message.append(" ");
                        }
                    }
                    if (isFront && line4 != null && line4.length() > 0) {
                        message.append(line4);
                        if (!line4.endsWith(" ")) {
                            message.append(" ");
                        }
                    }
                    if (!isFront && line5 != null && line5.length() > 0) {
                        message.append(line5);
                        if (!line5.endsWith(" ")) {
                            message.append(" ");
                        }
                    }
                    if (!isFront && line6 != null && line6.length() > 0) {
                        message.append(line6);
                        if (!line6.endsWith(" ")) {
                            message.append(" ");
                        }
                    }
                    if (!isFront && line7 != null && line7.length() > 0) {
                        message.append(line7);
                        if (!line7.endsWith(" ")) {
                            message.append(" ");
                        }
                    }
                    if (!isFront && line8 != null && line8.length() > 0) {
                        message.append(line8);
                        if (!line8.endsWith(" ")) {
                            message.append(" ");
                        }
                    }
                    dataArray = new Object[]{resultId, resultTime, resultUserId, resultWorldId, resultX, resultY, resultZ, message.toString()};
                    list.add(dataArray);
                    continue;
                }
                int resultData = 0;
                int resultAmount = -1;
                int resultTable = 0;
                byte[] resultMeta = null;
                byte[] resultBlockData = null;
                long resultId = results.getLong("id");
                int resultUserId = results.getInt("user");
                resultAction = results.getInt("action");
                int resultRolledBack = results.getInt("rolled_back");
                int resultType = results.getInt("type");
                int resultTime2 = results.getInt("time");
                int resultX = results.getInt("x");
                int resultY3 = results.getInt("y");
                int resultZ3 = results.getInt("z");
                int resultWorldId = results.getInt("wid");
                boolean hasTbl = false;
                if (lookup && actionList.size() == 0 || actionList.contains(4) || actionList.contains(5) || actionList.contains(11)) {
                    resultData = results.getInt("data");
                    resultAmount = results.getInt("amount");
                    resultMeta = results.getBytes("metadata");
                    resultTable = results.getInt("tbl");
                    hasTbl = true;
                } else {
                    resultData = results.getInt("data");
                    resultMeta = results.getBytes("meta");
                    resultBlockData = results.getBytes("blockdata");
                }
                boolean valid = true;
                if (!lookup && invalidRollbackActions.contains(resultAction)) {
                    valid = false;
                }
                if (!valid) continue;
                if (hasTbl) {
                    dataArray = new Object[]{resultId, resultTime2, resultUserId, resultX, resultY3, resultZ3, resultType, resultData, resultAction, resultRolledBack, resultWorldId, resultAmount, resultMeta, resultBlockData, resultTable};
                    list.add(dataArray);
                    continue;
                }
                dataArray = new Object[]{resultId, resultTime2, resultUserId, resultX, resultY3, resultZ3, resultType, resultData, resultAction, resultRolledBack, resultWorldId, resultAmount, resultMeta, resultBlockData};
                list.add(dataArray);
            }
            results.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Consumer.isPaused = false;
        return list;
    }

    /*
     * WARNING - void declaration
     */
    static ResultSet rawLookupResultSet(Statement statement, CommandSender user, List<String> checkUuids, List<String> checkUsers, List<Object> restrictList, Map<Object, Boolean> excludeList, List<String> excludeUserList, List<Integer> actionList, Location location, Integer[] radius, Long[] rowData, long startTime, long endTime, int limitOffset, int limitCount, boolean restrictWorld, boolean lookup, boolean count) {
        ResultSet results = null;
        try {
            void var42_67;
            Object baseQuery;
            Object actionText;
            int legacyId;
            String targetName;
            List<Integer> validActions = Arrays.asList(0, 1, 2, 3);
            if (radius != null) {
                restrictWorld = true;
            }
            boolean inventoryQuery = actionList.contains(4) && actionList.contains(11);
            boolean validAction = false;
            Object queryBlock = "";
            Object queryEntity = "";
            Object queryLimit = "";
            String queryTable = "block";
            String action = "";
            String actionExclude = "";
            String includeBlock = "";
            String includeEntity = "";
            String excludeBlock = "";
            String excludeEntity = "";
            String users = "";
            String uuids = "";
            String excludeUsers = "";
            Object unionLimit = "";
            String index = "";
            Object query = "";
            if (checkUuids.size() > 0) {
                Object list = "";
                for (String string : checkUuids) {
                    if (((String)list).length() == 0) {
                        list = "'" + string + "'";
                        continue;
                    }
                    list = (String)list + ",'" + string + "'";
                }
                uuids = list;
            }
            if (!checkUsers.contains("#global")) {
                StringBuilder checkUserText = new StringBuilder();
                for (String string : checkUsers) {
                    if (string.equals("#container")) continue;
                    if (ConfigHandler.playerIdCache.get(string.toLowerCase(Locale.ROOT)) == null) {
                        UserStatement.loadId(statement.getConnection(), string, null);
                    }
                    int userId = ConfigHandler.playerIdCache.get(string.toLowerCase(Locale.ROOT));
                    if (checkUserText.length() == 0) {
                        checkUserText = checkUserText.append(userId);
                        continue;
                    }
                    checkUserText.append(",").append(userId);
                }
                users = checkUserText.toString();
            }
            if (restrictList.size() > 0) {
                StringBuilder includeListMaterial = new StringBuilder();
                StringBuilder includeListEntity = new StringBuilder();
                for (Object restrictTarget : restrictList) {
                    targetName = "";
                    if (restrictTarget instanceof Material) {
                        targetName = ((Material)restrictTarget).name();
                        if (includeListMaterial.length() == 0) {
                            includeListMaterial = includeListMaterial.append(MaterialUtils.getBlockId(targetName, false));
                        } else {
                            includeListMaterial.append(",").append(MaterialUtils.getBlockId(targetName, false));
                        }
                        if ((legacyId = BukkitAdapter.ADAPTER.getLegacyBlockId((Material)restrictTarget)) <= 0) continue;
                        includeListMaterial.append(",").append(legacyId);
                        continue;
                    }
                    if (!(restrictTarget instanceof EntityType)) continue;
                    targetName = ((EntityType)restrictTarget).name();
                    if (includeListEntity.length() == 0) {
                        includeListEntity = includeListEntity.append(EntityUtils.getEntityId(targetName, false));
                        continue;
                    }
                    includeListEntity.append(",").append(EntityUtils.getEntityId(targetName, false));
                }
                includeBlock = includeListMaterial.toString();
                includeEntity = includeListEntity.toString();
            }
            if (excludeList.size() > 0) {
                StringBuilder excludeListMaterial = new StringBuilder();
                Object excludeListEntity = new StringBuilder();
                for (Object restrictTarget : excludeList.keySet()) {
                    targetName = "";
                    if (restrictTarget instanceof Material) {
                        targetName = ((Material)restrictTarget).name();
                        if (excludeListMaterial.length() == 0) {
                            excludeListMaterial = excludeListMaterial.append(MaterialUtils.getBlockId(targetName, false));
                        } else {
                            excludeListMaterial.append(",").append(MaterialUtils.getBlockId(targetName, false));
                        }
                        if ((legacyId = BukkitAdapter.ADAPTER.getLegacyBlockId((Material)restrictTarget)) <= 0) continue;
                        excludeListMaterial.append(",").append(legacyId);
                        continue;
                    }
                    if (!(restrictTarget instanceof EntityType)) continue;
                    targetName = ((EntityType)restrictTarget).name();
                    if (((StringBuilder)excludeListEntity).length() == 0) {
                        excludeListEntity = ((StringBuilder)excludeListEntity).append(EntityUtils.getEntityId(targetName, false));
                        continue;
                    }
                    ((StringBuilder)excludeListEntity).append(",").append(EntityUtils.getEntityId(targetName, false));
                }
                excludeBlock = excludeListMaterial.toString();
                excludeEntity = ((StringBuilder)excludeListEntity).toString();
            }
            if (excludeUserList.size() > 0) {
                StringBuilder excludeUserText = new StringBuilder();
                for (String string : excludeUserList) {
                    if (ConfigHandler.playerIdCache.get(string.toLowerCase(Locale.ROOT)) == null) {
                        UserStatement.loadId(statement.getConnection(), string, null);
                    }
                    int userId = ConfigHandler.playerIdCache.get(string.toLowerCase(Locale.ROOT));
                    if (excludeUserText.length() == 0) {
                        excludeUserText = excludeUserText.append(userId);
                        continue;
                    }
                    excludeUserText.append(",").append(userId);
                }
                excludeUsers = excludeUserText.toString();
            }
            if (lookup && actionList.size() == 0 || actionList.contains(11) && actionList.size() == 1) {
                actionText = new StringBuilder();
                actionText = ((StringBuilder)actionText).append(8);
                ((StringBuilder)actionText).append(",").append(9);
                ((StringBuilder)actionText).append(",").append(10);
                ((StringBuilder)actionText).append(",").append(11);
                ((StringBuilder)actionText).append(",").append(12);
                actionExclude = ((StringBuilder)actionText).toString();
            }
            if (!actionList.isEmpty()) {
                actionText = new StringBuilder();
                for (Integer n : actionList) {
                    void var42_60;
                    if (!validActions.contains(n)) continue;
                    if (actionList.contains(11) && !actionList.contains(4)) {
                        if (n == 0 && !actionList.contains(2)) {
                            Integer n2 = 2;
                        } else if (n == 1 && !actionList.contains(3)) {
                            Integer n3 = 3;
                        }
                    }
                    if (((StringBuilder)actionText).length() == 0) {
                        actionText = ((StringBuilder)actionText).append(var42_60);
                    } else {
                        ((StringBuilder)actionText).append(",").append(var42_60);
                    }
                    if (actionList.contains(11) && actionList.contains(4)) {
                        if (var42_60.intValue() == 0) {
                            ((StringBuilder)actionText).append(",").append(3);
                            ((StringBuilder)actionText).append(",").append(4);
                            ((StringBuilder)actionText).append(",").append(10);
                            ((StringBuilder)actionText).append(",").append(12);
                        }
                        if (var42_60.intValue() != 1) continue;
                        ((StringBuilder)actionText).append(",").append(2);
                        ((StringBuilder)actionText).append(",").append(5);
                        ((StringBuilder)actionText).append(",").append(6);
                        ((StringBuilder)actionText).append(",").append(7);
                        ((StringBuilder)actionText).append(",").append(8);
                        ((StringBuilder)actionText).append(",").append(9);
                        ((StringBuilder)actionText).append(",").append(11);
                        continue;
                    }
                    if (!actionList.contains(11) || actionList.contains(4)) continue;
                    if (var42_60.intValue() == 2) {
                        ((StringBuilder)actionText).append(",").append(5);
                        ((StringBuilder)actionText).append(",").append(6);
                        ((StringBuilder)actionText).append(",").append(7);
                    }
                    if (var42_60.intValue() != 3) continue;
                    ((StringBuilder)actionText).append(",").append(4);
                }
                action = ((StringBuilder)actionText).toString();
            }
            for (Integer value : actionList) {
                if (!validActions.contains(value)) continue;
                validAction = true;
            }
            if (restrictWorld) {
                int wid = WorldUtils.getWorldId(location.getWorld().getName());
                queryBlock = (String)queryBlock + " wid=" + wid + " AND";
            }
            if (radius != null) {
                Integer xmin = radius[1];
                Integer xmax = radius[2];
                Integer n = radius[3];
                Integer ymax = radius[4];
                Integer zmin = radius[5];
                Integer zmax = radius[6];
                Object queryY = "";
                if (n != null && ymax != null) {
                    queryY = " y >= '" + n + "' AND y <= '" + ymax + "' AND";
                }
                queryBlock = (String)queryBlock + " x >= '" + xmin + "' AND x <= '" + xmax + "' AND z >= '" + zmin + "' AND z <= '" + zmax + "' AND" + (String)queryY;
            } else if (actionList.contains(5)) {
                int worldId = WorldUtils.getWorldId(location.getWorld().getName());
                int x = (int)Math.floor(location.getX());
                int n = (int)Math.floor(location.getZ());
                int x2 = (int)Math.ceil(location.getX());
                int z2 = (int)Math.ceil(location.getZ());
                queryBlock = (String)queryBlock + " wid=" + worldId + " AND (x = '" + x + "' OR x = '" + x2 + "') AND (z = '" + n + "' OR z = '" + z2 + "') AND y = '" + location.getBlockY() + "' AND";
            }
            if (validAction) {
                queryBlock = (String)queryBlock + " action IN(" + action + ") AND";
            } else if (inventoryQuery || actionExclude.length() > 0 || includeBlock.length() > 0 || includeEntity.length() > 0 || excludeBlock.length() > 0 || excludeEntity.length() > 0) {
                queryBlock = (String)queryBlock + " action NOT IN(-1) AND";
            }
            if (includeBlock.length() > 0 || includeEntity.length() > 0) {
                queryBlock = (String)queryBlock + " type IN(" + (includeBlock.length() > 0 ? includeBlock : "0") + ") AND";
            }
            if (excludeBlock.length() > 0 || excludeEntity.length() > 0) {
                queryBlock = (String)queryBlock + " type NOT IN(" + (excludeBlock.length() > 0 ? excludeBlock : "0") + ") AND";
            }
            if (uuids.length() > 0) {
                queryBlock = (String)queryBlock + " uuid IN(" + uuids + ") AND";
            }
            if (users.length() > 0) {
                queryBlock = (String)queryBlock + " user IN(" + users + ") AND";
            }
            if (excludeUsers.length() > 0) {
                queryBlock = (String)queryBlock + " user NOT IN(" + excludeUsers + ") AND";
            }
            if (startTime > 0L) {
                queryBlock = (String)queryBlock + " time > '" + startTime + "' AND";
            }
            if (endTime > 0L) {
                queryBlock = (String)queryBlock + " time <= '" + endTime + "' AND";
            }
            if (actionList.contains(10)) {
                queryBlock = (String)queryBlock + " action = '1' AND (LENGTH(line_1) > 0 OR LENGTH(line_2) > 0 OR LENGTH(line_3) > 0 OR LENGTH(line_4) > 0 OR LENGTH(line_5) > 0 OR LENGTH(line_6) > 0 OR LENGTH(line_7) > 0 OR LENGTH(line_8) > 0) AND";
            }
            if (((String)queryBlock).length() > 0) {
                queryBlock = ((String)queryBlock).substring(0, ((String)queryBlock).length() - 4);
            }
            if (((String)queryBlock).length() == 0) {
                queryBlock = " 1";
            }
            queryEntity = queryBlock;
            if (includeBlock.length() > 0 || includeEntity.length() > 0) {
                queryEntity = ((String)queryEntity).replace("type IN(" + (includeBlock.length() > 0 ? includeBlock : "0") + ")", "type IN(" + (includeEntity.length() > 0 ? includeEntity : "0") + ")");
            }
            if (excludeBlock.length() > 0 || excludeEntity.length() > 0) {
                queryEntity = ((String)queryEntity).replace("type NOT IN(" + (excludeBlock.length() > 0 ? excludeBlock : "0") + ")", "type NOT IN(" + (excludeEntity.length() > 0 ? excludeEntity : "0") + ")");
            }
            Object object = baseQuery = !includeEntity.isEmpty() || !excludeEntity.isEmpty() ? queryEntity : queryBlock;
            if (limitOffset > -1 && limitCount > -1) {
                queryLimit = " LIMIT " + limitOffset + ", " + limitCount;
                unionLimit = " ORDER BY time DESC, id DESC LIMIT " + (limitOffset + limitCount);
            }
            Object rows = "rowid as id,time,user,wid,x,y,z,action,type,data,meta,blockdata,rolled_back";
            String string = " ORDER BY rowid DESC";
            if (actionList.contains(4) || actionList.contains(5)) {
                queryTable = "container";
                rows = "rowid as id,time,user,wid,x,y,z,action,type,data,rolled_back,amount,metadata";
            } else if (actionList.contains(6) || actionList.contains(7)) {
                queryTable = "chat";
                rows = "rowid as id,time,user,message";
                if (PluginChannelHandshakeListener.getInstance().isPluginChannelPlayer(user)) {
                    rows = (String)rows + ",wid,x,y,z";
                }
                if (actionList.contains(7)) {
                    queryTable = "command";
                }
            } else if (actionList.contains(8)) {
                queryTable = "session";
                rows = "rowid as id,time,user,wid,x,y,z,action";
            } else if (actionList.contains(9)) {
                queryTable = "username_log";
                rows = "rowid as id,time,uuid,user";
            } else if (actionList.contains(10)) {
                queryTable = "sign";
                rows = "rowid as id,time,user,wid,x,y,z,face,line_1,line_2,line_3,line_4,line_5,line_6,line_7,line_8";
            } else if (actionList.contains(11)) {
                queryTable = "item";
                rows = "rowid as id,time,user,wid,x,y,z,type,data as metadata,0 as data,amount,action,0 as rolled_back";
            }
            if (count) {
                rows = "COUNT(*) as count";
                queryLimit = " LIMIT 0, 3";
                String string2 = "";
                unionLimit = "";
            }
            String unionSelect = "SELECT * FROM (";
            if (Config.getGlobal().MYSQL) {
                if (queryTable.equals("block")) {
                    if (includeBlock.length() > 0 || includeEntity.length() > 0) {
                        index = "USE INDEX(type) IGNORE INDEX(user,wid) ";
                    }
                    if (users.length() > 0) {
                        index = "USE INDEX(user) IGNORE INDEX(type,wid) ";
                    }
                    if (radius != null && radius[2] - radius[1] <= 50 && radius[6] - radius[5] <= 50) {
                        index = "USE INDEX(wid) IGNORE INDEX(type,user) ";
                    }
                    if (restrictWorld && (users.length() > 0 || includeBlock.length() > 0 || includeEntity.length() > 0)) {
                        index = "IGNORE INDEX(PRIMARY) ";
                    }
                }
                unionSelect = "(";
            } else if (queryTable.equals("block")) {
                if (includeBlock.length() > 0 || includeEntity.length() > 0) {
                    index = "INDEXED BY block_type_index ";
                }
                if (users.length() > 0) {
                    index = "INDEXED BY block_user_index ";
                }
                if (radius != null && radius[2] - radius[1] <= 50 && radius[6] - radius[5] <= 50) {
                    index = "INDEXED BY block_index ";
                }
                if (restrictWorld && (users.length() > 0 || includeBlock.length() > 0 || includeEntity.length() > 0)) {
                    index = "";
                }
            }
            boolean itemLookup = inventoryQuery;
            if (lookup && actionList.size() == 0 || itemLookup && !actionList.contains(0)) {
                if (!count) {
                    rows = "rowid as id,time,user,wid,x,y,z,type,meta as metadata,data,-1 as amount,action,rolled_back";
                }
                if (inventoryQuery) {
                    baseQuery = validAction ? ((String)baseQuery).replace("action IN(" + action + ")", "action IN(1)") : ((String)baseQuery).replace("action NOT IN(-1)", "action IN(1)");
                    if (!count) {
                        rows = "rowid as id,time,user,wid,x,y,z,type,meta as metadata,data,1 as amount,action,rolled_back";
                    }
                }
                if (includeBlock.length() > 0 || excludeBlock.length() > 0) {
                    baseQuery = ((String)baseQuery).replace("action NOT IN(-1)", "action NOT IN(3)");
                }
                query = unionSelect + "SELECT '0' as tbl," + (String)rows + " FROM " + ConfigHandler.prefix + "block " + index + "WHERE" + (String)baseQuery + (String)unionLimit + ") UNION ALL ";
                itemLookup = true;
            }
            if (itemLookup) {
                if (!count) {
                    rows = "rowid as id,time,user,wid,x,y,z,type,metadata,data,amount,action,rolled_back";
                }
                query = (String)query + unionSelect + "SELECT '1' as tbl," + (String)rows + " FROM " + ConfigHandler.prefix + "container WHERE" + (String)queryBlock + (String)unionLimit + ") UNION ALL ";
                if (!count) {
                    rows = "rowid as id,time,user,wid,x,y,z,type,data as metadata,0 as data,amount,action,rolled_back";
                    String string3 = " ORDER BY time DESC, tbl DESC, id DESC";
                }
                if (actionExclude.length() > 0) {
                    queryBlock = ((String)queryBlock).replace("action NOT IN(-1)", "action NOT IN(" + actionExclude + ")");
                }
                query = (String)query + unionSelect + "SELECT '2' as tbl," + (String)rows + " FROM " + ConfigHandler.prefix + "item WHERE" + (String)queryBlock + (String)unionLimit + ")";
            }
            if (((String)query).length() == 0) {
                if (actionExclude.length() > 0) {
                    baseQuery = ((String)baseQuery).replace("action NOT IN(-1)", "action NOT IN(" + actionExclude + ")");
                }
                query = "SELECT '0' as tbl," + (String)rows + " FROM " + ConfigHandler.prefix + queryTable + " " + index + "WHERE" + (String)baseQuery;
            }
            query = (String)query + (String)var42_67 + (String)queryLimit;
            results = statement.executeQuery((String)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }
}

