/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command.lookup;

import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.database.Database;
import net.coreprotect.database.lookup.ChestTransactionLookup;
import net.coreprotect.language.Phrase;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.Color;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ChestTransactionLookupThread
implements Runnable {
    private final CommandSender player;
    private final Command command;
    private final Location location;
    private final int page;
    private final int limit;

    public ChestTransactionLookupThread(CommandSender player, Command command, Location location, int page, int limit) {
        this.player = player;
        this.command = command;
        this.location = location;
        this.page = page;
        this.limit = limit;
    }

    @Override
    public void run() {
        try (Connection connection = Database.getConnection(true);){
            ConfigHandler.lookupThrottle.put(this.player.getName(), new Object[]{true, System.currentTimeMillis()});
            if (connection != null) {
                Statement statement = connection.createStatement();
                List<String> blockData = ChestTransactionLookup.performLookup(this.command.getName(), statement, this.location, this.player, this.page, this.limit, false);
                for (String data : blockData) {
                    Chat.sendComponent(this.player, data);
                }
                statement.close();
            } else {
                Chat.sendMessage(this.player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ConfigHandler.lookupThrottle.put(this.player.getName(), new Object[]{false, System.currentTimeMillis()});
    }
}

