/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.coreprotect.command.CommandParser;
import net.coreprotect.config.ConfigHandler;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class TabHandler
implements TabCompleter {
    private static final String[] HELP = new String[]{"inspect", "rollback", "restore", "lookup", "purge", "teleport", "status", "params", "users", "time", "radius", "action", "include", "exclude"};
    private static final String[] PARAMS = new String[]{"user:", "time:", "radius:", "action:", "include:", "exclude:", "#container"};
    private static final String[] ACTIONS = new String[]{"block", "+block", "-block", "click", "kill", "+container", "-container", "container", "chat", "command", "+inventory", "-inventory", "inventory", "item", "+item", "-item", "sign", "session", "+session", "-session", "username"};
    private static final String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final String[] TIMES = new String[]{"w", "d", "h", "m", "s"};
    private static ArrayList<String> materials = null;

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player) || args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            return this.getFirstLevelCompletions(sender, args[0]);
        }
        String argument0 = args[0].toLowerCase(Locale.ROOT);
        String currentArg = args[args.length - 1].toLowerCase(Locale.ROOT).trim();
        String lastArg = args.length > 1 ? args[args.length - 2].toLowerCase(Locale.ROOT).trim() : "";
        ParamState paramState = this.getParamState(args);
        if (this.isActionParam(lastArg, currentArg) && this.hasLookupPermission(sender)) {
            return this.handleActionParamCompletions(currentArg, lastArg);
        }
        if (this.isUserParam(lastArg, currentArg) && this.hasLookupPermission(sender)) {
            return this.handleUserParamCompletions(currentArg, lastArg);
        }
        if (this.isTimeParam(lastArg, currentArg) && this.hasTimePermission(sender)) {
            return this.handleTimeParamCompletions(currentArg, lastArg);
        }
        if (this.isPageParam(lastArg, currentArg) && this.hasPagePermission(sender)) {
            return this.handlePageParamCompletions(currentArg, lastArg);
        }
        if (this.isRadiusParam(lastArg, currentArg) && this.hasRadiusPermission(sender)) {
            return this.handleRadiusParamCompletions(currentArg, lastArg, argument0);
        }
        if (this.isMaterialParam(lastArg, currentArg) && this.hasLookupPermission(sender)) {
            return this.handleMaterialParamCompletions(currentArg, lastArg);
        }
        if (args.length == 2) {
            return this.handleSecondArgCompletions(sender, argument0, args[1], paramState);
        }
        if (args.length == 3 && argument0.equals("purge") && sender.hasPermission("coreprotect.purge")) {
            return this.handlePurgeThirdArgCompletions(args[1], args[2]);
        }
        if (this.hasLookupCommand(argument0, sender) && (!argument0.equals("l") && !argument0.equals("lookup") || !paramState.hasPage)) {
            return this.handleGenericLookupCompletions(argument0, currentArg, paramState);
        }
        return Arrays.asList("");
    }

    private List<String> getFirstLevelCompletions(CommandSender sender, String argument) {
        String arg = argument.toLowerCase(Locale.ROOT);
        ArrayList<String> completions = new ArrayList<String>();
        this.addCompletionIfPermitted(sender, "coreprotect.help", "help", completions);
        this.addCompletionIfPermitted(sender, "coreprotect.inspect", "inspect", completions);
        this.addCompletionIfPermitted(sender, "coreprotect.rollback", "rollback", completions);
        this.addCompletionIfPermitted(sender, "coreprotect.restore", "restore", completions);
        this.addCompletionIfPermitted(sender, "coreprotect.lookup", "lookup", completions);
        this.addCompletionIfPermitted(sender, "coreprotect.purge", "purge", completions);
        this.addCompletionIfPermitted(sender, "coreprotect.reload", "reload", completions);
        this.addCompletionIfPermitted(sender, "coreprotect.status", "status", completions);
        this.addCompletionIfPermitted(sender, "coreprotect.lookup.near", "near", completions);
        this.addCompletionIfPermitted(sender, "coreprotect.restore", "undo", completions);
        return (List)StringUtil.copyPartialMatches((String)arg, completions, new ArrayList(completions.size()));
    }

    private void addCompletionIfPermitted(CommandSender sender, String permission, String completion, List<String> completions) {
        if (sender.hasPermission(permission)) {
            completions.add(completion);
        }
    }

    private boolean hasLookupPermission(CommandSender sender) {
        return sender.hasPermission("coreprotect.lookup") || sender.hasPermission("coreprotect.rollback") || sender.hasPermission("coreprotect.restore");
    }

    private boolean hasTimePermission(CommandSender sender) {
        return this.hasLookupPermission(sender) || sender.hasPermission("coreprotect.purge");
    }

    private boolean hasRadiusPermission(CommandSender sender) {
        return this.hasTimePermission(sender);
    }

    private boolean hasPagePermission(CommandSender sender) {
        return sender.hasPermission("coreprotect.lookup") || sender.hasPermission("coreprotect.lookup.near") || sender.hasPermission("coreprotect.inspect");
    }

    private boolean hasLookupCommand(String cmd, CommandSender sender) {
        return sender.hasPermission("coreprotect.lookup") && (cmd.equals("l") || cmd.equals("lookup")) || sender.hasPermission("coreprotect.rollback") && (cmd.equals("rollback") || cmd.equals("rb") || cmd.equals("ro")) || sender.hasPermission("coreprotect.restore") && (cmd.equals("restore") || cmd.equals("rs") || cmd.equals("re"));
    }

    private boolean isActionParam(String lastArg, String currentArg) {
        return lastArg.equals("a:") || lastArg.equals("action:") || currentArg.startsWith("a:") || currentArg.startsWith("action:");
    }

    private boolean isUserParam(String lastArg, String currentArg) {
        return lastArg.equals("u:") || lastArg.equals("user:") || lastArg.equals("users:") || lastArg.equals("p:") || currentArg.startsWith("u:") || currentArg.startsWith("user:") || currentArg.startsWith("users:") || currentArg.startsWith("p:");
    }

    private boolean isTimeParam(String lastArg, String currentArg) {
        return lastArg.equals("t:") || lastArg.equals("time:") || currentArg.startsWith("t:") || currentArg.startsWith("time:");
    }

    private boolean isPageParam(String lastArg, String currentArg) {
        return lastArg.equals("page:") || currentArg.startsWith("page:");
    }

    private boolean isRadiusParam(String lastArg, String currentArg) {
        return lastArg.equals("r:") || lastArg.equals("radius:") || currentArg.startsWith("r:") || currentArg.startsWith("radius:");
    }

    private boolean isMaterialParam(String lastArg, String currentArg) {
        return lastArg.equals("i:") || lastArg.equals("include:") || lastArg.equals("item:") || lastArg.equals("items:") || lastArg.equals("b:") || lastArg.equals("block:") || lastArg.equals("blocks:") || currentArg.startsWith("i:") || currentArg.startsWith("include:") || currentArg.startsWith("item:") || currentArg.startsWith("items:") || currentArg.startsWith("b:") || currentArg.startsWith("block:") || currentArg.startsWith("blocks:") || lastArg.equals("e:") || lastArg.equals("exclude:") || currentArg.startsWith("e:") || currentArg.startsWith("exclude:");
    }

    private ParamState getParamState(String[] args) {
        ParamState state = new ParamState();
        if (ConfigHandler.lookupType.get(args[0]) != null && ConfigHandler.lookupPage.get(args[0]) != null) {
            state.pageLookup = true;
        }
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i].toLowerCase(Locale.ROOT);
            if (arg.equals("#container")) {
                state.hasContainer = true;
                continue;
            }
            if (arg.equals("#count") || arg.equals("#sum")) {
                state.hasCount = true;
                continue;
            }
            if (arg.equals("#preview")) {
                state.hasPreview = true;
                continue;
            }
            if (!arg.contains(":") && !args[i - 1].contains(":") && args.length > i + 1 || arg.contains("u:") || arg.contains("user:") || arg.contains("users:") || arg.contains("p:")) {
                state.hasUser = true;
                continue;
            }
            if (arg.contains("page:")) {
                state.hasPage = true;
                continue;
            }
            if (arg.contains("a:") || arg.contains("action:")) {
                state.hasAction = true;
                continue;
            }
            if (arg.contains("i:") || arg.contains("include:") || arg.contains("item:") || arg.contains("items:") || arg.contains("b:") || arg.contains("block:") || arg.contains("blocks:")) {
                state.hasInclude = true;
                continue;
            }
            if (arg.contains("t:") || arg.contains("time:")) {
                state.hasTime = true;
                continue;
            }
            if (arg.contains("e:") || arg.contains("exclude:")) {
                state.hasExclude = true;
                continue;
            }
            if (!arg.contains("r:") && !arg.contains("radius:")) continue;
            state.hasRadius = true;
        }
        if (!state.hasContainer && ConfigHandler.lookupType.get(args[0]) != null) {
            int lookupType = ConfigHandler.lookupType.get(args[0]);
            if (lookupType == 1) {
                state.validContainer = true;
            } else if (lookupType == 5 && ConfigHandler.lookupUlist.get(args[0]).contains("#container")) {
                state.validContainer = true;
            }
        }
        return state;
    }

    private List<String> handleActionParamCompletions(String currentArg, String lastArg) {
        String arg = "";
        Object filter = lastArg;
        if (currentArg.contains(":")) {
            String[] split = currentArg.split(":", 2);
            filter = split[0] + ":";
            if (split.length > 1) {
                arg = split[1];
            }
        }
        ArrayList<String> completions = new ArrayList<String>(Arrays.asList(ACTIONS));
        for (int index = 0; index < completions.size(); ++index) {
            completions.set(index, (String)filter + (String)completions.get(index));
        }
        return (List)StringUtil.copyPartialMatches((String)((String)filter + arg), completions, new ArrayList(completions.size()));
    }

    private List<String> handleUserParamCompletions(String currentArg, String lastArg) {
        if (lastArg.equals("u:") || lastArg.equals("user:") || lastArg.equals("users:") || lastArg.equals("p:")) {
            return null;
        }
        String arg = "";
        String[] split = currentArg.split(":", 2);
        String filter = split[0] + ":";
        if (split.length > 1) {
            arg = split[1];
        }
        List completions = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        for (int index = 0; index < completions.size(); ++index) {
            completions.set(index, filter + (String)completions.get(index));
        }
        return (List)StringUtil.copyPartialMatches((String)(filter + arg), completions, new ArrayList(completions.size()));
    }

    private List<String> handleTimeParamCompletions(String currentArg, String lastArg) {
        Object filter = lastArg;
        String arg = "";
        if (currentArg.contains(":")) {
            String[] split = currentArg.split(":", 2);
            filter = split[0] + ":";
            if (split.length > 1) {
                arg = split[1];
            }
        } else {
            filter = "";
            arg = currentArg;
        }
        ArrayList<Object> completions = new ArrayList<Object>();
        if (arg.chars().allMatch(Character::isDigit)) {
            char lastChar;
            boolean addNumbers = true;
            if (currentArg.length() > 0 && Character.isDigit(lastChar = currentArg.charAt(currentArg.length() - 1))) {
                completions.addAll(Arrays.asList(TIMES));
                addNumbers = false;
            }
            if (addNumbers) {
                completions.addAll(Arrays.asList(NUMBERS));
            }
        }
        completions = new ArrayList(completions);
        for (int index = 0; index < completions.size(); ++index) {
            completions.set(index, (String)filter + arg + (String)completions.get(index));
        }
        return (List)StringUtil.copyPartialMatches((String)((String)filter + arg), completions, new ArrayList(completions.size()));
    }

    private List<String> handlePageParamCompletions(String currentArg, String lastArg) {
        Object filter = lastArg;
        String arg = "";
        if (currentArg.contains(":")) {
            String[] split = currentArg.split(":", 2);
            filter = split[0] + ":";
            if (split.length > 1) {
                arg = split[1];
            }
        } else {
            filter = "";
            arg = currentArg;
        }
        if (arg.chars().allMatch(Character::isDigit)) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList(NUMBERS));
            if (arg.length() < 1) {
                for (int index = 0; index < completions.size(); ++index) {
                    completions.set(index, (String)filter + arg + (String)completions.get(index));
                }
                if (arg.length() == 0) {
                    completions.remove(0);
                }
            }
            return (List)StringUtil.copyPartialMatches((String)((String)filter + arg), completions, new ArrayList(completions.size()));
        }
        return null;
    }

    private List<String> handleRadiusParamCompletions(String currentArg, String lastArg, String baseCommand) {
        Object filter = lastArg;
        String arg = "";
        if (currentArg.contains(":")) {
            String[] split = currentArg.split(":", 2);
            filter = split[0] + ":";
            if (split.length > 1) {
                arg = split[1];
            }
        } else {
            filter = "";
            arg = currentArg;
        }
        if (!baseCommand.equals("purge") && arg.chars().allMatch(Character::isDigit)) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList(NUMBERS));
            if (arg.length() < 2) {
                for (int index = 0; index < completions.size(); ++index) {
                    completions.set(index, (String)filter + arg + (String)completions.get(index));
                }
            }
            return (List)StringUtil.copyPartialMatches((String)((String)filter + arg), completions, new ArrayList(completions.size()));
        }
        if (baseCommand.equals("purge") || arg.startsWith("#")) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add("#global");
            if (!baseCommand.equals("purge") && Bukkit.getServer().getPluginManager().getPlugin("WorldEdit") != null) {
                params.add("#worldedit");
            }
            List worlds = Bukkit.getServer().getWorlds();
            for (World world : worlds) {
                params.add("#" + world.getName());
            }
            ArrayList<CallSite> completions = new ArrayList<CallSite>(params);
            for (int index = 0; index < completions.size(); ++index) {
                completions.set(index, (CallSite)((Object)((String)filter + (String)completions.get(index))));
            }
            return (List)StringUtil.copyPartialMatches((String)((String)filter + arg), completions, new ArrayList(completions.size()));
        }
        return null;
    }

    private List<String> handleMaterialParamCompletions(String currentArg, String lastArg) {
        Object filter = lastArg;
        String arg = "";
        if (currentArg.contains(":")) {
            String[] split = currentArg.split(":", 2);
            filter = split[0] + ":";
            if (split.length > 1) {
                arg = split[1];
            }
        } else {
            filter = "";
            arg = currentArg;
        }
        this.initializeMaterialsIfNeeded();
        ArrayList<String> completions = new ArrayList<String>(materials);
        for (int index = 0; index < completions.size(); ++index) {
            completions.set(index, (String)filter + (String)completions.get(index));
        }
        return (List)StringUtil.copyPartialMatches((String)((String)filter + arg), completions, new ArrayList(completions.size()));
    }

    private void initializeMaterialsIfNeeded() {
        if (materials == null) {
            List<Material> addList = Arrays.asList(Material.ARMOR_STAND);
            List<Material> excludeList = Arrays.asList(new Material[0]);
            HashSet<String> materialList = new HashSet<String>();
            Material[] materialValues = Material.values();
            for (Material material : materialValues) {
                if (!material.isBlock() && !material.isItem()) continue;
                materialList.add(material.name().toLowerCase(Locale.ROOT));
            }
            for (Material exclude : excludeList) {
                materialList.remove(exclude.name().toLowerCase(Locale.ROOT));
            }
            for (Material add : addList) {
                materialList.add(add.name().toLowerCase(Locale.ROOT));
            }
            for (String tag : CommandParser.getTags().keySet()) {
                materialList.add(tag);
            }
            materials = new ArrayList(materialList);
        }
    }

    private List<String> handleSecondArgCompletions(CommandSender sender, String cmd0, String cmd1, ParamState paramState) {
        String argument0 = cmd0.toLowerCase(Locale.ROOT);
        String argument1 = cmd1.toLowerCase(Locale.ROOT);
        if (argument0.equals("help") && sender.hasPermission("coreprotect.help")) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList(HELP));
            return (List)StringUtil.copyPartialMatches((String)argument1, completions, new ArrayList(completions.size()));
        }
        if (argument0.equals("purge") && sender.hasPermission("coreprotect.purge")) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList("t:", "r:", "i:"));
            return (List)StringUtil.copyPartialMatches((String)argument1, completions, new ArrayList(completions.size()));
        }
        if (this.hasLookupCommand(argument0, sender)) {
            ArrayList<String> completions = new ArrayList<String>(this.filterParams(true, argument0, argument1, paramState));
            completions.addAll(Bukkit.getOnlinePlayers().stream().filter(player -> player.getName().toLowerCase(Locale.ROOT).startsWith(argument1)).map(Player::getName).collect(Collectors.toList()));
            return (List)StringUtil.copyPartialMatches((String)argument1, completions, new ArrayList(completions.size()));
        }
        return null;
    }

    private List<String> handlePurgeThirdArgCompletions(String arg1, String arg2) {
        String argument1 = arg1.toLowerCase(Locale.ROOT);
        String argument2 = arg2.toLowerCase(Locale.ROOT);
        if (argument1.startsWith("t:")) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList("r:", "i:"));
            return (List)StringUtil.copyPartialMatches((String)argument2, completions, new ArrayList(completions.size()));
        }
        if (argument1.startsWith("r:") || argument1.startsWith("i:")) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList("t:"));
            return (List)StringUtil.copyPartialMatches((String)argument2, completions, new ArrayList(completions.size()));
        }
        return Arrays.asList("");
    }

    private List<String> handleGenericLookupCompletions(String cmd, String currentArg, ParamState paramState) {
        ArrayList<String> params = this.filterParams(false, cmd, currentArg, paramState);
        ArrayList<String> completions = new ArrayList<String>(params);
        return (List)StringUtil.copyPartialMatches((String)currentArg, completions, new ArrayList(completions.size()));
    }

    private ArrayList<String> filterParams(boolean firstParam, String lastArgument, String argument, ParamState state) {
        ArrayList<String> params = new ArrayList<String>();
        for (String param : PARAMS) {
            if (param.equals("user:") && !state.hasUser) {
                params.add(param);
                continue;
            }
            if (param.equals("action:") && !state.hasAction) {
                params.add(param);
                continue;
            }
            if (param.equals("include:") && !state.hasInclude) {
                params.add(param);
                continue;
            }
            if (param.equals("exclude:") && !state.hasExclude) {
                params.add(param);
                continue;
            }
            if (param.equals("radius:") && !state.hasRadius) {
                params.add(param);
                continue;
            }
            if (param.equals("time:") && !state.hasTime) {
                params.add(param);
                continue;
            }
            if (!param.equals("#container") || state.hasContainer || state.hasRadius || !state.validContainer) continue;
            params.add(param);
        }
        if (firstParam && state.pageLookup && (lastArgument.equals("l") || lastArgument.equals("lookup"))) {
            params.add("page:");
        } else if (!firstParam && argument.startsWith("#")) {
            if (!state.hasCount) {
                params.add("#count");
            }
            if (!state.hasPreview) {
                params.add("#preview");
            }
        }
        return params;
    }

    private static class ParamState {
        boolean hasUser;
        boolean hasAction;
        boolean hasInclude;
        boolean hasExclude;
        boolean hasRadius;
        boolean hasTime;
        boolean hasContainer;
        boolean hasCount;
        boolean hasPreview;
        boolean hasPage;
        boolean validContainer;
        boolean pageLookup;

        private ParamState() {
        }
    }
}

