/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.bukkit;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.coreprotect.bukkit.BukkitInterface;
import net.coreprotect.bukkit.Bukkit_v1_17;
import net.coreprotect.bukkit.Bukkit_v1_18;
import net.coreprotect.bukkit.Bukkit_v1_19;
import net.coreprotect.bukkit.Bukkit_v1_20;
import net.coreprotect.bukkit.Bukkit_v1_21;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.utility.BlockUtils;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wolf;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class BukkitAdapter
implements BukkitInterface {
    public static BukkitInterface ADAPTER;
    public static final int BUKKIT_V1_13 = 13;
    public static final int BUKKIT_V1_14 = 14;
    public static final int BUKKIT_V1_15 = 15;
    public static final int BUKKIT_V1_16 = 16;
    public static final int BUKKIT_V1_17 = 17;
    public static final int BUKKIT_V1_18 = 18;
    public static final int BUKKIT_V1_19 = 19;
    public static final int BUKKIT_V1_20 = 20;
    public static final int BUKKIT_V1_21 = 21;
    public static Set<Material> EMPTY_SET;

    public static void loadAdapter() {
        switch (ConfigHandler.SERVER_VERSION) {
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                ADAPTER = new BukkitAdapter();
                break;
            }
            case 17: {
                ADAPTER = new Bukkit_v1_17();
                break;
            }
            case 18: {
                ADAPTER = new Bukkit_v1_18();
                break;
            }
            case 19: {
                ADAPTER = new Bukkit_v1_19();
                break;
            }
            case 20: {
                ADAPTER = new Bukkit_v1_20();
                break;
            }
            default: {
                ADAPTER = new Bukkit_v1_21();
            }
        }
    }

    @Override
    public String parseLegacyName(String name) {
        return name;
    }

    @Override
    public int getLegacyBlockId(Material material) {
        return -1;
    }

    @Override
    public boolean getEntityMeta(LivingEntity entity, List<Object> info) {
        return false;
    }

    @Override
    public boolean setEntityMeta(Entity entity, Object value, int count) {
        return false;
    }

    @Override
    public void getWolfVariant(Wolf wolf, List<Object> info) {
    }

    @Override
    public void setWolfVariant(Wolf wolf, Object value) {
    }

    @Override
    public EntityType getEntityType(Material material) {
        switch (material) {
            case END_CRYSTAL: {
                return EntityType.valueOf((String)"ENDER_CRYSTAL");
            }
        }
        return EntityType.UNKNOWN;
    }

    @Override
    public boolean getItemMeta(ItemMeta itemMeta, List<Map<String, Object>> list, List<List<Map<String, Object>>> metadata, int slot) {
        return false;
    }

    @Override
    public boolean setItemMeta(Material rowType, ItemStack itemstack, List<Map<String, Object>> map) {
        return false;
    }

    @Override
    public Material getPlantSeeds(Material material) {
        switch (material) {
            case WHEAT: {
                return Material.WHEAT_SEEDS;
            }
            case PUMPKIN_STEM: {
                return Material.PUMPKIN_SEEDS;
            }
            case MELON_STEM: {
                return Material.MELON_SEEDS;
            }
            case BEETROOTS: {
                return Material.BEETROOT_SEEDS;
            }
        }
        return material;
    }

    @Override
    public ItemStack adjustIngredient(MerchantRecipe recipe, ItemStack itemStack) {
        return null;
    }

    @Override
    public ItemStack getArrowMeta(Arrow arrow, ItemStack itemStack) {
        PotionData data = arrow.getBasePotionData();
        if (data.getType() != PotionType.valueOf((String)"UNCRAFTABLE")) {
            itemStack = new ItemStack(Material.TIPPED_ARROW);
            PotionMeta meta = (PotionMeta)itemStack.getItemMeta();
            meta.setBasePotionData(data);
            for (PotionEffect effect : arrow.getCustomEffects()) {
                meta.addCustomEffect(effect, false);
            }
            itemStack.setItemMeta((ItemMeta)meta);
        }
        return itemStack;
    }

    @Override
    public boolean isAttached(Block block, Block scanBlock, BlockData blockData, int scanMin) {
        if (blockData instanceof Directional && blockData instanceof FaceAttachable) {
            Directional directional = (Directional)blockData;
            FaceAttachable faceAttachable = (FaceAttachable)blockData;
            boolean scanButton = false;
            switch (faceAttachable.getAttachedFace()) {
                case WALL: {
                    scanButton = scanMin < 5 && scanBlock.getRelative(directional.getFacing().getOppositeFace()).getLocation().equals((Object)block.getLocation());
                    break;
                }
                case FLOOR: {
                    scanButton = scanMin == 5;
                    break;
                }
                case CEILING: {
                    scanButton = scanMin == 6;
                    break;
                }
            }
            return scanButton;
        }
        return true;
    }

    @Override
    public int getMinHeight(World world) {
        return 0;
    }

    @Override
    public Material getBucketContents(Material material) {
        return Material.AIR;
    }

    @Override
    public boolean isInvisible(Material material) {
        return BlockUtils.isAir(material);
    }

    @Override
    public boolean isItemFrame(Material material) {
        return material == Material.ITEM_FRAME;
    }

    @Override
    public Material getFrameType(Entity entity) {
        return Material.ITEM_FRAME;
    }

    @Override
    public Material getFrameType(EntityType type) {
        return type == EntityType.ITEM_FRAME ? Material.ITEM_FRAME : null;
    }

    @Override
    public Class<?> getFrameClass(Material material) {
        return ItemFrame.class;
    }

    @Override
    public boolean isDecoratedPot(Material material) {
        return false;
    }

    @Override
    public boolean isSuspiciousBlock(Material material) {
        return false;
    }

    @Override
    public boolean isSign(Material material) {
        return Tag.SIGNS.isTagged((Keyed)material);
    }

    @Override
    public boolean isChiseledBookshelf(Material material) {
        return false;
    }

    @Override
    public boolean isBookshelfBook(Material material) {
        return false;
    }

    @Override
    public ItemStack getChiseledBookshelfBook(BlockState blockState, PlayerInteractEvent event) {
        return null;
    }

    @Override
    public String getLine(Sign sign, int line) {
        if (line < 4) {
            return sign.getLine(line);
        }
        return "";
    }

    @Override
    public void setLine(Sign sign, int line, String string) {
        if (string == null) {
            string = "";
        }
        if (line < 4) {
            sign.setLine(line, string);
        }
    }

    @Override
    public boolean isSignFront(SignChangeEvent event) {
        return true;
    }

    @Override
    public boolean isGlowing(Sign sign, boolean isFront) {
        return false;
    }

    @Override
    public boolean isWaxed(Sign sign) {
        return false;
    }

    @Override
    public void setGlowing(Sign sign, boolean isFront, boolean isGlowing) {
    }

    @Override
    public void setColor(Sign sign, boolean isFront, int color) {
        if (!isFront) {
            return;
        }
        sign.setColor(DyeColor.getByColor((Color)Color.fromRGB((int)color)));
    }

    @Override
    public void setWaxed(Sign sign, boolean isWaxed) {
    }

    @Override
    public int getColor(Sign sign, boolean isFront) {
        if (isFront) {
            return sign.getColor().getColor().asRGB();
        }
        return 0;
    }

    @Override
    public Object getRegistryKey(Object value) {
        return value;
    }

    @Override
    public Object getRegistryValue(String key, Object tClass) {
        return null;
    }

    @Override
    public boolean isCrafter(InventoryType type) {
        return false;
    }

    @Override
    public boolean isCopperChest(Material material) {
        return false;
    }

    @Override
    public Set<Material> copperChestMaterials() {
        return EMPTY_SET;
    }

    static {
        EMPTY_SET = new HashSet<Material>(Arrays.asList(new Material[0]));
    }
}

