/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.api;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.database.Database;
import net.coreprotect.database.statement.UserStatement;

public class SessionLookup {
    public static final int ID = 0;

    private SessionLookup() {
        throw new IllegalStateException("API class");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String[]> performLookup(String user, int offset) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (!Config.getGlobal().API_ENABLED) {
            return result;
        }
        if (user == null) {
            return result;
        }
        try (Connection connection = Database.getConnection(false, 1000);){
            if (connection == null) {
                ArrayList<String[]> arrayList = result;
                return arrayList;
            }
            String type = String.valueOf(0);
            int time = (int)(System.currentTimeMillis() / 1000L);
            int checkTime = SessionLookup.calculateCheckTime(time, offset);
            int userId = SessionLookup.getUserId(connection, user);
            try (Statement statement = connection.createStatement();){
                String query = SessionLookup.buildSessionQuery(userId, checkTime);
                try (ResultSet results = statement.executeQuery(query);){
                    while (results.next()) {
                        String[] sessionData = SessionLookup.extractSessionData(connection, results, type);
                        result.add(sessionData);
                    }
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static int calculateCheckTime(int currentTime, int offset) {
        return offset > 0 ? currentTime - offset : 0;
    }

    private static int getUserId(Connection connection, String username) {
        String lowerUsername = username.toLowerCase(Locale.ROOT);
        if (ConfigHandler.playerIdCache.get(lowerUsername) == null) {
            UserStatement.loadId(connection, username, null);
        }
        return ConfigHandler.playerIdCache.get(lowerUsername);
    }

    private static String buildSessionQuery(int userId, int checkTime) {
        return "SELECT time,user,wid,x,y,z,action FROM " + ConfigHandler.prefix + "session WHERE user = '" + userId + "' AND time > '" + checkTime + "' ORDER BY rowid DESC";
    }

    private static String[] extractSessionData(Connection connection, ResultSet results, String type) throws Exception {
        String resultTime = results.getString("time");
        int resultUserId = results.getInt("user");
        String resultWorldId = results.getString("wid");
        String resultX = results.getString("x");
        String resultY = results.getString("y");
        String resultZ = results.getString("z");
        String resultAction = results.getString("action");
        if (ConfigHandler.playerIdCacheReversed.get(resultUserId) == null) {
            UserStatement.loadName(connection, resultUserId);
        }
        String resultUser = ConfigHandler.playerIdCacheReversed.get(resultUserId);
        return new String[]{resultTime, resultUser, resultX, resultY, resultZ, resultWorldId, type, resultAction};
    }
}

