/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.wrapper;

import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.potion.PotionType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityAnimation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEffect;
import java.util.UUID;
import me.tofaa.entitylib.EntityLib;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import me.tofaa.entitylib.wrapper.WrapperEntityAttributes;
import me.tofaa.entitylib.wrapper.WrapperEntityEquipment;
import org.jetbrains.annotations.Nullable;

public class WrapperLivingEntity
extends WrapperEntity {
    private final WrapperEntityEquipment equipment = new WrapperEntityEquipment(this);
    private final WrapperEntityAttributes attributes = new WrapperEntityAttributes(this);

    public WrapperLivingEntity(int entityId, UUID uuid, EntityType entityType, EntityMeta entityMeta) {
        super(entityId, uuid, entityType, entityMeta);
    }

    public WrapperLivingEntity(int entityId, UUID uuid, EntityType entityType) {
        this(entityId, uuid, entityType, EntityMeta.createMeta(entityId, entityType));
    }

    public WrapperLivingEntity(int entityId, EntityType entityType) {
        this(entityId, EntityLib.getPlatform().getEntityUuidProvider().provide(entityType), entityType);
    }

    public WrapperLivingEntity(UUID uuid, EntityType entityType) {
        this(EntityLib.getPlatform().getEntityIdProvider().provide(uuid, entityType), uuid, entityType);
    }

    public WrapperLivingEntity(EntityType entityType) {
        this(EntityLib.getPlatform().getEntityUuidProvider().provide(entityType), entityType);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.equipment.refresh();
        this.attributes.refresh();
    }

    public WrapperEntityAttributes getAttributes() {
        return this.attributes;
    }

    public void addPotionEffect(PotionType type2, int amplifier, int duration, byte flags, boolean hasFactorData, @Nullable NBTCompound factorData) {
        this.sendPacketToViewers((PacketWrapper<?>)new WrapperPlayServerEntityEffect(this.getEntityId(), type2, amplifier, duration, flags));
    }

    public void addPotionEffect(PotionType type2, int amplifier, int duration, byte flags) {
        this.addPotionEffect(type2, amplifier, duration, flags, false, null);
    }

    public void playCriticalHitAnimation() {
        this.sendAnimation(WrapperPlayServerEntityAnimation.EntityAnimationType.CRITICAL_HIT);
    }

    public void playMagicCriticalHitAnimation() {
        this.sendAnimation(WrapperPlayServerEntityAnimation.EntityAnimationType.MAGIC_CRITICAL_HIT);
    }

    public void playWakeupAnimation() {
        this.sendAnimation(WrapperPlayServerEntityAnimation.EntityAnimationType.WAKE_UP);
    }

    public void playHurtAnimation() {
        this.sendAnimation(WrapperPlayServerEntityAnimation.EntityAnimationType.HURT);
    }

    public void swingMainHand() {
        this.sendAnimation(WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_MAIN_ARM);
    }

    public void swingOffHand() {
        this.sendAnimation(WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_OFF_HAND);
    }

    public void sendAnimation(WrapperPlayServerEntityAnimation.EntityAnimationType type2) {
        this.sendPacketToViewers((PacketWrapper<?>)new WrapperPlayServerEntityAnimation(this.getEntityId(), type2));
    }

    public WrapperEntityEquipment getEquipment() {
        return this.equipment;
    }
}

