/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.spigot;

import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.UUID;
import java.util.logging.Level;
import me.tofaa.entitylib.APIConfig;
import me.tofaa.entitylib.EntityLib;
import me.tofaa.entitylib.common.AbstractEntityLibAPI;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.types.LivingEntityMeta;
import me.tofaa.entitylib.meta.types.PlayerMeta;
import me.tofaa.entitylib.spigot.ExtraConversionUtil;
import me.tofaa.entitylib.spigot.SpigotEntityLibPlatform;
import me.tofaa.entitylib.tick.TickContainer;
import me.tofaa.entitylib.utils.Check;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import me.tofaa.entitylib.wrapper.WrapperLivingEntity;
import me.tofaa.entitylib.wrapper.WrapperPlayer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class SpigotEntityLibAPI
extends AbstractEntityLibAPI<JavaPlugin, BukkitTask> {
    SpigotEntityLibAPI(SpigotEntityLibPlatform platform, APIConfig settings) {
        super(platform, settings);
    }

    @Override
    public void onLoad() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    @NotNull
    public <T extends WrapperEntity> T cloneEntity(@NotNull Object platformEntity) {
        WrapperEntity entity;
        Check.stateCondition(!(platformEntity instanceof Entity), "Entity must be a Bukkit entity");
        Entity e = (Entity)platformEntity;
        EntityType type2 = SpigotConversionUtil.fromBukkitEntityType((org.bukkit.entity.EntityType)e.getType());
        EntityMeta meta = EntityMeta.createMeta(e.getEntityId(), type2);
        meta.setHasNoGravity(!e.hasGravity());
        meta.setCustomNameVisible(e.isCustomNameVisible());
        String customName = e.getCustomName();
        if (customName != null) {
            meta.setCustomName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(customName));
        }
        meta.setPose(ExtraConversionUtil.fromBukkitPose(e.getPose()));
        meta.setOnFire(e.getFireTicks() > 0);
        meta.setSilent(e.isSilent());
        meta.setHasGlowingEffect(e.isGlowing());
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            LivingEntityMeta lm = (LivingEntityMeta)meta;
            lm.setHealth((float)le.getHealth());
            lm.setFlyingWithElytra(le.isGliding());
        }
        if (e instanceof Player) {
            Player p = (Player)e;
            PlayerMeta pm = (PlayerMeta)meta;
            pm.setSneaking(p.isSneaking());
            pm.setSprinting(p.isSprinting());
            pm.setSwimming(p.isSwimming());
            pm.setActiveHand(ExtraConversionUtil.fromBukkitHand(p.getMainHand()));
        }
        int id = EntityLib.getPlatform().getEntityIdProvider().provide(e.getUniqueId(), type2);
        UUID uuid = e.getUniqueId();
        if (meta instanceof PlayerMeta) {
            Player p = (Player)e;
            entity = new WrapperPlayer(ExtraConversionUtil.getProfileFromBukkitPlayer(p), id);
        } else {
            entity = meta instanceof LivingEntityMeta ? new WrapperLivingEntity(id, uuid, type2, meta) : new WrapperEntity(id, uuid, type2, meta);
        }
        return (T)entity;
    }

    @Override
    public void addTickContainer(@NotNull TickContainer<?, BukkitTask> tickContainer) {
        if (!this.settings.shouldTickTickables()) {
            if (this.settings.isDebugMode()) {
                this.platform.getLogger().log(Level.WARNING, "Tried to add a TickContainer when ticking tickables is disabled!");
            }
            return;
        }
        this.tickContainers.add(tickContainer);
        if (this.settings.isDebugMode()) {
            this.platform.getLogger().log(Level.CONFIG, "Registering new tick container...");
        }
        this.getTickContainers().add(tickContainer);
        BukkitTask task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.platform.getHandle(), () -> tickContainer.tick(System.currentTimeMillis()), 1L, 1L);
        tickContainer.setHandle(task);
    }
}

