/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.mobs.villager;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.villager.VillagerData;
import com.github.retrooper.packetevents.protocol.entity.villager.profession.VillagerProfession;
import com.github.retrooper.packetevents.protocol.entity.villager.profession.VillagerProfessions;
import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerType;
import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerTypes;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.mobs.villager.BaseVillagerMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class VillagerMeta
extends BaseVillagerMeta {
    public static final byte OFFSET = 18;
    public static final byte MAX_OFFSET = 19;
    @ApiStatus.Internal
    public static final VillagerType[] TYPES = new VillagerType[]{VillagerTypes.DESERT, VillagerTypes.JUNGLE, VillagerTypes.PLAINS, VillagerTypes.SAVANNA, VillagerTypes.SNOW, VillagerTypes.SWAMP, VillagerTypes.TAIGA};
    @ApiStatus.Internal
    public static final VillagerProfession[] PROFESSIONS = new VillagerProfession[]{VillagerProfessions.NONE, VillagerProfessions.ARMORER, VillagerProfessions.BUTCHER, VillagerProfessions.CARTOGRAPHER, VillagerProfessions.CLERIC, VillagerProfessions.FARMER, VillagerProfessions.FISHERMAN, VillagerProfessions.FLETCHER, VillagerProfessions.LEATHERWORKER, VillagerProfessions.LIBRARIAN, VillagerProfessions.MASON, VillagerProfessions.NITWIT, VillagerProfessions.SHEPHERD, VillagerProfessions.TOOLSMITH, VillagerProfessions.WEAPONSMITH};

    public VillagerMeta(int entityId, Metadata metadata2) {
        super(entityId, metadata2);
    }

    @NotNull
    public VillagerData getVillagerData() {
        int[] data2 = this.metadata.getIndex((byte)18, null);
        if (data2 == null) {
            return new VillagerData(VillagerTypes.PLAINS, VillagerProfessions.NONE, Level.NOVICE.ordinal());
        }
        return new VillagerData(TYPES[data2[0]], PROFESSIONS[data2[1]], Level.VALUES[data2[2] - 1].ordinal());
    }

    public void setVillagerData(@NotNull VillagerData data2) {
        this.metadata.setIndex((byte)18, EntityDataTypes.VILLAGER_DATA, new VillagerData(data2.getType().getId(), data2.getProfession().getId(), data2.getLevel()));
    }

    public static enum Level {
        NOVICE,
        APPRENTICE,
        JOURNEYMAN,
        EXPERT,
        MASTER;

        public static final Level[] VALUES;

        static {
            VALUES = Level.values();
        }
    }
}

