/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.mobs;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.types.AgeableMeta;
import org.jetbrains.annotations.NotNull;

public class PandaMeta
extends AgeableMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 23;
    private static final byte SNEEZING_BIT = 2;
    private static final byte ROLLING_BIT = 4;
    private static final byte SITTING_BIT = 8;
    private static final byte ON_BACK_BIT = 16;

    public PandaMeta(int entityId, Metadata metadata2) {
        super(entityId, metadata2);
    }

    public int getBreedTimer() {
        return this.metadata.getIndex((byte)17, 0);
    }

    public void setBreedTimer(int value) {
        this.metadata.setIndex((byte)17, EntityDataTypes.INT, value);
    }

    public int getSneezeTimer() {
        return this.metadata.getIndex(PandaMeta.offset((byte)17, 1), 0);
    }

    public void setSneezeTimer(int value) {
        this.metadata.setIndex(PandaMeta.offset((byte)17, 1), EntityDataTypes.INT, value);
    }

    public int getEatTimer() {
        return this.metadata.getIndex(PandaMeta.offset((byte)17, 2), 0);
    }

    public void setEatTimer(int value) {
        this.metadata.setIndex(PandaMeta.offset((byte)17, 2), EntityDataTypes.INT, value);
    }

    @NotNull
    public Gene getMainGene() {
        return Gene.VALUES[this.metadata.getIndex(PandaMeta.offset((byte)17, 3), (byte)0)];
    }

    public void setMainGene(@NotNull Gene value) {
        this.metadata.setIndex(PandaMeta.offset((byte)17, 3), EntityDataTypes.BYTE, (byte)value.ordinal());
    }

    @NotNull
    public Gene getHiddenGene() {
        return Gene.VALUES[this.metadata.getIndex(PandaMeta.offset((byte)17, 4), (byte)0)];
    }

    public void setHiddenGene(@NotNull Gene value) {
        this.metadata.setIndex(PandaMeta.offset((byte)17, 4), EntityDataTypes.BYTE, (byte)value.ordinal());
    }

    public boolean isSneezing() {
        return this.getMaskBit(PandaMeta.offset((byte)17, 5), (byte)2);
    }

    public void setSneezing(boolean value) {
        this.setMaskBit(PandaMeta.offset((byte)17, 5), (byte)2, value);
    }

    public boolean isRolling() {
        return this.getMaskBit(PandaMeta.offset((byte)17, 5), (byte)4);
    }

    public void setRolling(boolean value) {
        this.setMaskBit(PandaMeta.offset((byte)17, 5), (byte)4, value);
    }

    public boolean isSitting() {
        return this.getMaskBit(PandaMeta.offset((byte)17, 5), (byte)8);
    }

    public void setSitting(boolean value) {
        this.setMaskBit(PandaMeta.offset((byte)17, 5), (byte)8, value);
    }

    public boolean isOnBack() {
        return this.getMaskBit(PandaMeta.offset((byte)17, 5), (byte)16);
    }

    public void setOnBack(boolean value) {
        this.setMaskBit(PandaMeta.offset((byte)17, 5), (byte)16, value);
    }

    public static enum Gene {
        NORMAL,
        AGGRESSIVE,
        LAZY,
        WORRIED,
        PLAYFUL,
        WEAK,
        BROWN;

        private static final Gene[] VALUES;

        static {
            VALUES = Gene.values();
        }
    }
}

