/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.display;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.display.AbstractDisplayMeta;

public class ItemDisplayMeta
extends AbstractDisplayMeta {
    public static final byte OFFSET = AbstractDisplayMeta.MAX_OFFSET;
    public static final byte MAX_OFFSET = ItemDisplayMeta.offset(OFFSET, 1);

    public ItemDisplayMeta(int entityId, Metadata metadata2) {
        super(entityId, metadata2);
    }

    public ItemStack getItem() {
        return this.metadata.getIndex(OFFSET, ItemStack.EMPTY);
    }

    public void setItem(ItemStack itemStack) {
        this.metadata.setIndex(OFFSET, EntityDataTypes.ITEMSTACK, itemStack);
    }

    public DisplayType getDisplayType() {
        return DisplayType.VALUES[this.metadata.getIndex(ItemDisplayMeta.offset(OFFSET, 1), (byte)0)];
    }

    public void setDisplayType(DisplayType displayType) {
        this.metadata.setIndex(ItemDisplayMeta.offset(OFFSET, 1), EntityDataTypes.BYTE, (byte)displayType.ordinal());
    }

    public static enum DisplayType {
        NONE,
        THIRD_PERSON_LEFT_HAND,
        THIRD_PERSON_RIGHT_HAND,
        FIRST_PERSON_LEFT_HAND,
        FIRST_PERSON_RIGHT_HAND,
        HEAD,
        GUI,
        GROUND,
        FIXED;

        private static final DisplayType[] VALUES;

        static {
            VALUES = DisplayType.values();
        }
    }
}

