/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.tofaa.entitylib.EntityLib;
import me.tofaa.entitylib.EntityLibAPI;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Metadata {
    private final int entityId;
    private volatile boolean notifyAboutChanges = true;
    private final HashMap<Byte, EntityData> notNotifiedChanges = new HashMap();
    private final ConcurrentHashMap<Byte, EntityData> metadataMap = new ConcurrentHashMap();

    public Metadata(int entityId) {
        this.entityId = entityId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(Metadata other) {
        other.clear();
        HashMap<Byte, EntityData> hashMap = other.notNotifiedChanges;
        synchronized (hashMap) {
            other.notNotifiedChanges.putAll(this.notNotifiedChanges);
        }
        other.metadataMap.putAll(this.metadataMap);
    }

    public void copyFrom(Metadata other) {
        other.copyTo(this);
    }

    public void clear() {
        this.metadataMap.clear();
        this.notNotifiedChanges.clear();
    }

    public <T> T getIndex(byte index, @Nullable T defaultValue) {
        EntityData value = this.metadataMap.get(index);
        return (T)(value != null ? value.getValue() : defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setIndex(byte index, @NotNull EntityDataType<T> dataType, T value) {
        EntityData entry = new EntityData((int)index, dataType, value);
        this.metadataMap.put(index, entry);
        Optional<EntityLibAPI<?>> optionalApi = EntityLib.getOptionalApi();
        if (!optionalApi.isPresent()) {
            return;
        }
        WrapperEntity entity = optionalApi.get().getEntity(this.entityId);
        if (entity == null || !entity.isSpawned()) {
            return;
        }
        if (!this.notifyAboutChanges) {
            HashMap<Byte, EntityData> hashMap = this.notNotifiedChanges;
            synchronized (hashMap) {
                this.notNotifiedChanges.put(index, entry);
            }
        } else {
            entity.sendPacketToViewers((PacketWrapper<?>)this.createPacket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyAboutChanges(boolean notifyAboutChanges) {
        if (this.notifyAboutChanges == notifyAboutChanges) {
            return;
        }
        ArrayList<EntityData> entries2 = null;
        HashMap<Byte, EntityData> hashMap = this.notNotifiedChanges;
        synchronized (hashMap) {
            this.notifyAboutChanges = notifyAboutChanges;
            if (notifyAboutChanges) {
                entries2 = new ArrayList<EntityData>(this.notNotifiedChanges.values());
                if (entries2.isEmpty()) {
                    return;
                }
                this.notNotifiedChanges.clear();
            }
        }
        WrapperEntity entity = EntityLib.getApi().getEntity(this.entityId);
        if (entries2 == null || entity == null || !entity.isSpawned()) {
            return;
        }
        WrapperPlayServerEntityMetadata packet = new WrapperPlayServerEntityMetadata(this.entityId, entries2);
        entity.sendPacketsToViewers(new PacketWrapper[]{packet});
    }

    public void setMetaFromPacket(WrapperPlayServerEntityMetadata wrapper) {
        for (EntityData data2 : wrapper.getEntityMetadata()) {
            this.metadataMap.put((byte)data2.getIndex(), data2);
        }
    }

    public boolean isNotifyingChanges() {
        return this.notifyAboutChanges;
    }

    @NotNull
    List<EntityData> getEntries() {
        return Collections.unmodifiableList(new ArrayList<EntityData>(this.metadataMap.values()));
    }

    public WrapperPlayServerEntityMetadata createPacket() {
        return new WrapperPlayServerEntityMetadata(this.entityId, this.getEntries());
    }
}

