/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.container;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import me.tofaa.entitylib.container.ContainerImpl;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityContainer
extends Iterable<WrapperEntity> {
    public static EntityContainer basic() {
        return new ContainerImpl();
    }

    public static EntityContainer empty() {
        return new EntityContainer(){

            @Override
            public void addEntity(WrapperEntity entity) {
            }

            @Override
            public void removeEntity(WrapperEntity entity, boolean despawn) {
            }

            @Override
            public void removeEntity(int entityId, boolean despawn) {
            }

            @Override
            public void removeEntity(UUID uuid, boolean despawn) {
            }

            @Override
            public void clearEntities(boolean despawn) {
            }

            @Override
            public void tick() {
            }

            @Override
            public Collection<WrapperEntity> getEntities() {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public WrapperEntity getEntity(UUID uuid) {
                return null;
            }

            @Override
            @Nullable
            public WrapperEntity getEntity(int entityId) {
                return null;
            }

            @Override
            public boolean containsEntity(UUID uuid) {
                return false;
            }

            @Override
            public boolean containsEntity(int entityId) {
                return false;
            }

            @Override
            public boolean containsEntity(WrapperEntity entity) {
                return false;
            }

            @Override
            @NotNull
            public Iterator<WrapperEntity> iterator() {
                return this.getEntities().iterator();
            }
        };
    }

    public void addEntity(WrapperEntity var1);

    public void removeEntity(WrapperEntity var1, boolean var2);

    default public void removeEntity(WrapperEntity entity) {
        this.removeEntity(entity, false);
    }

    public void removeEntity(int var1, boolean var2);

    default public void removeEntity(int entityId) {
        this.removeEntity(entityId, false);
    }

    public void removeEntity(UUID var1, boolean var2);

    default public void removeEntity(UUID entity) {
        this.removeEntity(entity, false);
    }

    public void clearEntities(boolean var1);

    default public void clearEntities() {
        this.clearEntities(false);
    }

    public void tick();

    public Collection<WrapperEntity> getEntities();

    @Nullable
    public WrapperEntity getEntity(UUID var1);

    @Nullable
    public WrapperEntity getEntity(int var1);

    public boolean containsEntity(UUID var1);

    public boolean containsEntity(int var1);

    public boolean containsEntity(WrapperEntity var1);
}

