/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.common;

import java.util.logging.Logger;
import me.tofaa.entitylib.APIConfig;
import me.tofaa.entitylib.EntityIdProvider;
import me.tofaa.entitylib.EntityUuidProvider;
import me.tofaa.entitylib.Platform;
import me.tofaa.entitylib.event.EventHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlatform<P>
implements Platform<P> {
    protected final P handle;
    protected Logger logger;
    private EventHandler eventHandler;
    private EntityIdProvider entityIdProvider;
    private EntityUuidProvider entityUuidProvider;

    public AbstractPlatform(P handle) {
        this.handle = handle;
        this.entityIdProvider = new EntityIdProvider.DefaultEntityIdProvider();
        this.entityUuidProvider = new EntityUuidProvider.DefaultEntityUuidProvider();
    }

    @Override
    public void setupApi(@NotNull APIConfig settings) {
        this.eventHandler = EventHandler.create();
        this.entityIdProvider = new EntityIdProvider.DefaultEntityIdProvider();
        this.entityUuidProvider = new EntityUuidProvider.DefaultEntityUuidProvider();
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public EntityIdProvider getEntityIdProvider() {
        return this.entityIdProvider;
    }

    @Override
    @NotNull
    public EntityUuidProvider getEntityUuidProvider() {
        return this.entityUuidProvider;
    }

    @Override
    public void setEntityIdProvider(EntityIdProvider entityIdProvider) {
        this.entityIdProvider = entityIdProvider;
    }

    @Override
    public void setEntityUuidProvider(EntityUuidProvider entityUuidProvider) {
        this.entityUuidProvider = entityUuidProvider;
    }

    @Override
    @NotNull
    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    @NotNull
    public P getHandle() {
        return this.handle;
    }
}

