/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char value) {
        super(Character.valueOf(value));
    }

    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module) {
        Intrinsics.checkNotNullParameter(module, "module");
        SimpleType simpleType2 = module.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "module.builtIns.charType");
        return simpleType2;
    }

    @Override
    @NotNull
    public String toString() {
        String string = "\\u%04X ('%s')";
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        return string2;
    }

    private final String getPrintablePart(char c2) {
        char c3 = c2;
        return c3 == '\b' ? "\\b" : (c3 == '\t' ? "\\t" : (c3 == '\n' ? "\\n" : (c3 == '\f' ? "\\f" : (c3 == '\r' ? "\\r" : (this.isPrintableUnicode(c2) ? String.valueOf(c2) : "?")))));
    }

    private final boolean isPrintableUnicode(char c2) {
        byte t = (byte)Character.getType(c2);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }
}

