/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.engine.ClassLoaderDelegate;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u0006\u0012\u0002\b\u00030\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\b*\u00020\u0003H\u0002\u001a\u0014\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\b*\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"allURLs", "", "Ljava/net/URL;", "Ljava/lang/ClassLoader;", "findURLClassPathField", "Ljava/lang/reflect/Field;", "Ljava/lang/Class;", "urlClassPath", "", "urlClassPathByPackagesList", "ktor-server-host-common"})
@SourceDebugExtension(value={"SMAP\nClassLoaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLoaders.kt\nio/ktor/server/engine/ClassLoadersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n1446#2,2:84\n1549#2:86\n1620#2,3:87\n1448#2,3:90\n1045#2:93\n1360#2:94\n1446#2,5:95\n1655#2,8:100\n1282#3,2:108\n1#4:110\n*S KotlinDebug\n*F\n+ 1 ClassLoaders.kt\nio/ktor/server/engine/ClassLoadersKt\n*L\n57#1:80\n57#1:81,3\n58#1:84,2\n60#1:86\n60#1:87,3\n58#1:90,3\n61#1:93\n63#1:94\n63#1:95,5\n64#1:100,8\n68#1:108,2\n*E\n"})
public final class ClassLoadersKt {
    @NotNull
    public static final Set<URL> allURLs(@NotNull ClassLoader $this$allURLs) {
        Set<URL> parentUrls;
        Intrinsics.checkNotNullParameter($this$allURLs, "<this>");
        Object object = $this$allURLs.getParent();
        if (object == null || (object = ClassLoadersKt.allURLs((ClassLoader)object)) == null) {
            object = parentUrls = SetsKt.emptySet();
        }
        if ($this$allURLs instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)$this$allURLs).getURLs();
            Intrinsics.checkNotNullExpressionValue(uRLArray, "urLs");
            Set urls = CollectionsKt.toSet((Iterable)ArraysKt.filterNotNull((Object[])uRLArray));
            return SetsKt.plus(urls, (Iterable)parentUrls);
        }
        List<URL> list = ClassLoadersKt.urlClassPath($this$allURLs);
        if (list == null) {
            return parentUrls;
        }
        List<URL> ucp = list;
        return SetsKt.plus(parentUrls, (Iterable)ucp);
    }

    private static final List<URL> urlClassPath(ClassLoader $this$urlClassPath) {
        try {
            Field field = ClassLoadersKt.findURLClassPathField($this$urlClassPath.getClass());
            if (field == null) {
                return null;
            }
            Field ucpField = field;
            ucpField.setAccessible(true);
            Object object = ucpField.get($this$urlClassPath);
            if (object == null) {
                return null;
            }
            Object ucpInstance = object;
            Method method2 = ucpInstance.getClass().getMethod("getURLs", new Class[0]);
            if (method2 == null) {
                return null;
            }
            Method getURLsMethod = method2;
            getURLsMethod.setAccessible(true);
            URL[] urls = (URL[])getURLsMethod.invoke(ucpInstance, new Object[0]);
            return urls != null ? ArraysKt.toList(urls) : null;
        }
        catch (Throwable _) {
            List<URL> list;
            try {
                list = ClassLoadersKt.urlClassPathByPackagesList($this$urlClassPath);
            }
            catch (Throwable _2) {
                list = null;
            }
            return list;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<URL> urlClassPathByPackagesList(ClassLoader $this$urlClassPathByPackagesList) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv;
        char[] it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = new ClassLoaderDelegate($this$urlClassPathByPackagesList).packagesList$ktor_server_host_common();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, '.', '/', false, 4, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv2;
            String packageName = (String)element$iv;
            boolean bl = false;
            it = new char[]{'/'};
            List segments2 = StringsKt.split$default((CharSequence)packageName, it, false, 0, 6, null);
            Iterable $this$map$iv2 = new IntRange(1, segments2.size());
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(CollectionsKt.joinToString$default(segments2.subList(0, (int)it2), "/", null, null, 0, null, null, 62, null));
            }
            Iterable list$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv2), packageName);
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        Iterable $this$sortedBy$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        List<String> allPackagePaths = CollectionsKt.plus((Collection)CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                boolean bl;
                char character;
                char element$iv;
                int n;
                String it = (String)a2;
                boolean bl2 = false;
                CharSequence $this$count$iv = it;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (n = 0; n < $this$count$iv.length(); ++n) {
                    character = element$iv = $this$count$iv.charAt(n);
                    bl = false;
                    if (!(character == '/')) continue;
                    ++count$iv;
                }
                it = (String)b2;
                Comparable comparable = Integer.valueOf(count$iv);
                bl2 = false;
                $this$count$iv = it;
                $i$f$count = false;
                count$iv = 0;
                for (n = 0; n < $this$count$iv.length(); ++n) {
                    character = element$iv = $this$count$iv.charAt(n);
                    bl = false;
                    if (!(character == '/')) continue;
                    ++count$iv;
                }
                return ComparisonsKt.compareValues(comparable, count$iv);
            }
        }), "");
        Iterable $this$flatMap$iv = allPackagePaths;
        boolean $i$f$flatMap = false;
        Iterable $i$f$flatMapTo22 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object object;
            block8: {
                block7: {
                    String path2 = (String)element$iv$iv;
                    boolean bl = false;
                    Enumeration<URL> enumeration = $this$urlClassPathByPackagesList.getResources(path2);
                    object = enumeration;
                    if (object == null) break block7;
                    Intrinsics.checkNotNullExpressionValue(object, "getResources(path)");
                    ArrayList<URL> arrayList = Collections.list(enumeration);
                    Intrinsics.checkNotNullExpressionValue(arrayList, "list(this)");
                    object = arrayList;
                    if (object != null) break block8;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            URL it3 = (URL)e$iv;
            boolean bl = false;
            String string = it3.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "it.path");
            String key$iv = StringsKt.substringBefore$default(string, '!', null, 2, null);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private static final Field findURLClassPathField(Class<?> $this$findURLClassPathField) {
        Object object;
        block3: {
            Field[] fieldArray = $this$findURLClassPathField.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue(fieldArray, "declaredFields");
            Object[] $this$firstOrNull$iv = fieldArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), "ucp") && Intrinsics.areEqual(it.getType().getSimpleName(), "URLClassPath"))) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Field field = (Field)object;
        if (field != null) {
            Field it = field;
            boolean bl = false;
            return it;
        }
        AnnotatedElement annotatedElement = $this$findURLClassPathField.getSuperclass();
        if (annotatedElement == null || (annotatedElement = ClassLoadersKt.findURLClassPathField(annotatedElement)) == null) {
            return null;
        }
        return annotatedElement;
    }
}

