/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.loader;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.typewritermc.loader.DependencyChecker;
import com.typewritermc.loader.EntryInfo;
import com.typewritermc.loader.Extension;
import com.typewritermc.loader.ExtensionFlag;
import com.typewritermc.loader.ExtensionLoaderKt;
import com.typewritermc.loader.PaperExtensionInfo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.qualifier.QualifierKt;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0017J\u0014\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010-\u001a\u00020\u001eJ\u0012\u0010.\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010/\u001a\u00020\u001eJ\u0006\u00100\u001a\u00020)R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00061"}, d2={"Lcom/typewritermc/loader/ExtensionLoader;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "logger$delegate", "Lkotlin/Lazy;", "dependencyChecker", "Lcom/typewritermc/loader/DependencyChecker;", "getDependencyChecker", "()Lcom/typewritermc/loader/DependencyChecker;", "dependencyChecker$delegate", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "classLoader", "Ljava/net/URLClassLoader;", "value", "", "Lcom/typewritermc/loader/Extension;", "extensions", "getExtensions", "()Ljava/util/List;", "entryClasses", "", "", "Ljava/lang/Class;", "hasShownLoadedMessage", "", "extensionJson", "Lcom/google/gson/JsonArray;", "getExtensionJson", "()Lcom/google/gson/JsonArray;", "setExtensionJson", "(Lcom/google/gson/JsonArray;)V", "load", "", "jars", "Ljava/io/File;", "entryClass", "blueprintId", "loadClass", "className", "unload", "engine-loader"})
@SourceDebugExtension(value={"SMAP\nExtensionLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionLoader.kt\ncom/typewritermc/loader/ExtensionLoader\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n58#2,6:247\n58#2,6:253\n58#2,6:259\n1863#3,2:265\n1557#3:267\n1628#3,3:268\n1611#3,9:273\n1863#3:282\n1864#3:285\n1620#3:286\n1557#3:287\n1628#3,3:288\n774#3:291\n865#3:292\n774#3:293\n865#3,2:294\n866#3:296\n1557#3:297\n1628#3,3:298\n1755#3,3:301\n1053#3:304\n295#3,2:305\n37#4,2:271\n1#5:283\n1#5:284\n*S KotlinDebug\n*F\n+ 1 ExtensionLoader.kt\ncom/typewritermc/loader/ExtensionLoader\n*L\n17#1:247,6\n18#1:253,6\n19#1:259,6\n33#1:265,2\n38#1:267\n38#1:268,3\n41#1:273,9\n41#1:282\n41#1:285\n41#1:286\n56#1:287\n56#1:288,3\n58#1:291\n58#1:292\n66#1:293\n66#1:294,2\n58#1:296\n76#1:297\n76#1:298,3\n99#1:301,3\n107#1:304\n127#1:305,2\n38#1:271,2\n41#1:284\n*E\n"})
public final class ExtensionLoader
implements KoinComponent {
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final Lazy dependencyChecker$delegate;
    @NotNull
    private final Lazy gson$delegate;
    @Nullable
    private URLClassLoader classLoader;
    @NotNull
    private List<Extension> extensions;
    @NotNull
    private Map<String, ? extends Class<?>> entryClasses;
    private boolean hasShownLoadedMessage;
    @NotNull
    private JsonArray extensionJson;

    public ExtensionLoader() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.logger$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Logger>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Logger invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Logger.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Logger.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.dependencyChecker$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<DependencyChecker>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DependencyChecker invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(DependencyChecker.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(DependencyChecker.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = QualifierKt.named("dataSerializer");
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.gson$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Gson>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Gson invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Gson.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Gson.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        this.extensions = CollectionsKt.emptyList();
        this.entryClasses = MapsKt.emptyMap();
        this.extensionJson = new JsonArray();
    }

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    private final DependencyChecker getDependencyChecker() {
        Lazy lazy = this.dependencyChecker$delegate;
        return (DependencyChecker)lazy.getValue();
    }

    private final Gson getGson() {
        Lazy lazy = this.gson$delegate;
        return (Gson)lazy.getValue();
    }

    @NotNull
    public final List<Extension> getExtensions() {
        return this.extensions;
    }

    @NotNull
    public final JsonArray getExtensionJson() {
        return this.extensionJson;
    }

    public final void setExtensionJson(@NotNull JsonArray jsonArray) {
        Intrinsics.checkNotNullParameter(jsonArray, "<set-?>");
        this.extensionJson = jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void load(@NotNull List<? extends File> jars) {
        Extension extension;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Pair extensionJson;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter(jars, "jars");
        Iterable $this$forEach$iv = jars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            File it = (File)element$iv;
            boolean bl2 = false;
            boolean bl3 = bl = it.exists() && it.canRead() && FilesKt.endsWith(it, ".jar");
            if (!_Assertions.ENABLED || bl) continue;
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.classLoader != null) {
            this.unload();
        }
        $this$forEach$iv = jars;
        ExtensionLoader extensionLoader = this;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.toURI().toURL());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        extensionLoader.classLoader = new URLClassLoader(uRLArray, classLoader);
        Iterable $this$mapNotNull$iv = jars;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Iterator destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Object bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Object object2;
            block36: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl4 = false;
                File jar2 = (File)element$iv$iv;
                boolean bl5 = false;
                Closeable closeable = new ZipFile(jar2);
                object = null;
                try {
                    Object zip2 = (ZipFile)closeable;
                    boolean bl6 = false;
                    ZipEntry jsonEntry = ((ZipFile)zip2).getEntry("extension.json");
                    if (jsonEntry == null) {
                        this.getLogger().severe("No extension.json file found in jar: " + jar2.getName() + ", is this a valid Typewriter extension?");
                        Object object3 = null;
                        object2 = object3;
                        break block36;
                    }
                    InputStream inputStream2 = ((ZipFile)zip2).getInputStream(jsonEntry);
                    Intrinsics.checkNotNullExpressionValue(inputStream2, "getInputStream(...)");
                    Closeable closeable2 = inputStream2;
                    Object object4 = Charsets.UTF_8;
                    Reader reader = new InputStreamReader((InputStream)closeable2, (Charset)object4);
                    int n = 8192;
                    closeable2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                    object4 = null;
                    try {
                        Object it = (BufferedReader)closeable2;
                        boolean bl7 = false;
                        it = TextStreamsKt.readText((Reader)it);
                    }
                    catch (Throwable it) {
                        object4 = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable2, (Throwable)object4);
                    }
                    zip2 = it;
                    object2 = zip2;
                }
                catch (Throwable zip3) {
                    object = zip3;
                    throw zip3;
                }
                finally {
                    CloseableKt.closeFinally(closeable, (Throwable)object);
                }
            }
            if (object2 == null) continue;
            Object it$iv$iv = object2;
            boolean bl8 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List extensionJsonTexts = (List)((Object)destination$iv$iv2);
        this.extensionJson = new JsonArray();
        $this$mapNotNull$iv = extensionJsonTexts;
        extensionLoader = this;
        boolean $i$f$map2 = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl9 = false;
            collection.add(TuplesKt.to(this.getGson().fromJson((String)((Object)extensionJson), Extension.class), extensionJson));
        }
        $this$map$iv = (List)((Object)destination$iv$iv2);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl10;
            extensionJson = (Pair)element$iv$iv;
            boolean bl11 = false;
            extension = (Extension)extensionJson.component1();
            PaperExtensionInfo paper = extension.getExtension().getPaper();
            if (paper == null) {
                this.getLogger().warning("Extension '" + extension.getExtension().getName() + "Extension' does not seem to be a paper extension. Ignoring extension.");
                bl10 = false;
            } else {
                void $this$filterTo$iv$iv2;
                List<String> dependencies = paper.getDependencies();
                Iterable $this$filter$iv2 = dependencies;
                boolean $i$f$filter2 = false;
                object = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                    String it = (String)element$iv$iv2;
                    boolean bl12 = false;
                    if (!(!this.getDependencyChecker().hasDependency(it))) continue;
                    destination$iv$iv3.add(element$iv$iv2);
                }
                List missingDependencies = (List)destination$iv$iv3;
                if (!((Collection)missingDependencies).isEmpty()) {
                    String missing = CollectionsKt.joinToString$default(missingDependencies, ", ", null, null, 0, null, null, 62, null);
                    this.getLogger().warning("Extension '" + extension.getExtension().getName() + "Extension' is missing dependencies: '" + missing + "'. Ignoring extension.");
                    bl10 = false;
                } else {
                    bl10 = true;
                }
            }
            if (!bl10) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)((Object)destination$iv$iv2);
        $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            extensionJson = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl13 = false;
            extension = (Extension)extensionJson.component1();
            String extensionJson2 = (String)extensionJson.component2();
            this.extensionJson.add(JsonParser.parseString((String)extensionJson2));
            collection.add(extension);
        }
        extensionLoader.extensions = (List)((Object)destination$iv$iv2);
        if (this.hasShownLoadedMessage) {
            return;
        }
        this.hasShownLoadedMessage = true;
        if (this.extensions.isEmpty()) {
            this.getLogger().warning(StringsKt.trimMargin$default("\n                |\n                |" + StringsKt.repeat("-", 15) + "{ No Extensions Loaded }" + StringsKt.repeat("-", 15) + "\n                |\n                |No extensions were loaded.\n                |You should always have at least the BasicExtension loaded.\n                |\n                |" + StringsKt.repeat("-", 50) + "\n                ", null, 1, null));
        } else {
            boolean bl14;
            block38: {
                Iterable $this$any$iv = this.extensions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl14 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Extension it = (Extension)element$iv;
                        boolean bl15 = false;
                        if (!it.getExtension().getFlags().contains((Object)ExtensionFlag.Unsupported)) continue;
                        bl14 = true;
                        break block38;
                    }
                    bl14 = false;
                }
            }
            String unsupportedMessage = bl14 ? "\nThere are unsupported extensions loaded. You won't get any support for these and should migrate them away from.\n" : "";
            destination$iv$iv2 = ((Iterable)this.extensions).iterator();
            if (!destination$iv$iv2.hasNext()) {
                throw new NoSuchElementException();
            }
            Extension it422 = (Extension)destination$iv$iv2.next();
            boolean bl16 = false;
            int it422 = it422.getExtension().getName().length();
            while (destination$iv$iv2.hasNext()) {
                Extension it32 = (Extension)destination$iv$iv2.next();
                $i$a$-maxOf-ExtensionLoader$load$maxExtensionLength$1 = false;
                int it32 = it32.getExtension().getName().length();
                if (it422 >= it32) continue;
                it422 = it32;
            }
            int maxExtensionLength = it422;
            Iterator it422 = ((Iterable)this.extensions).iterator();
            if (!it422.hasNext()) {
                throw new NoSuchElementException();
            }
            Extension it622 = (Extension)it422.next();
            boolean bl17 = false;
            int it622 = it622.getExtension().getVersion().length();
            while (it422.hasNext()) {
                Extension it52 = (Extension)it422.next();
                $i$a$-maxOf-ExtensionLoader$load$maxVersionLength$1 = false;
                int it52 = it52.getExtension().getVersion().length();
                if (it622 >= it52) continue;
                it622 = it52;
            }
            int maxVersionLength = it622;
            Iterator it622 = ((Iterable)this.extensions).iterator();
            if (!it622.hasNext()) {
                throw new NoSuchElementException();
            }
            Extension it22 = (Extension)it622.next();
            boolean bl18 = false;
            int it22 = ExtensionLoaderKt.access$getDigits(it22.getEntries().size());
            while (it622.hasNext()) {
                Extension it = (Extension)it622.next();
                $i$a$-maxOf-ExtensionLoader$load$maxDigits$1 = false;
                int n = ExtensionLoaderKt.access$getDigits(it.getEntries().size());
                if (it22 >= n) continue;
                it22 = n;
            }
            int maxDigits = it22;
            Iterable $this$sortedBy$iv = this.extensions;
            boolean $i$f$sortedBy = false;
            String extensionsDisplay = CollectionsKt.joinToString$default(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Extension it = (Extension)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getExtension().getName());
                    it = (Extension)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getExtension().getName()));
                }
            }), "\n", null, null, 0, null, arg_0 -> ExtensionLoader.load$lambda$14(maxExtensionLength, maxVersionLength, maxDigits, arg_0), 30, null);
            this.getLogger().info(StringsKt.trimMargin$default("\n                |\n                |" + StringsKt.repeat("-", 15) + "{ Loaded Extensions }" + StringsKt.repeat("-", 15) + "\n                |\n                |" + extensionsDisplay + "\n                |" + unsupportedMessage + "\n                |" + StringsKt.repeat("-", 50) + "\n                ", null, 1, null));
        }
    }

    @Nullable
    public final Class<?> entryClass(@NotNull String blueprintId) {
        String entryClassName;
        block5: {
            String string;
            Class<?> entryClass;
            Intrinsics.checkNotNullParameter(blueprintId, "blueprintId");
            Class<?> clazz = entryClass = this.entryClasses.get(blueprintId);
            if (clazz != null) {
                return clazz;
            }
            for (Extension extension : (Iterable)this.extensions) {
                Object v1;
                block4: {
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = extension.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        EntryInfo it = (EntryInfo)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getId(), blueprintId)) continue;
                        v1 = element$iv;
                        break block4;
                    }
                    v1 = null;
                }
                EntryInfo entryInfo = v1;
                String string2 = entryInfo != null ? entryInfo.getClassName() : null;
                if (string2 == null) continue;
                string = string2;
                break block5;
            }
            string = entryClassName = null;
        }
        if (entryClassName == null) {
            return null;
        }
        return this.loadClass(entryClassName);
    }

    @NotNull
    public final Class<?> loadClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        URLClassLoader uRLClassLoader = this.classLoader;
        if (uRLClassLoader != null) {
            URLClassLoader it = uRLClassLoader;
            boolean bl = false;
            Class<?> clazz = it.loadClass(className);
            Intrinsics.checkNotNullExpressionValue(clazz, "loadClass(...)");
            return clazz;
        }
        throw new IllegalStateException("ExtensionLoader tried to load a class before it was initialized");
    }

    public final void unload() {
        URLClassLoader uRLClassLoader = this.classLoader;
        if (uRLClassLoader != null) {
            uRLClassLoader.close();
        }
        this.classLoader = null;
        this.extensions = CollectionsKt.emptyList();
        this.entryClasses = MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    private static final CharSequence load$lambda$14(int $maxExtensionLength, int $maxVersionLength, int $maxDigits, Extension it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ExtensionLoaderKt.displayString(it, $maxExtensionLength, $maxVersionLength, $maxDigits);
    }
}

