/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.protocol.sound.StaticSound;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntitySoundEffect;
import com.typewritermc.core.entries.Query;
import com.typewritermc.core.extension.annotations.Default;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.entries.SoundEmitter;
import com.typewritermc.engine.paper.entry.entries.SoundSourceEntry;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.utils.EmitterSoundSource;
import com.typewritermc.engine.paper.utils.LocationSoundSource;
import com.typewritermc.engine.paper.utils.SelfSoundSource;
import com.typewritermc.engine.paper.utils.SoundId;
import com.typewritermc.engine.paper.utils.SoundKt;
import com.typewritermc.engine.paper.utils.SoundSource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J;\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u001a\u0010\u0018R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00061"}, d2={"Lcom/typewritermc/engine/paper/utils/Sound;", "", "soundId", "Lcom/typewritermc/engine/paper/utils/SoundId;", "soundSource", "Lcom/typewritermc/engine/paper/utils/SoundSource;", "track", "Lnet/kyori/adventure/sound/Sound$Source;", "volume", "", "pitch", "<init>", "(Lcom/typewritermc/engine/paper/utils/SoundId;Lcom/typewritermc/engine/paper/utils/SoundSource;Lnet/kyori/adventure/sound/Sound$Source;FF)V", "getSoundId", "()Lcom/typewritermc/engine/paper/utils/SoundId;", "getSoundSource$annotations", "()V", "getSoundSource", "()Lcom/typewritermc/engine/paper/utils/SoundSource;", "getTrack$annotations", "getTrack", "()Lnet/kyori/adventure/sound/Sound$Source;", "getVolume$annotations", "getVolume", "()F", "getPitch$annotations", "getPitch", "soundStop", "Lnet/kyori/adventure/sound/SoundStop;", "getSoundStop", "()Lnet/kyori/adventure/sound/SoundStop;", "play", "", "audience", "Lnet/kyori/adventure/audience/Audience;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nSound.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sound.kt\ncom/typewritermc/engine/paper/utils/Sound\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Query.kt\ncom/typewritermc/core/entries/Query$Companion\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n186#3:114\n1863#4,2:115\n*S KotlinDebug\n*F\n+ 1 Sound.kt\ncom/typewritermc/engine/paper/utils/Sound\n*L\n52#1:114\n57#1:115,2\n*E\n"})
public final class Sound {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SoundId soundId;
    @NotNull
    private final SoundSource soundSource;
    @NotNull
    private final Sound.Source track;
    private final float volume;
    private final float pitch;
    @NotNull
    private static final Sound EMPTY = new Sound(null, null, null, 0.0f, 0.0f, 31, null);

    public Sound(@NotNull SoundId soundId, @NotNull SoundSource soundSource, @NotNull Sound.Source track, float volume, float pitch) {
        Intrinsics.checkNotNullParameter(soundId, "soundId");
        Intrinsics.checkNotNullParameter(soundSource, "soundSource");
        Intrinsics.checkNotNullParameter(track, "track");
        this.soundId = soundId;
        this.soundSource = soundSource;
        this.track = track;
        this.volume = volume;
        this.pitch = pitch;
    }

    public /* synthetic */ Sound(SoundId soundId, SoundSource soundSource, Sound.Source source, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            soundId = SoundId.Companion.getEMPTY();
        }
        if ((n & 2) != 0) {
            soundSource = SelfSoundSource.INSTANCE;
        }
        if ((n & 4) != 0) {
            source = Sound.Source.MASTER;
        }
        if ((n & 8) != 0) {
            f = 1.0f;
        }
        if ((n & 0x10) != 0) {
            f2 = 1.0f;
        }
        this(soundId, soundSource, source, f, f2);
    }

    @NotNull
    public final SoundId getSoundId() {
        return this.soundId;
    }

    @NotNull
    public final SoundSource getSoundSource() {
        return this.soundSource;
    }

    @Help(text="The source of the location to play the sound from. (Defaults to player's location)")
    public static /* synthetic */ void getSoundSource$annotations() {
    }

    @NotNull
    public final Sound.Source getTrack() {
        return this.track;
    }

    @Help(text="Corresponds to the Minecraft sound category")
    public static /* synthetic */ void getTrack$annotations() {
    }

    public final float getVolume() {
        return this.volume;
    }

    @Help(text="A value of 1.0 is normal volume.")
    @Default(json="1.0")
    public static /* synthetic */ void getVolume$annotations() {
    }

    public final float getPitch() {
        return this.pitch;
    }

    @Help(text="A value of 1.0 is normal pitch.")
    @Default(json="1.0")
    public static /* synthetic */ void getPitch$annotations() {
    }

    @Nullable
    public final SoundStop getSoundStop() {
        SoundStop soundStop;
        NamespacedKey namespacedKey = this.soundId.getNamespacedKey();
        if (namespacedKey != null) {
            NamespacedKey it = namespacedKey;
            boolean bl = false;
            soundStop = SoundStop.named((Key)((Key)it));
        } else {
            soundStop = null;
        }
        return soundStop;
    }

    public final void play(@NotNull Audience audience) {
        Intrinsics.checkNotNullParameter(audience, "audience");
        NamespacedKey namespacedKey = this.soundId.getNamespacedKey();
        if (namespacedKey == null) {
            return;
        }
        NamespacedKey key2 = namespacedKey;
        net.kyori.adventure.sound.Sound sound = net.kyori.adventure.sound.Sound.sound((Key)((Key)key2), (Sound.Source)this.track, (float)this.volume, (float)this.pitch);
        Intrinsics.checkNotNullExpressionValue(sound, "sound(...)");
        net.kyori.adventure.sound.Sound sound2 = sound;
        SoundSource soundSource = this.soundSource;
        if (soundSource instanceof SelfSoundSource) {
            audience.playSound(sound2);
        } else if (soundSource instanceof EmitterSoundSource) {
            String entryId = ((EmitterSoundSource)this.soundSource).getEntryId();
            Query.Companion this_$iv = Query.Companion;
            boolean $i$f$findById = false;
            SoundSourceEntry entry = (SoundSourceEntry)this_$iv.findById(Reflection.getOrCreateKotlinClass(SoundSourceEntry.class), entryId);
            if (entry == null) {
                TypewriterPaperPluginKt.getLogger().warning("Could not find sound source entry with id " + entryId);
                return;
            }
            Iterable $this$forEach$iv = SoundKt.getViewers(audience);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player viewer = (Player)element$iv;
                boolean bl = false;
                SoundEmitter emitter = entry.getEmitter(viewer);
                StaticSound packetSound = new StaticSound(new ResourceLocation(key2.getNamespace(), key2.getKey()), Float.valueOf(16.0f));
                SoundCategory category = SoundCategory.fromId((int)this.track.ordinal());
                PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerEntitySoundEffect((com.github.retrooper.packetevents.protocol.sound.Sound)packetSound, category, emitter.getEntityId(), this.volume, this.pitch), viewer);
            }
        } else if (soundSource instanceof LocationSoundSource) {
            Position location = ((LocationSoundSource)this.soundSource).getPosition();
            audience.playSound(sound2, location.getX(), location.getY(), location.getZ());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public final SoundId component1() {
        return this.soundId;
    }

    @NotNull
    public final SoundSource component2() {
        return this.soundSource;
    }

    @NotNull
    public final Sound.Source component3() {
        return this.track;
    }

    public final float component4() {
        return this.volume;
    }

    public final float component5() {
        return this.pitch;
    }

    @NotNull
    public final Sound copy(@NotNull SoundId soundId, @NotNull SoundSource soundSource, @NotNull Sound.Source track, float volume, float pitch) {
        Intrinsics.checkNotNullParameter(soundId, "soundId");
        Intrinsics.checkNotNullParameter(soundSource, "soundSource");
        Intrinsics.checkNotNullParameter(track, "track");
        return new Sound(soundId, soundSource, track, volume, pitch);
    }

    public static /* synthetic */ Sound copy$default(Sound sound, SoundId soundId, SoundSource soundSource, Sound.Source source, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            soundId = sound.soundId;
        }
        if ((n & 2) != 0) {
            soundSource = sound.soundSource;
        }
        if ((n & 4) != 0) {
            source = sound.track;
        }
        if ((n & 8) != 0) {
            f = sound.volume;
        }
        if ((n & 0x10) != 0) {
            f2 = sound.pitch;
        }
        return sound.copy(soundId, soundSource, source, f, f2);
    }

    @NotNull
    public String toString() {
        return "Sound(soundId=" + this.soundId + ", soundSource=" + this.soundSource + ", track=" + this.track + ", volume=" + this.volume + ", pitch=" + this.pitch + ")";
    }

    public int hashCode() {
        int result = this.soundId.hashCode();
        result = result * 31 + this.soundSource.hashCode();
        result = result * 31 + this.track.hashCode();
        result = result * 31 + Float.hashCode(this.volume);
        result = result * 31 + Float.hashCode(this.pitch);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Sound)) {
            return false;
        }
        Sound sound = (Sound)other;
        if (!Intrinsics.areEqual(this.soundId, sound.soundId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.soundSource, sound.soundSource)) {
            return false;
        }
        if (this.track != sound.track) {
            return false;
        }
        if (Float.compare(this.volume, sound.volume) != 0) {
            return false;
        }
        return Float.compare(this.pitch, sound.pitch) == 0;
    }

    public Sound() {
        this(null, null, null, 0.0f, 0.0f, 31, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/typewritermc/engine/paper/utils/Sound$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/typewritermc/engine/paper/utils/Sound;", "getEMPTY", "()Lcom/typewritermc/engine/paper/utils/Sound;", "engine-paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Sound getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

