/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.typewritermc.core.utils.point.Position;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a.\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a.\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"interpolate", "Lcom/typewritermc/core/utils/point/Position;", "", "percentage", "", "interpolatePoints", "previousPoint", "currentPoint", "nextPoint", "nextNextPoint", "correctYaw", "currentYaw", "nextYaw", "engine-paper"})
public final class InterpolationKt {
    @NotNull
    public static final Position interpolate(@NotNull List<? extends Position> $this$interpolate, double percentage) {
        Position position;
        Position nextPoint;
        Intrinsics.checkNotNullParameter($this$interpolate, "<this>");
        double currentPart = percentage * (double)($this$interpolate.size() - 1);
        int index = (int)currentPart;
        double subPercentage = currentPart - (double)index;
        Position position2 = CollectionsKt.getOrNull($this$interpolate, index - 1);
        if (position2 == null) {
            position2 = $this$interpolate.get(index);
        }
        Position previousPoint = position2;
        Position currentPoint = $this$interpolate.get(index);
        Position position3 = CollectionsKt.getOrNull($this$interpolate, index + 1);
        if (position3 == null) {
            position3 = nextPoint = currentPoint;
        }
        if ((position = CollectionsKt.getOrNull($this$interpolate, index + 2)) == null) {
            position = nextPoint;
        }
        Position nextNextPoint = position;
        return InterpolationKt.interpolatePoints(previousPoint, currentPoint, nextPoint, nextNextPoint, subPercentage);
    }

    @NotNull
    public static final Position interpolatePoints(@NotNull Position previousPoint, @NotNull Position currentPoint, @NotNull Position nextPoint, @NotNull Position nextNextPoint, double percentage) {
        Intrinsics.checkNotNullParameter(previousPoint, "previousPoint");
        Intrinsics.checkNotNullParameter(currentPoint, "currentPoint");
        Intrinsics.checkNotNullParameter(nextPoint, "nextPoint");
        Intrinsics.checkNotNullParameter(nextNextPoint, "nextNextPoint");
        double x = InterpolationKt.interpolatePoints(previousPoint.getX(), currentPoint.getX(), nextPoint.getX(), nextNextPoint.getX(), percentage);
        double y = InterpolationKt.interpolatePoints(previousPoint.getY(), currentPoint.getY(), nextPoint.getY(), nextNextPoint.getY(), percentage);
        double z = InterpolationKt.interpolatePoints(previousPoint.getZ(), currentPoint.getZ(), nextPoint.getZ(), nextNextPoint.getZ(), percentage);
        double previousYaw = previousPoint.getYaw();
        double currentYaw = InterpolationKt.correctYaw(previousYaw, currentPoint.getYaw());
        double nextYaw = InterpolationKt.correctYaw(currentYaw, nextPoint.getYaw());
        double nextNextYaw = InterpolationKt.correctYaw(nextYaw, nextNextPoint.getYaw());
        double yaw = InterpolationKt.interpolatePoints(previousYaw, currentYaw, nextYaw, nextNextYaw, percentage);
        double pitch = InterpolationKt.interpolatePoints(previousPoint.getPitch(), currentPoint.getPitch(), nextPoint.getPitch(), nextNextPoint.getPitch(), percentage);
        return new Position(currentPoint.getWorld(), x, y, z, (float)yaw, (float)pitch);
    }

    public static final double interpolatePoints(double previousPoint, double currentPoint, double nextPoint, double nextNextPoint, double percentage) {
        double square = percentage * percentage;
        double cube = square * percentage;
        return 0.5 * ((double)2 * currentPoint + (-previousPoint + nextPoint) * percentage + ((double)2 * previousPoint - (double)5 * currentPoint + (double)4 * nextPoint - nextNextPoint) * square + (-previousPoint + (double)3 * currentPoint - (double)3 * nextPoint + nextNextPoint) * cube);
    }

    public static final double correctYaw(double currentYaw, double nextYaw) {
        double difference = nextYaw - currentYaw;
        return difference > 180.0 ? nextYaw - (double)360 : (difference < -180.0 ? nextYaw + (double)360 : nextYaw);
    }
}

