/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerParticle;
import com.typewritermc.engine.paper.TypewriterPaperPlugin;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.roadnetwork.content.RoadNetworkContentModeKt;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import lirand.api.extensions.server.ServerExtensionsKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;
import org.geysermc.floodgate.api.FloodgateApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.java.KoinJavaComponent;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0002\u001a!\u0010\t\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n*\u0004\u0018\u0001H\n2\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\f\u001a\"\u0010\r\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n*\u00020\u00052\u0006\u0010\u000e\u001a\u0002H\nH\u0086\u0004\u00a2\u0006\u0002\u0010\u000f\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\u0015\u0010\u0013\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0002\u001a0\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u001a\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\u00020 2\u0006\u0010\u0014\u001a\u00020 \u00a2\u0006\u0002\u0010!\u001a\u001a\u0010\"\u001a\u00020 *\u00020 2\u0006\u0010\u0014\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0015\u001a\r\u0010)\u001a\u00020\u0015*\u00020 H\u0086\u0002\u001a\r\u0010*\u001a\u00020\u0015*\u00020 H\u0086\u0002\u001a\r\u0010+\u001a\u00020\u0015*\u00020 H\u0086\u0002\u001a6\u0010,\u001a\u00020\u0017*\u00020 2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000202\u001a\u0012\u00104\u001a\u00020\u0015*\u00020\u00152\u0006\u00105\u001a\u000202\u001a\u0012\u00104\u001a\u00020\u001d*\u00020\u001d2\u0006\u00105\u001a\u000202\u001a\n\u0010K\u001a\u00020D*\u00020D\u001a\u0010\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u0003H\u0002\u001a\u0012\u0010S\u001a\u00020\u0017*\u00020T2\u0006\u0010R\u001a\u00020\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\"\u0015\u0010$\u001a\u00020 *\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u0015\u0010'\u001a\u00020 *\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&\"\u0015\u00106\u001a\u000202*\u0002028F\u00a2\u0006\u0006\u001a\u0004\b7\u00108\"\u0015\u00109\u001a\u000202*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\"-\u0010<\u001a\b\u0012\u0004\u0012\u0002H\n0=\"\b\b\u0000\u0010\n*\u00020>*\n\u0012\u0004\u0012\u0002H\n\u0018\u00010=8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\"'\u0010<\u001a\b\u0012\u0004\u0012\u0002H\n0=\"\b\b\u0000\u0010\n*\u00020>*\u0004\u0018\u0001H\n8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010A\",\u0010C\u001a\u0004\u0018\u00010\u0003*\u00020D2\b\u0010B\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010F\"\u0004\bG\u0010H\",\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020D2\b\u0010B\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bI\u0010F\"\u0004\bJ\u0010H\"\u0018\u0010L\u001a\n N*\u0004\u0018\u00010M0MX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010O\u00a8\u0006U"}, d2={"get", "Ljava/io/File;", "name", "", "isFloodgate", "", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;)Z", "isLookable", "logErrorIfNull", "T", "message", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "then", "t", "(ZLjava/lang/Object;)Ljava/lang/Object;", "toTicks", "", "Ljava/time/Duration;", "times", "other", "", "playSound", "", "Lnet/kyori/adventure/audience/Audience;", "sound", "source", "Lnet/kyori/adventure/sound/Sound$Source;", "volume", "", "pitch", "distanceSqrt", "Lorg/bukkit/Location;", "(Lorg/bukkit/Location;Lorg/bukkit/Location;)Ljava/lang/Double;", "lerp", "amount", "up", "getUp", "(Lorg/bukkit/Location;)Lorg/bukkit/Location;", "firstWalkableLocationBelow", "getFirstWalkableLocationBelow", "component1", "component2", "component3", "particleSphere", "player", "radius", "color", "Lorg/bukkit/Color;", "phiDivisions", "", "thetaDivisions", "round", "decimals", "digits", "getDigits", "(I)I", "lineCount", "getLineCount", "(Ljava/lang/String;)I", "optional", "Ljava/util/Optional;", "", "getOptional", "(Ljava/util/Optional;)Ljava/util/Optional;", "(Ljava/lang/Object;)Ljava/util/Optional;", "value", "loreString", "Lorg/bukkit/inventory/meta/ItemMeta;", "getLoreString", "(Lorg/bukkit/inventory/meta/ItemMeta;)Ljava/lang/String;", "setLoreString", "(Lorg/bukkit/inventory/meta/ItemMeta;Ljava/lang/String;)V", "getName", "setName", "unClickable", "RANDOM_UUID", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "Ljava/util/UUID;", "getProfile", "Lcom/destroystokyo/paper/profile/PlayerProfile;", "url", "applySkinUrl", "Lorg/bukkit/inventory/meta/SkullMeta;", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ncom/typewritermc/engine/paper/utils/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1#2:193\n1104#3,3:194\n1557#4:197\n1628#4,3:198\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\ncom/typewritermc/engine/paper/utils/ExtensionsKt\n*L\n152#1:194,3\n160#1:197\n160#1:198,3\n*E\n"})
public final class ExtensionsKt {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    @NotNull
    public static final File get(@NotNull File $this$get, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$get, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        return new File($this$get, name);
    }

    public static final boolean isFloodgate(@NotNull Player $this$isFloodgate) {
        Intrinsics.checkNotNullParameter($this$isFloodgate, "<this>");
        if (!((TypewriterPaperPlugin)KoinJavaComponent.get$default(TypewriterPaperPlugin.class, null, null, 6, null)).isFloodgateInstalled()) {
            return false;
        }
        return FloodgateApi.getInstance().isFloodgatePlayer($this$isFloodgate.getUniqueId());
    }

    public static final boolean isLookable(@NotNull Player $this$isLookable) {
        Intrinsics.checkNotNullParameter($this$isLookable, "<this>");
        return $this$isLookable.isValid() && $this$isLookable.getGameMode() != GameMode.SPECTATOR && !$this$isLookable.isInvisible();
    }

    @Nullable
    public static final <T> T logErrorIfNull(@Nullable T $this$logErrorIfNull, @NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if ($this$logErrorIfNull == null) {
            TypewriterPaperPluginKt.getLogger().severe(message);
        }
        return $this$logErrorIfNull;
    }

    @Nullable
    public static final <T> T then(boolean $this$then, T t) {
        return (T)($this$then ? t : null);
    }

    public static final long toTicks(@NotNull Duration $this$toTicks) {
        Intrinsics.checkNotNullParameter($this$toTicks, "<this>");
        return $this$toTicks.toMillis() / (long)50;
    }

    @NotNull
    public static final Duration times(@NotNull Duration $this$times, double other) {
        Intrinsics.checkNotNullParameter($this$times, "<this>");
        Duration duration = Duration.ofMillis(MathKt.roundToLong((double)$this$times.toMillis() * other));
        Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
        return duration;
    }

    public static final void playSound(@NotNull Audience $this$playSound, @NotNull String sound, @NotNull Sound.Source source, float volume, float pitch) {
        Intrinsics.checkNotNullParameter($this$playSound, "<this>");
        Intrinsics.checkNotNullParameter(sound, "sound");
        Intrinsics.checkNotNullParameter(source, "source");
        $this$playSound.playSound(Sound.sound((Key)Key.key((String)sound), (Sound.Source)source, (float)volume, (float)pitch));
    }

    public static /* synthetic */ void playSound$default(Audience audience, String string, Sound.Source source, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            source = Sound.Source.MASTER;
        }
        if ((n & 4) != 0) {
            f = 1.0f;
        }
        if ((n & 8) != 0) {
            f2 = 1.0f;
        }
        ExtensionsKt.playSound(audience, string, source, f, f2);
    }

    @Nullable
    public static final Double distanceSqrt(@NotNull Location $this$distanceSqrt, @NotNull Location other) {
        Intrinsics.checkNotNullParameter($this$distanceSqrt, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        if (!Intrinsics.areEqual($this$distanceSqrt.getWorld(), other.getWorld())) {
            return null;
        }
        double dx = $this$distanceSqrt.getX() - other.getX();
        double dy = $this$distanceSqrt.getY() - other.getY();
        double dz = $this$distanceSqrt.getZ() - other.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    @NotNull
    public static final Location lerp(@NotNull Location $this$lerp, @NotNull Location other, double amount) {
        Intrinsics.checkNotNullParameter($this$lerp, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        double percentage = RangesKt.coerceIn(amount, 0.0, 1.0);
        double x = $this$lerp.getX() + (other.getX() - $this$lerp.getX()) * percentage;
        double y = $this$lerp.getY() + (other.getY() - $this$lerp.getY()) * percentage;
        double z = $this$lerp.getZ() + (other.getZ() - $this$lerp.getZ()) * percentage;
        return new Location($this$lerp.getWorld(), x, y, z);
    }

    @NotNull
    public static final Location getUp(@NotNull Location $this$up) {
        Location location;
        Intrinsics.checkNotNullParameter($this$up, "<this>");
        Location location2 = $this$up.clone();
        Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
        Location $this$_get_up__u24lambda_u240 = location = location2;
        boolean bl = false;
        $this$_get_up__u24lambda_u240.setY($this$_get_up__u24lambda_u240.getY() + 1.0);
        return location;
    }

    @NotNull
    public static final Location getFirstWalkableLocationBelow(@NotNull Location $this$firstWalkableLocationBelow) {
        double d;
        Location location;
        Intrinsics.checkNotNullParameter($this$firstWalkableLocationBelow, "<this>");
        Location location2 = $this$firstWalkableLocationBelow.clone();
        Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
        Location $this$_get_firstWalkableLocationBelow__u24lambda_u241 = location = location2;
        boolean bl = false;
        while ($this$_get_firstWalkableLocationBelow__u24lambda_u241.getBlock().isPassable()) {
            d = $this$_get_firstWalkableLocationBelow__u24lambda_u241.getY();
            $this$_get_firstWalkableLocationBelow__u24lambda_u241.setY(d + -1.0);
        }
        d = $this$_get_firstWalkableLocationBelow__u24lambda_u241.getY();
        $this$_get_firstWalkableLocationBelow__u24lambda_u241.setY(d + 1.0);
        return location;
    }

    public static final double component1(@NotNull Location $this$component1) {
        Intrinsics.checkNotNullParameter($this$component1, "<this>");
        return $this$component1.getX();
    }

    public static final double component2(@NotNull Location $this$component2) {
        Intrinsics.checkNotNullParameter($this$component2, "<this>");
        return $this$component2.getY();
    }

    public static final double component3(@NotNull Location $this$component3) {
        Intrinsics.checkNotNullParameter($this$component3, "<this>");
        return $this$component3.getZ();
    }

    public static final void particleSphere(@NotNull Location $this$particleSphere, @NotNull Player player, double radius, @NotNull Color color, int phiDivisions, int thetaDivisions) {
        Intrinsics.checkNotNullParameter($this$particleSphere, "<this>");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(color, "color");
        double phi = 0.0;
        while (phi < Math.PI) {
            phi += Math.PI / (double)phiDivisions;
            double theta = 0.0;
            while (theta < Math.PI * 2) {
                double x = radius * Math.sin(phi) * Math.cos(theta += Math.PI / (double)thetaDivisions);
                double y = radius * Math.cos(phi);
                double z = radius * Math.sin(phi) * Math.sin(theta);
                PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerParticle(new Particle(ParticleTypes.DUST, (ParticleData)new ParticleDustData((float)Math.sqrt(radius / (double)3), RoadNetworkContentModeKt.toPacketColor(color))), true, new Vector3d($this$particleSphere.getX() + x, $this$particleSphere.getY() + y, $this$particleSphere.getZ() + z), Vector3f.zero(), 0.0f, 1), player);
            }
        }
    }

    public static /* synthetic */ void particleSphere$default(Location location, Player player, double d, Color color, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = 16;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 8;
        }
        ExtensionsKt.particleSphere(location, player, d, color, n, n2);
    }

    public static final double round(double $this$round, int decimals) {
        double multiplier = 0.0;
        multiplier = 1.0;
        int n = 0;
        while (n < decimals) {
            int it = n++;
            boolean bl = false;
            multiplier *= (double)10;
        }
        return Math.rint($this$round * multiplier) / multiplier;
    }

    public static final float round(float $this$round, int decimals) {
        double multiplier = 0.0;
        multiplier = 1.0;
        int n = 0;
        while (n < decimals) {
            int it = n++;
            boolean bl = false;
            multiplier *= (double)10;
        }
        return (float)(Math.rint((double)$this$round * multiplier) / multiplier);
    }

    public static final int getDigits(int $this$digits) {
        return $this$digits == 0 ? 1 : (int)Math.log10(Math.abs((double)$this$digits)) + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getLineCount(@NotNull String $this$lineCount) {
        void var3_3;
        Intrinsics.checkNotNullParameter($this$lineCount, "<this>");
        CharSequence $this$count$iv = $this$lineCount;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        return (int)(var3_3 + true);
    }

    @NotNull
    public static final <T> Optional<T> getOptional(@Nullable Optional<T> $this$optional) {
        Optional<Object> optional = $this$optional;
        Optional<Object> optional2 = Optional.ofNullable(optional != null ? optional.orElse(null) : null);
        Intrinsics.checkNotNullExpressionValue(optional2, "ofNullable(...)");
        return optional2;
    }

    @NotNull
    public static final <T> Optional<T> getOptional(@Nullable T $this$optional) {
        Optional<T> optional = Optional.ofNullable($this$optional);
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(...)");
        return optional;
    }

    @Nullable
    public static final String getLoreString(@NotNull ItemMeta $this$loreString) {
        Intrinsics.checkNotNullParameter($this$loreString, "<this>");
        List list = $this$loreString.lore();
        return list != null ? CollectionsKt.joinToString$default(list, "\n", null, null, 0, null, ExtensionsKt::_get_loreString_$lambda$5, 30, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void setLoreString(@NotNull ItemMeta $this$loreString, @Nullable String value) {
        List list;
        Object object;
        Intrinsics.checkNotNullParameter($this$loreString, "<this>");
        ItemMeta itemMeta = $this$loreString;
        Object object2 = value;
        if (object2 != null && (object2 = StringsKt.split$default((CharSequence)object2, object = new String[]{"\n"}, false, 0, 6, null)) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = (Iterable)object2;
            ItemMeta itemMeta2 = itemMeta;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MiniMessagesKt.asMini("<!i><white>" + (String)it));
            }
            list = (List)destination$iv$iv;
            itemMeta = itemMeta2;
        } else {
            list = null;
        }
        itemMeta.lore(list);
    }

    @Nullable
    public static final String getName(@NotNull ItemMeta $this$name) {
        String string;
        Intrinsics.checkNotNullParameter($this$name, "<this>");
        if ($this$name.hasDisplayName()) {
            Component component = $this$name.displayName();
            string = component != null ? MiniMessagesKt.asMini(component) : null;
        } else {
            string = null;
        }
        return string;
    }

    public static final void setName(@NotNull ItemMeta $this$name, @Nullable String value) {
        Component component;
        Intrinsics.checkNotNullParameter($this$name, "<this>");
        CharSequence charSequence = value;
        if (!(charSequence == null || charSequence.length() == 0)) {
            component = MiniMessagesKt.asMini("<!i>" + value);
        } else {
            TextComponent textComponent = Component.text((String)" ");
            Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
            component = (Component)textComponent;
        }
        $this$name.displayName(component);
    }

    @NotNull
    public static final ItemMeta unClickable(@NotNull ItemMeta $this$unClickable) {
        Intrinsics.checkNotNullParameter($this$unClickable, "<this>");
        $this$unClickable.addEnchant(Enchantment.BINDING_CURSE, 1, true);
        ItemFlag[] itemFlagArray = new ItemFlag[]{ItemFlag.HIDE_ENCHANTS};
        $this$unClickable.addItemFlags(itemFlagArray);
        return $this$unClickable;
    }

    /*
     * WARNING - void declaration
     */
    private static final PlayerProfile getProfile(String url2) {
        URL uRL;
        PlayerTextures playerTextures;
        PlayerTextures textures;
        PlayerProfile playerProfile = ServerExtensionsKt.getServer().createProfile(RANDOM_UUID);
        Intrinsics.checkNotNullExpressionValue(playerProfile, "createProfile(...)");
        PlayerProfile profile = playerProfile;
        PlayerTextures playerTextures2 = profile.getTextures();
        Intrinsics.checkNotNullExpressionValue(playerTextures2, "getTextures(...)");
        PlayerTextures playerTextures3 = textures = playerTextures2;
        try {
            playerTextures = playerTextures3;
            uRL = new URI(url2).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            void exception;
            PlayerTextures playerTextures4 = playerTextures3;
            throw new RuntimeException("Invalid URL", (Throwable)exception);
        }
        playerTextures.setSkin(uRL);
        profile.setTextures(textures);
        return profile;
    }

    public static final void applySkinUrl(@NotNull SkullMeta $this$applySkinUrl, @NotNull String url2) {
        Intrinsics.checkNotNullParameter($this$applySkinUrl, "<this>");
        Intrinsics.checkNotNullParameter(url2, "url");
        $this$applySkinUrl.setPlayerProfile(ExtensionsKt.getProfile(url2));
    }

    private static final CharSequence _get_loreString_$lambda$5(Component it) {
        Intrinsics.checkNotNull(it);
        return MiniMessagesKt.asMini(it);
    }
}

