/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.utils;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\n\u0018\u0000 (2\u00020\u0001:\u0007\"#$%&'(B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0019H\u0007J\u001b\u0010\u001e\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u001fH\u0002\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/typewritermc/engine/paper/utils/CronExpression;", "", "expression", "", "withSeconds", "", "<init>", "(Ljava/lang/String;Z)V", "getExpression", "()Ljava/lang/String;", "getWithSeconds", "()Z", "secondField", "Lcom/typewritermc/engine/paper/utils/CronExpression$SimpleField;", "minuteField", "hourField", "dayOfWeekField", "Lcom/typewritermc/engine/paper/utils/CronExpression$DayOfWeekField;", "monthField", "dayOfMonthField", "Lcom/typewritermc/engine/paper/utils/CronExpression$DayOfMonthField;", "nextLocalDateTimeAfter", "Ljava/time/LocalDateTime;", "dateTime", "nextTimeAfter", "Ljava/time/ZonedDateTime;", "afterTime", "durationInMillis", "", "dateTimeBarrier", "findDay", "", "([Ljava/time/ZonedDateTime;)Z", "toString", "CronFieldType", "FieldPart", "BasicField", "SimpleField", "DayOfWeekField", "DayOfMonthField", "Companion", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nCronExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CronExpression.kt\ncom/typewritermc/engine/paper/utils/CronExpression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,583:1\n739#2,9:584\n37#3,2:593\n*S KotlinDebug\n*F\n+ 1 CronExpression.kt\ncom/typewritermc/engine/paper/utils/CronExpression\n*L\n225#1:584,9\n225#1:593,2\n*E\n"})
public final class CronExpression {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String expression;
    private final boolean withSeconds;
    @NotNull
    private final SimpleField secondField;
    @NotNull
    private final SimpleField minuteField;
    @NotNull
    private final SimpleField hourField;
    @NotNull
    private final DayOfWeekField dayOfWeekField;
    @NotNull
    private final SimpleField monthField;
    @NotNull
    private final DayOfMonthField dayOfMonthField;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public CronExpression(@NotNull String expression, boolean withSeconds) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.expression = expression;
        this.withSeconds = withSeconds;
        int expectedParts = this.withSeconds ? 6 : 5;
        Object object = this.expression;
        Regex regex = new Regex("\\s+");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (parts.length != expectedParts) {
            String string = "Invalid cron expression [%s], expected %s field, got %s";
            Object[] objectArray = new Object[]{this.expression, expectedParts, parts.length};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new IllegalArgumentException(string2);
        }
        int ix = this.withSeconds ? 1 : 0;
        this.secondField = new SimpleField(CronFieldType.SECOND, this.withSeconds ? parts[0] : "0");
        this.minuteField = new SimpleField(CronFieldType.MINUTE, parts[ix++]);
        this.hourField = new SimpleField(CronFieldType.HOUR, parts[ix++]);
        this.dayOfMonthField = new DayOfMonthField(parts[ix++]);
        this.monthField = new SimpleField(CronFieldType.MONTH, parts[ix++]);
        this.dayOfWeekField = new DayOfWeekField(parts[ix++]);
    }

    public /* synthetic */ CronExpression(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    public final boolean getWithSeconds() {
        return this.withSeconds;
    }

    @NotNull
    public final LocalDateTime nextLocalDateTimeAfter(@Nullable LocalDateTime dateTime) {
        ZonedDateTime zonedDateTime = ZonedDateTime.of(dateTime, ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue(zonedDateTime, "of(...)");
        LocalDateTime localDateTime = CronExpression.nextTimeAfter$default(this, zonedDateTime, null, 2, null).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue(localDateTime, "toLocalDateTime(...)");
        return localDateTime;
    }

    @NotNull
    public final ZonedDateTime nextTimeAfter(@NotNull ZonedDateTime afterTime, long durationInMillis) {
        Intrinsics.checkNotNullParameter(afterTime, "afterTime");
        ZonedDateTime zonedDateTime = afterTime.plus(Duration.ofMillis(durationInMillis));
        Intrinsics.checkNotNullExpressionValue(zonedDateTime, "plus(...)");
        return this.nextTimeAfter(afterTime, zonedDateTime);
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime nextTimeAfter(@NotNull ZonedDateTime afterTime, @NotNull ZonedDateTime dateTimeBarrier) {
        Intrinsics.checkNotNullParameter(afterTime, "afterTime");
        Intrinsics.checkNotNullParameter(dateTimeBarrier, "dateTimeBarrier");
        ZonedDateTime[] zonedDateTimeArray = new ZonedDateTime[]{afterTime.plusSeconds(1L).withNano(0)};
        ZonedDateTime[] nextDateTime = zonedDateTimeArray;
        do {
            ZonedDateTime zonedDateTime = nextDateTime[0];
            Intrinsics.checkNotNullExpressionValue(zonedDateTime, "get(...)");
            CronExpression.Companion.checkIfDateTimeBarrierIsReached(zonedDateTime, dateTimeBarrier);
        } while (!this.monthField.nextMatch(nextDateTime) || !this.findDay(nextDateTime) || !this.hourField.nextMatch(nextDateTime) || !this.minuteField.nextMatch(nextDateTime) || !this.secondField.nextMatch(nextDateTime));
        ZonedDateTime zonedDateTime = nextDateTime[0];
        Intrinsics.checkNotNullExpressionValue(zonedDateTime, "get(...)");
        CronExpression.Companion.checkIfDateTimeBarrierIsReached(zonedDateTime, dateTimeBarrier);
        ZonedDateTime zonedDateTime2 = nextDateTime[0];
        Intrinsics.checkNotNullExpressionValue(zonedDateTime2, "get(...)");
        return zonedDateTime2;
    }

    public static /* synthetic */ ZonedDateTime nextTimeAfter$default(CronExpression cronExpression, ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, int n, Object object) {
        if ((n & 2) != 0) {
            zonedDateTime2 = zonedDateTime.plusYears(4L);
        }
        return cronExpression.nextTimeAfter(zonedDateTime, zonedDateTime2);
    }

    private final boolean findDay(ZonedDateTime[] dateTime) {
        block2: {
            int month = dateTime[0].getMonthValue();
            do {
                LocalDate localDate = dateTime[0].toLocalDate();
                Intrinsics.checkNotNullExpressionValue(localDate, "toLocalDate(...)");
                if (this.dayOfMonthField.matches(localDate)) {
                    LocalDate localDate2 = dateTime[0].toLocalDate();
                    Intrinsics.checkNotNullExpressionValue(localDate2, "toLocalDate(...)");
                    if (this.dayOfWeekField.matches(localDate2)) break block2;
                }
                Intrinsics.checkNotNullExpressionValue(dateTime[0].plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0), "withNano(...)");
            } while (dateTime[0].getMonthValue() == month);
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.expression + ">";
    }

    @JvmOverloads
    public CronExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this(expression, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final ZonedDateTime nextTimeAfter(@NotNull ZonedDateTime afterTime) {
        Intrinsics.checkNotNullParameter(afterTime, "afterTime");
        return CronExpression.nextTimeAfter$default(this, afterTime, null, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b \u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\fH\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\fH\u0014J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\fH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/engine/paper/utils/CronExpression$BasicField;", "", "fieldType", "Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "fieldExpr", "", "<init>", "(Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;Ljava/lang/String;)V", "getFieldType", "()Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "parts", "", "Lcom/typewritermc/engine/paper/utils/CronExpression$FieldPart;", "getParts", "()Ljava/util/List;", "parse", "", "validatePart", "part", "validateRange", "mapValue", "", "value", "matches", "", "val", "nextMatch", "Companion", "engine-paper"})
    @SourceDebugExtension(value={"SMAP\nCronExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CronExpression.kt\ncom/typewritermc/engine/paper/utils/CronExpression$BasicField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,583:1\n739#2,9:584\n37#3,2:593\n*S KotlinDebug\n*F\n+ 1 CronExpression.kt\ncom/typewritermc/engine/paper/utils/CronExpression$BasicField\n*L\n331#1:584,9\n331#1:593,2\n*E\n"})
    public static abstract class BasicField {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final CronFieldType fieldType;
        @NotNull
        private final List<FieldPart> parts;
        private static final Pattern CRON_FIELD_REGEXP = Pattern.compile("(?:                                             # start of group 1\n   (?:(?<all>\\*)|(?<ignore>\\?)|(?<last>L))  # global flag (L, ?, *)\n | (?<start>[0-9]{1,2}|[a-z]{3})              # or start number or symbol\n      (?:                                        # start of group 2\n         (?<mod>L|W)                             # modifier (L,W)\n       | -(?<end>[0-9]{1,2}|[a-z]{3})        # or end nummer or symbol (in range)\n      )?                                         # end of group 2\n)                                              # end of group 1\n(?:(?<incmod>/|\\#)(?<inc>[0-9]{1,7}))?        # increment and increment modifier (/ or \\#)\n", 6);

        public BasicField(@NotNull CronFieldType fieldType, @NotNull String fieldExpr) {
            Intrinsics.checkNotNullParameter((Object)fieldType, "fieldType");
            Intrinsics.checkNotNullParameter(fieldExpr, "fieldExpr");
            this.fieldType = fieldType;
            this.parts = new ArrayList();
            this.parse(fieldExpr);
        }

        @NotNull
        public final CronFieldType getFieldType() {
            return this.fieldType;
        }

        @NotNull
        public final List<FieldPart> getParts() {
            return this.parts;
        }

        private final void parse(String fieldExpr) {
            List list;
            CharSequence charSequence = fieldExpr;
            Regex regex = new Regex(",");
            int n = 0;
            List<String> $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            for (String rangePart : thisCollection$iv.toArray(new String[0])) {
                Matcher m = CRON_FIELD_REGEXP.matcher(rangePart);
                if (!m.matches()) {
                    throw new IllegalArgumentException("Invalid cron field '" + rangePart + "' for field [" + this.fieldType + "]");
                }
                String startNummer = m.group("start");
                String modifier2 = m.group("mod");
                String sluttNummer = m.group("end");
                String incrementModifier = m.group("incmod");
                String increment = m.group("inc");
                FieldPart part = new FieldPart();
                part.setIncrement(999);
                if (startNummer != null) {
                    part.setFrom(this.mapValue(startNummer));
                    part.setModifier(modifier2);
                    if (sluttNummer != null) {
                        part.setTo(this.mapValue(sluttNummer));
                        part.setIncrement(1);
                    } else if (increment != null) {
                        part.setTo(this.fieldType.getTo());
                    } else {
                        part.setTo(part.getFrom());
                    }
                } else if (m.group("all") != null) {
                    part.setFrom(this.fieldType.getFrom());
                    part.setTo(this.fieldType.getTo());
                    part.setIncrement(1);
                } else if (m.group("ignore") != null) {
                    part.setModifier(m.group("ignore"));
                } else if (m.group("last") != null) {
                    part.setModifier(m.group("last"));
                } else {
                    throw new IllegalArgumentException("Invalid cron part: " + rangePart);
                }
                if (increment != null) {
                    part.setIncrementModifier(incrementModifier);
                    part.setIncrement(Integer.parseInt(increment));
                }
                this.validateRange(part);
                this.validatePart(part);
                this.parts.add(part);
            }
            CollectionsKt.sort(this.parts);
        }

        protected void validatePart(@NotNull FieldPart part) {
            Intrinsics.checkNotNullParameter(part, "part");
            if (part.getModifier() != null) {
                String string = "Invalid modifier [%s]";
                Object[] objectArray = new Object[]{part.getModifier()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                throw new IllegalArgumentException(string2);
            }
            if (part.getIncrementModifier() != null && !Intrinsics.areEqual("/", part.getIncrementModifier())) {
                String string = "Invalid increment modifier [%s]";
                Object[] objectArray = new Object[]{part.getIncrementModifier()};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                throw new IllegalArgumentException(string3);
            }
        }

        private final void validateRange(FieldPart part) {
            if (part.getFrom() != -1 && part.getFrom() < this.fieldType.getFrom() || part.getTo() != -1 && part.getTo() > this.fieldType.getTo()) {
                String string = "Invalid interval [%s-%s], must be %s<=_<=%s";
                Object[] objectArray = new Object[]{part.getFrom(), part.getTo(), this.fieldType.getFrom(), this.fieldType.getTo()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                throw new IllegalArgumentException(string2);
            }
            if (part.getFrom() != -1 && part.getTo() != -1 && part.getFrom() > part.getTo()) {
                String string = "Invalid interval [%s-%s].  Rolling periods are not supported (ex. 5-1, only 1-5) since this won't give a deterministic result. Must be %s<=_<=%s";
                Object[] objectArray = new Object[]{part.getFrom(), part.getTo(), this.fieldType.getFrom(), this.fieldType.getTo()};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                throw new IllegalArgumentException(string3);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        protected int mapValue(@NotNull String value) {
            int n;
            Intrinsics.checkNotNullParameter(value, "value");
            int idx = 0;
            if (this.fieldType.getNames() != null) {
                int n2;
                List<String> list = this.fieldType.getNames();
                String string = value;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string2 = string.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                int it = n2 = list.indexOf(string2);
                boolean bl = false;
                idx = it;
                if (n2 >= 0) {
                    n = idx + this.fieldType.getFrom();
                    return n;
                }
            }
            n = Integer.parseInt(value);
            return n;
        }

        protected boolean matches(int val, @NotNull FieldPart part) {
            Intrinsics.checkNotNullParameter(part, "part");
            return val >= part.getFrom() && val <= part.getTo() && (val - part.getFrom()) % part.getIncrement() == 0;
        }

        protected final int nextMatch(int val, @NotNull FieldPart part) {
            Intrinsics.checkNotNullParameter(part, "part");
            if (val > part.getTo()) {
                return -1;
            }
            int nextPotential = RangesKt.coerceAtLeast(val, part.getFrom());
            if (part.getIncrement() == 1 || nextPotential == part.getFrom()) {
                return nextPotential;
            }
            int remainder = (nextPotential - part.getFrom()) % part.getIncrement();
            if (remainder != 0) {
                nextPotential += part.getIncrement() - remainder;
            }
            return nextPotential <= part.getTo() ? nextPotential : -1;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/typewritermc/engine/paper/utils/CronExpression$BasicField$Companion;", "", "<init>", "()V", "CRON_FIELD_REGEXP", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "engine-paper"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/typewritermc/engine/paper/utils/CronExpression$Companion;", "", "<init>", "()V", "create", "Lcom/typewritermc/engine/paper/utils/CronExpression;", "expr", "", "createWithoutSeconds", "createDynamic", "default", "checkIfDateTimeBarrierIsReached", "", "nextTime", "Ljava/time/ZonedDateTime;", "dateTimeBarrier", "engine-paper"})
    @SourceDebugExtension(value={"SMAP\nCronExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CronExpression.kt\ncom/typewritermc/engine/paper/utils/CronExpression$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,583:1\n1104#2,3:584\n*S KotlinDebug\n*F\n+ 1 CronExpression.kt\ncom/typewritermc/engine/paper/utils/CronExpression$Companion\n*L\n572#1:584,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CronExpression create(@NotNull String expr) {
            Intrinsics.checkNotNullParameter(expr, "expr");
            return new CronExpression(expr, true);
        }

        @NotNull
        public final CronExpression createWithoutSeconds(@NotNull String expr) {
            Intrinsics.checkNotNullParameter(expr, "expr");
            return new CronExpression(expr, false);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CronExpression createDynamic(@NotNull String expr) {
            void $this$count$iv;
            Intrinsics.checkNotNullParameter(expr, "expr");
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)expr)).toString();
            String string = expr;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == ' ')) continue;
                ++count$iv;
            }
            int n = count$iv;
            boolean bl = n == 5;
            String string2 = string;
            return new CronExpression(string2, bl);
        }

        @NotNull
        public final CronExpression default() {
            return this.create("0 0 0 1 1 *");
        }

        private final void checkIfDateTimeBarrierIsReached(ZonedDateTime nextTime, ZonedDateTime dateTimeBarrier) {
            if (nextTime.isAfter(dateTimeBarrier)) {
                throw new IllegalArgumentException("No next execution time could be determined that is before the limit of " + dateTimeBarrier);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0003H&J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u001b"}, d2={"Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "", "from", "", "to", "names", "", "", "<init>", "(Ljava/lang/String;IIILjava/util/List;)V", "getFrom", "()I", "getTo", "getNames", "()Ljava/util/List;", "SECOND", "MINUTE", "HOUR", "DAY_OF_MONTH", "MONTH", "DAY_OF_WEEK", "getValue", "dateTime", "Ljava/time/ZonedDateTime;", "setValue", "value", "overflow", "engine-paper"})
    public static final abstract class CronFieldType
    extends Enum<CronFieldType> {
        private final int from;
        private final int to;
        @Nullable
        private final List<String> names;
        public static final /* enum */ CronFieldType SECOND = new SECOND("SECOND", 0);
        public static final /* enum */ CronFieldType MINUTE = new MINUTE("MINUTE", 1);
        public static final /* enum */ CronFieldType HOUR = new HOUR("HOUR", 2);
        public static final /* enum */ CronFieldType DAY_OF_MONTH = new DAY_OF_MONTH("DAY_OF_MONTH", 3);
        public static final /* enum */ CronFieldType MONTH = new MONTH("MONTH", 4);
        public static final /* enum */ CronFieldType DAY_OF_WEEK = new DAY_OF_WEEK("DAY_OF_WEEK", 5);
        private static final /* synthetic */ CronFieldType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CronFieldType(int from, int to, List<String> names2) {
            this.from = from;
            this.to = to;
            this.names = names2;
        }

        public final int getFrom() {
            return this.from;
        }

        public final int getTo() {
            return this.to;
        }

        @Nullable
        public final List<String> getNames() {
            return this.names;
        }

        public abstract int getValue(@NotNull ZonedDateTime var1);

        @NotNull
        public abstract ZonedDateTime setValue(@NotNull ZonedDateTime var1, int var2);

        @NotNull
        public abstract ZonedDateTime overflow(@NotNull ZonedDateTime var1);

        public static CronFieldType[] values() {
            return (CronFieldType[])$VALUES.clone();
        }

        public static CronFieldType valueOf(String value) {
            return Enum.valueOf(CronFieldType.class, value);
        }

        @NotNull
        public static EnumEntries<CronFieldType> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ CronFieldType(String $enum$name, int $enum$ordinal, int from, int to, List names2, DefaultConstructorMarker $constructor_marker) {
            this(from, to, names2);
        }

        static {
            $VALUES = cronFieldTypeArray = new CronFieldType[]{CronFieldType.SECOND, CronFieldType.MINUTE, CronFieldType.HOUR, CronFieldType.DAY_OF_MONTH, CronFieldType.MONTH, CronFieldType.DAY_OF_WEEK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"com/typewritermc/engine/paper/utils/CronExpression.CronFieldType.DAY_OF_MONTH", "Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "getValue", "", "dateTime", "Ljava/time/ZonedDateTime;", "setValue", "value", "overflow", "engine-paper"})
        static final class DAY_OF_MONTH
        extends CronFieldType {
            /*
             * WARNING - void declaration
             */
            DAY_OF_MONTH() {
                void var1_1;
            }

            @Override
            public int getValue(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                return dateTime.getDayOfMonth();
            }

            @Override
            @NotNull
            public ZonedDateTime setValue(@NotNull ZonedDateTime dateTime, int value) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.withDayOfMonth(value).withHour(0).withMinute(0).withSecond(0).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }

            @Override
            @NotNull
            public ZonedDateTime overflow(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.plusMonths(1L).withDayOfMonth(0).withHour(0).withMinute(0).withSecond(0).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"com/typewritermc/engine/paper/utils/CronExpression.CronFieldType.DAY_OF_WEEK", "Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "getValue", "", "dateTime", "Ljava/time/ZonedDateTime;", "setValue", "value", "overflow", "engine-paper"})
        static final class DAY_OF_WEEK
        extends CronFieldType {
            /*
             * WARNING - void declaration
             */
            DAY_OF_WEEK() {
                void var1_1;
                String[] stringArray = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"};
            }

            @Override
            public int getValue(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                return dateTime.getDayOfWeek().getValue();
            }

            @Override
            @NotNull
            public ZonedDateTime setValue(@NotNull ZonedDateTime dateTime, int value) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public ZonedDateTime overflow(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                throw new UnsupportedOperationException();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"com/typewritermc/engine/paper/utils/CronExpression.CronFieldType.HOUR", "Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "getValue", "", "dateTime", "Ljava/time/ZonedDateTime;", "setValue", "value", "overflow", "engine-paper"})
        static final class HOUR
        extends CronFieldType {
            /*
             * WARNING - void declaration
             */
            HOUR() {
                void var1_1;
            }

            @Override
            public int getValue(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                return dateTime.getHour();
            }

            @Override
            @NotNull
            public ZonedDateTime setValue(@NotNull ZonedDateTime dateTime, int value) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.withHour(value).withMinute(0).withSecond(0).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }

            @Override
            @NotNull
            public ZonedDateTime overflow(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"com/typewritermc/engine/paper/utils/CronExpression.CronFieldType.MINUTE", "Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "getValue", "", "dateTime", "Ljava/time/ZonedDateTime;", "setValue", "value", "overflow", "engine-paper"})
        static final class MINUTE
        extends CronFieldType {
            /*
             * WARNING - void declaration
             */
            MINUTE() {
                void var1_1;
            }

            @Override
            public int getValue(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                return dateTime.getMinute();
            }

            @Override
            @NotNull
            public ZonedDateTime setValue(@NotNull ZonedDateTime dateTime, int value) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.withMinute(value).withSecond(0).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }

            @Override
            @NotNull
            public ZonedDateTime overflow(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.plusHours(1L).withMinute(0).withSecond(0).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"com/typewritermc/engine/paper/utils/CronExpression.CronFieldType.MONTH", "Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "getValue", "", "dateTime", "Ljava/time/ZonedDateTime;", "setValue", "value", "overflow", "engine-paper"})
        static final class MONTH
        extends CronFieldType {
            /*
             * WARNING - void declaration
             */
            MONTH() {
                void var1_1;
                String[] stringArray = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
            }

            @Override
            public int getValue(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                return dateTime.getMonthValue();
            }

            @Override
            @NotNull
            public ZonedDateTime setValue(@NotNull ZonedDateTime dateTime, int value) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.withMonth(value).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }

            @Override
            @NotNull
            public ZonedDateTime overflow(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.plusYears(1L).withMonth(1).withHour(0).withDayOfMonth(1).withMinute(0).withSecond(0).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"com/typewritermc/engine/paper/utils/CronExpression.CronFieldType.SECOND", "Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "getValue", "", "dateTime", "Ljava/time/ZonedDateTime;", "setValue", "value", "overflow", "engine-paper"})
        static final class SECOND
        extends CronFieldType {
            /*
             * WARNING - void declaration
             */
            SECOND() {
                void var1_1;
            }

            @Override
            public int getValue(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                return dateTime.getSecond();
            }

            @Override
            @NotNull
            public ZonedDateTime setValue(@NotNull ZonedDateTime dateTime, int value) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.withSecond(value).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }

            @Override
            @NotNull
            public ZonedDateTime overflow(@NotNull ZonedDateTime dateTime) {
                Intrinsics.checkNotNullParameter(dateTime, "dateTime");
                ZonedDateTime zonedDateTime = dateTime.plusMinutes(1L).withSecond(0).withNano(0);
                Intrinsics.checkNotNullExpressionValue(zonedDateTime, "withNano(...)");
                return zonedDateTime;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/typewritermc/engine/paper/utils/CronExpression$DayOfMonthField;", "Lcom/typewritermc/engine/paper/utils/CronExpression$BasicField;", "fieldExpr", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "dato", "Ljava/time/LocalDate;", "validatePart", "", "part", "Lcom/typewritermc/engine/paper/utils/CronExpression$FieldPart;", "val", "", "engine-paper"})
    public static final class DayOfMonthField
    extends BasicField {
        public DayOfMonthField(@NotNull String fieldExpr) {
            Intrinsics.checkNotNullParameter(fieldExpr, "fieldExpr");
            super(CronFieldType.DAY_OF_MONTH, fieldExpr);
        }

        public final boolean matches(@NotNull LocalDate dato) {
            Intrinsics.checkNotNullParameter(dato, "dato");
            for (FieldPart part : this.getParts()) {
                if (Intrinsics.areEqual("L", part.getModifier())) {
                    YearMonth ym = YearMonth.of(dato.getYear(), dato.getMonth().getValue());
                    return dato.getDayOfMonth() == ym.lengthOfMonth() - (part.getFrom() == -1 ? 0 : part.getFrom());
                }
                if (Intrinsics.areEqual("W", part.getModifier())) {
                    if (dato.getDayOfWeek().getValue() > 5) continue;
                    if (dato.getDayOfMonth() == part.getFrom()) {
                        return true;
                    }
                    if (dato.getDayOfWeek().getValue() == 5) {
                        return dato.plusDays(1L).getDayOfMonth() == part.getFrom();
                    }
                    if (dato.getDayOfWeek().getValue() != 1) continue;
                    return dato.minusDays(1L).getDayOfMonth() == part.getFrom();
                }
                if (!this.matches(dato.getDayOfMonth(), part)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void validatePart(@NotNull FieldPart part) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter(part, "part");
            if (part.getModifier() != null && CollectionsKt.indexOf(CollectionsKt.listOf(stringArray = new String[]{"L", "W", "?"}), part.getModifier()) == -1) {
                String string = "Invalid modifier [%s]";
                Object[] objectArray = new Object[]{part.getModifier()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                throw new IllegalArgumentException(string2);
            }
            if (part.getIncrementModifier() != null && !Intrinsics.areEqual("/", part.getIncrementModifier())) {
                String string = "Invalid increment modifier [%s]";
                Object[] objectArray = new Object[]{part.getIncrementModifier()};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                throw new IllegalArgumentException(string3);
            }
        }

        @Override
        protected boolean matches(int val, @NotNull FieldPart part) {
            Intrinsics.checkNotNullParameter(part, "part");
            return Intrinsics.areEqual("?", part.getModifier()) || super.matches(val, part);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/typewritermc/engine/paper/utils/CronExpression$DayOfWeekField;", "Lcom/typewritermc/engine/paper/utils/CronExpression$BasicField;", "fieldExpr", "", "<init>", "(Ljava/lang/String;)V", "matches", "", "dato", "Ljava/time/LocalDate;", "mapValue", "", "value", "val", "part", "Lcom/typewritermc/engine/paper/utils/CronExpression$FieldPart;", "validatePart", "", "engine-paper"})
    public static final class DayOfWeekField
    extends BasicField {
        public DayOfWeekField(@NotNull String fieldExpr) {
            Intrinsics.checkNotNullParameter(fieldExpr, "fieldExpr");
            super(CronFieldType.DAY_OF_WEEK, fieldExpr);
        }

        public final boolean matches(@NotNull LocalDate dato) {
            Intrinsics.checkNotNullParameter(dato, "dato");
            for (FieldPart part : this.getParts()) {
                if (Intrinsics.areEqual("L", part.getModifier())) {
                    YearMonth ym = YearMonth.of(dato.getYear(), dato.getMonth().getValue());
                    return dato.getDayOfWeek() == DayOfWeek.of(part.getFrom()) && dato.getDayOfMonth() > ym.lengthOfMonth() - 7;
                }
                if (Intrinsics.areEqual("#", part.getIncrementModifier())) {
                    if (dato.getDayOfWeek() == DayOfWeek.of(part.getFrom())) {
                        int num = dato.getDayOfMonth() / 7;
                        return part.getIncrement() == (dato.getDayOfMonth() % 7 == 0 ? num : num + 1);
                    }
                    return false;
                }
                if (!this.matches(dato.getDayOfWeek().getValue(), part)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int mapValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return Intrinsics.areEqual("0", value) ? 7 : super.mapValue(value);
        }

        @Override
        protected boolean matches(int val, @NotNull FieldPart part) {
            Intrinsics.checkNotNullParameter(part, "part");
            return Intrinsics.areEqual("?", part.getModifier()) || super.matches(val, part);
        }

        @Override
        protected void validatePart(@NotNull FieldPart part) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter(part, "part");
            if (part.getModifier() != null) {
                stringArray = new String[]{"L", "?"};
                if (CollectionsKt.indexOf(CollectionsKt.listOf(stringArray), part.getModifier()) == -1) {
                    String string = "Invalid modifier [%s]";
                    Object[] objectArray = new Object[]{part.getModifier()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                    throw new IllegalArgumentException(string2);
                }
            }
            if (part.getIncrementModifier() != null) {
                stringArray = new String[]{"/", "#"};
                if (CollectionsKt.indexOf(CollectionsKt.listOf(stringArray), part.getIncrementModifier()) == -1) {
                    String string = "Invalid increment modifier [%s]";
                    Object[] objectArray = new Object[]{part.getIncrementModifier()};
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                    throw new IllegalArgumentException(string3);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\n\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/typewritermc/engine/paper/utils/CronExpression$FieldPart;", "", "<init>", "()V", "from", "", "getFrom", "()I", "setFrom", "(I)V", "to", "getTo", "setTo", "increment", "getIncrement", "setIncrement", "modifier", "", "getModifier", "()Ljava/lang/String;", "setModifier", "(Ljava/lang/String;)V", "incrementModifier", "getIncrementModifier", "setIncrementModifier", "compareTo", "other", "engine-paper"})
    public static final class FieldPart
    implements Comparable<FieldPart> {
        private int from = -1;
        private int to = -1;
        private int increment = -1;
        @Nullable
        private String modifier;
        @Nullable
        private String incrementModifier;

        public final int getFrom() {
            return this.from;
        }

        public final void setFrom(int n) {
            this.from = n;
        }

        public final int getTo() {
            return this.to;
        }

        public final void setTo(int n) {
            this.to = n;
        }

        public final int getIncrement() {
            return this.increment;
        }

        public final void setIncrement(int n) {
            this.increment = n;
        }

        @Nullable
        public final String getModifier() {
            return this.modifier;
        }

        public final void setModifier(@Nullable String string) {
            this.modifier = string;
        }

        @Nullable
        public final String getIncrementModifier() {
            return this.incrementModifier;
        }

        public final void setIncrementModifier(@Nullable String string) {
            this.incrementModifier = string;
        }

        @Override
        public int compareTo(@NotNull FieldPart other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return Intrinsics.compare(this.from, other.from);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0019\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/typewritermc/engine/paper/utils/CronExpression$SimpleField;", "Lcom/typewritermc/engine/paper/utils/CronExpression$BasicField;", "fieldType", "Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;", "fieldExpr", "", "<init>", "(Lcom/typewritermc/engine/paper/utils/CronExpression$CronFieldType;Ljava/lang/String;)V", "matches", "", "val", "", "nextMatch", "dateTime", "", "Ljava/time/ZonedDateTime;", "([Ljava/time/ZonedDateTime;)Z", "engine-paper"})
    public static final class SimpleField
    extends BasicField {
        public SimpleField(@NotNull CronFieldType fieldType, @NotNull String fieldExpr) {
            Intrinsics.checkNotNullParameter((Object)fieldType, "fieldType");
            Intrinsics.checkNotNullParameter(fieldExpr, "fieldExpr");
            super(fieldType, fieldExpr);
        }

        public final boolean matches(int val) {
            if (val >= this.getFieldType().getFrom() && val <= this.getFieldType().getTo()) {
                Iterator<FieldPart> iterator2 = this.getParts().iterator();
                while (iterator2.hasNext()) {
                    FieldPart part;
                    FieldPart fieldPart = part = iterator2.next();
                    Intrinsics.checkNotNull(fieldPart);
                    if (!this.matches(val, fieldPart)) continue;
                    return true;
                }
            }
            return false;
        }

        public final boolean nextMatch(@NotNull ZonedDateTime[] dateTime) {
            Intrinsics.checkNotNullParameter(dateTime, "dateTime");
            int value = this.getFieldType().getValue(dateTime[0]);
            Iterator<FieldPart> iterator2 = this.getParts().iterator();
            while (iterator2.hasNext()) {
                FieldPart part;
                FieldPart fieldPart = part = iterator2.next();
                Intrinsics.checkNotNull(fieldPart);
                int nextMatch = this.nextMatch(value, fieldPart);
                if (nextMatch <= -1) continue;
                if (nextMatch != value) {
                    dateTime[0] = this.getFieldType().setValue(dateTime[0], nextMatch);
                }
                return true;
            }
            dateTime[0] = this.getFieldType().overflow(dateTime[0]);
            return false;
        }
    }
}

