/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.ui;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.StagingManager;
import com.typewritermc.engine.paper.entry.StagingState;
import com.typewritermc.engine.paper.events.StagingChangeEvent;
import com.typewritermc.engine.paper.ui.ClientSynchronizer;
import com.typewritermc.engine.paper.ui.PanelHost;
import com.typewritermc.engine.paper.ui.SessionData;
import com.typewritermc.engine.paper.ui.Writers;
import com.typewritermc.engine.paper.ui.WritersKt;
import com.typewritermc.engine.paper.utils.ConfigPropertyDelegate;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.OptionalConfigPropertyDelegate;
import com.typewritermc.loader.ExtensionLoader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import lirand.api.extensions.events.ListenerExtensionsKt;
import lirand.api.extensions.events.SimpleListener;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010R\u001a\u00020SJ\u0006\u0010T\u001a\u00020SJ\u0010\u0010U\u001a\u0002022\u0006\u0010V\u001a\u00020WH\u0002J\u0012\u0010X\u001a\u0004\u0018\u00010K2\u0006\u0010V\u001a\u00020WH\u0002J\u0012\u0010Y\u001a\u00020K2\b\u0010Z\u001a\u0004\u0018\u00010KH\u0002J\u0010\u0010[\u001a\u00020'2\b\u0010Z\u001a\u0004\u0018\u00010KJ\u0010\u0010\\\u001a\u0004\u0018\u00010]2\u0006\u0010^\u001a\u00020_J\u0010\u0010`\u001a\u0004\u0018\u00010'2\u0006\u0010a\u001a\u00020'J\u0014\u0010`\u001a\u0004\u0018\u00010'2\b\u0010b\u001a\u0004\u0018\u00010KH\u0002J\u0006\u0010c\u001a\u00020SR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\t\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#*\u0004\b \u0010!R\u001b\u0010&\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b(\u0010)R\u001b\u0010,\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010+\u001a\u0004\b.\u0010/R\u001d\u00101\u001a\u0004\u0018\u0001028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b3\u00104R\u001b\u00107\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010+\u001a\u0004\b8\u00109R\u001b\u0010;\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010+\u001a\u0004\b<\u0010/R\u001b\u0010>\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010+\u001a\u0004\b?\u0010)R\u001d\u0010A\u001a\u0004\u0018\u00010'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u00106\u001a\u0004\bB\u0010)R\u001d\u0010D\u001a\u0004\u0018\u0001028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u00106\u001a\u0004\bE\u00104R\u0011\u0010G\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\bH\u00109R\u001a\u0010I\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020L0JX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010O\u001a\u0004\u0018\u00010N2\b\u0010M\u001a\u0004\u0018\u00010N@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010Q\u00a8\u0006d"}, d2={"Lcom/typewritermc/engine/paper/ui/CommunicationHandler;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "clientSynchronizer", "Lcom/typewritermc/engine/paper/ui/ClientSynchronizer;", "getClientSynchronizer", "()Lcom/typewritermc/engine/paper/ui/ClientSynchronizer;", "clientSynchronizer$delegate", "Lkotlin/Lazy;", "writers", "Lcom/typewritermc/engine/paper/ui/Writers;", "getWriters", "()Lcom/typewritermc/engine/paper/ui/Writers;", "writers$delegate", "stagingManager", "Lcom/typewritermc/engine/paper/entry/StagingManager;", "getStagingManager", "()Lcom/typewritermc/engine/paper/entry/StagingManager;", "stagingManager$delegate", "panelHost", "Lcom/typewritermc/engine/paper/ui/PanelHost;", "getPanelHost", "()Lcom/typewritermc/engine/paper/ui/PanelHost;", "panelHost$delegate", "extensionLoader", "Lcom/typewritermc/loader/ExtensionLoader;", "getExtensionLoader", "()Lcom/typewritermc/loader/ExtensionLoader;", "extensionLoader$delegate", "extensionJson", "Lcom/google/gson/JsonArray;", "getExtensionJson$delegate", "(Lcom/typewritermc/engine/paper/ui/CommunicationHandler;)Ljava/lang/Object;", "getExtensionJson", "()Lcom/google/gson/JsonArray;", "extensionJson$receiver", "Lcom/typewritermc/loader/ExtensionLoader;", "hostName", "", "getHostName", "()Ljava/lang/String;", "hostName$delegate", "Lcom/typewritermc/engine/paper/utils/ConfigPropertyDelegate;", "panelPort", "", "getPanelPort", "()I", "panelPort$delegate", "panelAppendPort", "", "getPanelAppendPort", "()Ljava/lang/Boolean;", "panelAppendPort$delegate", "Lcom/typewritermc/engine/paper/utils/OptionalConfigPropertyDelegate;", "enabled", "getEnabled", "()Z", "enabled$delegate", "webSocketPort", "getWebSocketPort", "webSocketPort$delegate", "auth", "getAuth", "auth$delegate", "websocketHostname", "getWebsocketHostname", "websocketHostname$delegate", "websocketAppendPort", "getWebsocketAppendPort", "websocketAppendPort$delegate", "authenticationEnabled", "getAuthenticationEnabled", "sessionTokens", "", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/ui/SessionData;", "value", "Lcom/corundumstudio/socketio/SocketIOServer;", "server", "getServer", "()Lcom/corundumstudio/socketio/SocketIOServer;", "initialize", "", "load", "authenticate", "data", "Lcom/corundumstudio/socketio/HandshakeData;", "getSessionToken", "generateSessionToken", "playerId", "generateUrl", "getPlayer", "Lorg/bukkit/entity/Player;", "client", "Lcom/corundumstudio/socketio/SocketIOClient;", "getIconUrl", "sessionId", "token", "shutdown", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nCommunicationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommunicationHandler.kt\ncom/typewritermc/engine/paper/ui/CommunicationHandler\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 Config.kt\ncom/typewritermc/engine/paper/utils/ConfigKt\n+ 4 ListenerExtensions.kt\nlirand/api/extensions/events/ListenerExtensionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n58#2,6:241\n58#2,6:247\n58#2,6:253\n58#2,6:259\n58#2,6:265\n11#3:271\n11#3:272\n41#3:273\n11#3:274\n11#3:275\n11#3:276\n41#3:277\n41#3:278\n58#4,7:279\n22#4:286\n65#4:287\n216#5,2:288\n535#6:290\n520#6,6:291\n1#7:297\n*S KotlinDebug\n*F\n+ 1 CommunicationHandler.kt\ncom/typewritermc/engine/paper/ui/CommunicationHandler\n*L\n27#1:241,6\n28#1:247,6\n29#1:253,6\n30#1:259,6\n31#1:265,6\n34#1:271\n39#1:272\n44#1:273\n46#1:274\n51#1:275\n56#1:276\n62#1:277\n63#1:278\n135#1:279,7\n135#1:286\n135#1:287\n145#1:288,2\n174#1:290\n174#1:291,6\n*E\n"})
public final class CommunicationHandler
implements KoinComponent {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Lazy clientSynchronizer$delegate;
    @NotNull
    private final Lazy writers$delegate;
    @NotNull
    private final Lazy stagingManager$delegate;
    @NotNull
    private final Lazy panelHost$delegate;
    @NotNull
    private final Lazy extensionLoader$delegate;
    @NotNull
    private final ExtensionLoader extensionJson$receiver;
    @NotNull
    private final ConfigPropertyDelegate hostName$delegate;
    @NotNull
    private final ConfigPropertyDelegate panelPort$delegate;
    @NotNull
    private final OptionalConfigPropertyDelegate panelAppendPort$delegate;
    @NotNull
    private final ConfigPropertyDelegate enabled$delegate;
    @NotNull
    private final ConfigPropertyDelegate webSocketPort$delegate;
    @NotNull
    private final ConfigPropertyDelegate auth$delegate;
    @NotNull
    private final OptionalConfigPropertyDelegate websocketHostname$delegate;
    @NotNull
    private final OptionalConfigPropertyDelegate websocketAppendPort$delegate;
    @NotNull
    private final Map<UUID, SessionData> sessionTokens;
    @Nullable
    private SocketIOServer server;

    public CommunicationHandler() {
        Integer default$iv;
        String key$iv;
        Object $this$inject_u24default$iv = this;
        String qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.clientSynchronizer$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<ClientSynchronizer>((KoinComponent)$this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ClientSynchronizer invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ClientSynchronizer.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ClientSynchronizer.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.writers$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<Writers>((KoinComponent)$this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Writers invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(Writers.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(Writers.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.stagingManager$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<StagingManager>((KoinComponent)$this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final StagingManager invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(StagingManager.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(StagingManager.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.panelHost$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<PanelHost>((KoinComponent)$this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PanelHost invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(PanelHost.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(PanelHost.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.extensionLoader$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<ExtensionLoader>((KoinComponent)$this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ExtensionLoader invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ExtensionLoader.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ExtensionLoader.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        this.extensionJson$receiver = this.getExtensionLoader();
        $this$inject_u24default$iv = "hostname";
        qualifier$iv = "127.0.0.1";
        String comment$iv = "The hostname of the server. CHANGE THIS to your servers ip.";
        boolean $i$f$config = false;
        this.hostName$delegate = new ConfigPropertyDelegate<void>(key$iv, Reflection.getOrCreateKotlinClass(String.class), (void)default$iv, comment$iv);
        key$iv = "panel.port";
        default$iv = 8080;
        comment$iv = "The port of the web panel. Make sure this port is open.";
        $i$f$config = false;
        this.panelPort$delegate = new ConfigPropertyDelegate<Integer>(key$iv, Reflection.getOrCreateKotlinClass(Integer.class), default$iv, comment$iv);
        key$iv = "panel.append_port";
        boolean $i$f$optionalConfig22 = false;
        this.panelAppendPort$delegate = new OptionalConfigPropertyDelegate(key$iv, Reflection.getOrCreateKotlinClass(Boolean.class));
        key$iv = "enabled";
        Boolean $i$f$optionalConfig22 = false;
        comment$iv = "Whether the web panel and web sockets are enabled.";
        $i$f$config = false;
        this.enabled$delegate = new ConfigPropertyDelegate<void>(key$iv, Reflection.getOrCreateKotlinClass(Boolean.class), (void)default$iv2, comment$iv);
        key$iv = "websocket.port";
        Object default$iv2 = 9092;
        comment$iv = "The port of the websocket server. Make sure this port is open.";
        $i$f$config = false;
        this.webSocketPort$delegate = new ConfigPropertyDelegate<Integer>(key$iv, Reflection.getOrCreateKotlinClass(Integer.class), (Integer)default$iv2, comment$iv);
        key$iv = "websocket.auth";
        default$iv2 = "session";
        comment$iv = "The authentication that is used. Leave unchanged if you don't know what you are doing.\nPossible values: none (not recommended), session";
        $i$f$config = false;
        this.auth$delegate = new ConfigPropertyDelegate<Object>(key$iv, Reflection.getOrCreateKotlinClass(String.class), default$iv2, comment$iv);
        key$iv = "websocket.hostname";
        boolean $i$f$optionalConfig = false;
        this.websocketHostname$delegate = new OptionalConfigPropertyDelegate(key$iv, Reflection.getOrCreateKotlinClass(String.class));
        key$iv = "websocket.append_port";
        $i$f$optionalConfig = false;
        this.websocketAppendPort$delegate = new OptionalConfigPropertyDelegate(key$iv, Reflection.getOrCreateKotlinClass(Boolean.class));
        this.sessionTokens = new LinkedHashMap();
    }

    private final ClientSynchronizer getClientSynchronizer() {
        Lazy lazy = this.clientSynchronizer$delegate;
        return (ClientSynchronizer)lazy.getValue();
    }

    private final Writers getWriters() {
        Lazy lazy = this.writers$delegate;
        return (Writers)lazy.getValue();
    }

    private final StagingManager getStagingManager() {
        Lazy lazy = this.stagingManager$delegate;
        return (StagingManager)lazy.getValue();
    }

    private final PanelHost getPanelHost() {
        Lazy lazy = this.panelHost$delegate;
        return (PanelHost)lazy.getValue();
    }

    private final ExtensionLoader getExtensionLoader() {
        Lazy lazy = this.extensionLoader$delegate;
        return (ExtensionLoader)lazy.getValue();
    }

    private final JsonArray getExtensionJson() {
        return this.extensionJson$receiver.getExtensionJson();
    }

    private static Object getExtensionJson$delegate(CommunicationHandler communicationHandler) {
        return Reflection.mutableProperty0(new MutablePropertyReference0Impl((Object)communicationHandler.extensionJson$receiver, ExtensionLoader.class, "extensionJson", "getExtensionJson()Lcom/google/gson/JsonArray;", 0));
    }

    private final String getHostName() {
        return (String)this.hostName$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final int getPanelPort() {
        return ((Number)this.panelPort$delegate.getValue(this, $$delegatedProperties[1])).intValue();
    }

    private final Boolean getPanelAppendPort() {
        return (Boolean)this.panelAppendPort$delegate.getValue(this, $$delegatedProperties[2]);
    }

    private final boolean getEnabled() {
        return (Boolean)this.enabled$delegate.getValue(this, $$delegatedProperties[3]);
    }

    private final int getWebSocketPort() {
        return ((Number)this.webSocketPort$delegate.getValue(this, $$delegatedProperties[4])).intValue();
    }

    private final String getAuth() {
        return (String)this.auth$delegate.getValue(this, $$delegatedProperties[5]);
    }

    private final String getWebsocketHostname() {
        return (String)this.websocketHostname$delegate.getValue(this, $$delegatedProperties[6]);
    }

    private final Boolean getWebsocketAppendPort() {
        return (Boolean)this.websocketAppendPort$delegate.getValue(this, $$delegatedProperties[7]);
    }

    public final boolean getAuthenticationEnabled() {
        return Intrinsics.areEqual(this.getAuth(), "session");
    }

    @Nullable
    public final SocketIOServer getServer() {
        return this.server;
    }

    /*
     * WARNING - void declaration
     */
    public final void initialize() {
        void $this$listen_u24default$iv;
        Listener listener2;
        Configuration configuration;
        if (!this.getEnabled()) {
            return;
        }
        TypewriterPaperPluginKt.getLogger().warning("Websocket server is enabled. This is not recommended for production servers.");
        this.getPanelHost().initialize();
        Configuration $this$initialize_u24lambda_u240 = configuration = new Configuration();
        boolean bl = false;
        $this$initialize_u24lambda_u240.setHostname("0.0.0.0");
        $this$initialize_u24lambda_u240.setPort(this.getWebSocketPort());
        $this$initialize_u24lambda_u240.setAuthorizationListener(this::authenticate);
        Configuration config = configuration;
        SocketIOServer socketIOServer = this.server = new SocketIOServer(config);
        if (socketIOServer != null) {
            socketIOServer.addEventListener("fetch", String.class, this.getClientSynchronizer()::handleFetchRequest);
        }
        SocketIOServer socketIOServer2 = this.server;
        if (socketIOServer2 != null) {
            socketIOServer2.addEventListener("createPage", String.class, this.getClientSynchronizer()::handleCreatePage);
        }
        SocketIOServer socketIOServer3 = this.server;
        if (socketIOServer3 != null) {
            socketIOServer3.addEventListener("renamePage", String.class, this.getClientSynchronizer()::handleRenamePage);
        }
        SocketIOServer socketIOServer4 = this.server;
        if (socketIOServer4 != null) {
            socketIOServer4.addEventListener("changePageValue", String.class, this.getClientSynchronizer()::handleChangePageValue);
        }
        SocketIOServer socketIOServer5 = this.server;
        if (socketIOServer5 != null) {
            socketIOServer5.addEventListener("deletePage", String.class, this.getClientSynchronizer()::handleDeletePage);
        }
        SocketIOServer socketIOServer6 = this.server;
        if (socketIOServer6 != null) {
            socketIOServer6.addEventListener("moveEntry", String.class, this.getClientSynchronizer()::handleMoveEntry);
        }
        SocketIOServer socketIOServer7 = this.server;
        if (socketIOServer7 != null) {
            socketIOServer7.addEventListener("createEntry", String.class, this.getClientSynchronizer()::handleCreateEntry);
        }
        SocketIOServer socketIOServer8 = this.server;
        if (socketIOServer8 != null) {
            socketIOServer8.addEventListener("updateEntry", String.class, this.getClientSynchronizer()::handleEntryFieldUpdate);
        }
        SocketIOServer socketIOServer9 = this.server;
        if (socketIOServer9 != null) {
            socketIOServer9.addEventListener("updateCompleteEntry", String.class, this.getClientSynchronizer()::handleEntryUpdate);
        }
        SocketIOServer socketIOServer10 = this.server;
        if (socketIOServer10 != null) {
            socketIOServer10.addEventListener("reorderEntry", String.class, this.getClientSynchronizer()::handleReorderEntry);
        }
        SocketIOServer socketIOServer11 = this.server;
        if (socketIOServer11 != null) {
            socketIOServer11.addEventListener("deleteEntry", String.class, this.getClientSynchronizer()::handleDeleteEntry);
        }
        SocketIOServer socketIOServer12 = this.server;
        if (socketIOServer12 != null) {
            socketIOServer12.addEventListener("publish", String.class, this.getClientSynchronizer()::handlePublish);
        }
        SocketIOServer socketIOServer13 = this.server;
        if (socketIOServer13 != null) {
            socketIOServer13.addEventListener("updateWriter", String.class, this.getClientSynchronizer()::handleUpdateWriter);
        }
        SocketIOServer socketIOServer14 = this.server;
        if (socketIOServer14 != null) {
            socketIOServer14.addEventListener("contentModeRequest", String.class, this.getClientSynchronizer()::handleContentModeRequest);
        }
        SocketIOServer socketIOServer15 = this.server;
        if (socketIOServer15 != null) {
            socketIOServer15.addConnectListener(arg_0 -> CommunicationHandler.initialize$lambda$3(this, arg_0));
        }
        SocketIOServer socketIOServer16 = this.server;
        if (socketIOServer16 != null) {
            socketIOServer16.addDisconnectListener(arg_0 -> CommunicationHandler.initialize$lambda$4(this, arg_0));
        }
        SocketIOServer socketIOServer17 = this.server;
        if (socketIOServer17 != null) {
            socketIOServer17.start();
        }
        configuration = TypewriterPaperPluginKt.getPlugin();
        Function1<StagingChangeEvent, Unit> block$iv = arg_0 -> CommunicationHandler.initialize$lambda$5(this, arg_0);
        Listener listener$iv = new SimpleListener();
        EventPriority priority$iv = EventPriority.NORMAL;
        boolean ignoreCancelled$iv = false;
        boolean $i$f$listen = false;
        Listener $this$listen_u24lambda_u242$iv = listener2 = listener$iv;
        boolean bl2 = false;
        Listener $this$listen$iv$iv = $this$listen_u24lambda_u242$iv;
        boolean $i$f$listen2 = false;
        ListenerExtensionsKt.listen($this$listen$iv$iv, (Plugin)$this$listen_u24default$iv, Reflection.getOrCreateKotlinClass(StagingChangeEvent.class), priority$iv, ignoreCancelled$iv, block$iv);
    }

    public final void load() {
        block4: {
            SocketIOServer socketIOServer;
            if (!this.getEnabled()) {
                return;
            }
            SocketIOServer socketIOServer2 = this.server;
            if (socketIOServer2 != null && (socketIOServer2 = socketIOServer2.getBroadcastOperations()) != null) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue(this.getStagingManager().getStagingState().name().toLowerCase(Locale.ROOT), "toLowerCase(...)");
                socketIOServer2.sendEvent("stagingState", objectArray);
            }
            JsonArray array = new JsonArray();
            Map<String, JsonObject> $this$forEach$iv = this.getStagingManager().getPages();
            boolean $i$f$forEach = false;
            Object[] objectArray = $this$forEach$iv.entrySet().iterator();
            while (objectArray.hasNext()) {
                Map.Entry<String, JsonObject> element$iv;
                Map.Entry<String, JsonObject> entry = element$iv = objectArray.next();
                boolean bl = false;
                JsonObject page = entry.getValue();
                array.add((JsonElement)page);
            }
            SocketIOServer socketIOServer3 = this.server;
            if (socketIOServer3 != null && (socketIOServer3 = socketIOServer3.getBroadcastOperations()) != null) {
                objectArray = new Object[]{array.toString()};
                socketIOServer3.sendEvent("updatePages", objectArray);
            }
            if ((socketIOServer = this.server) == null || (socketIOServer = socketIOServer.getBroadcastOperations()) == null) break block4;
            objectArray = new Object[]{this.getExtensionJson().toString()};
            socketIOServer.sendEvent("updateExtensions", objectArray);
        }
    }

    private final boolean authenticate(HandshakeData data2) {
        if (Intrinsics.areEqual(this.getAuth(), "none")) {
            return true;
        }
        if (Intrinsics.areEqual(this.getAuth(), "session")) {
            UUID uUID = ExtensionsKt.logErrorIfNull(this.getSessionToken(data2), data2.getAddress() + " tried to connect to the socket without token!");
            if (uUID == null) {
                return false;
            }
            UUID token2 = uUID;
            SessionData sessionData = this.sessionTokens.get(token2);
            if (sessionData == null) {
                return false;
            }
            SessionData session = sessionData;
            return session.isValid();
        }
        return false;
    }

    private final UUID getSessionToken(HandshakeData data2) {
        if (Intrinsics.areEqual(this.getAuth(), "none")) {
            return null;
        }
        if (Intrinsics.areEqual(this.getAuth(), "session")) {
            String string = data2.getSingleUrlParam("token");
            if (string == null) {
                return null;
            }
            String token2 = string;
            return UUID.fromString(token2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final UUID generateSessionToken(UUID playerId) {
        UUID existingToken;
        void $this$filterTo$iv$iv;
        Map<UUID, SessionData> $this$filter$iv = this.sessionTokens;
        boolean $i$f$filter = false;
        Map<UUID, SessionData> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(((SessionData)it.getValue()).getPlayerId(), playerId)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        UUID uUID = existingToken = (UUID)CollectionsKt.firstOrNull(destination$iv$iv.keySet());
        if (uUID != null) {
            return uUID;
        }
        UUID token2 = UUID.randomUUID();
        this.sessionTokens.put(token2, SessionData.Companion.create(playerId));
        Intrinsics.checkNotNull(token2);
        return token2;
    }

    @NotNull
    public final String generateUrl(@Nullable UUID playerId) {
        String string;
        Object url2;
        Object object = url2 = StringsKt.startsWith$default(this.getHostName(), "http", false, 2, null) ? this.getHostName() : "http://" + this.getHostName();
        if (!Intrinsics.areEqual(this.getPanelAppendPort(), false)) {
            url2 = (String)url2 + ":" + this.getPanelPort();
        }
        if ((string = this.getWebsocketHostname()) == null) {
            string = this.getHostName();
        }
        url2 = (String)url2 + "/#/connect?host=" + string;
        if (!Intrinsics.areEqual(this.getWebsocketAppendPort(), false)) {
            url2 = (String)url2 + "&port=" + this.getWebSocketPort();
        }
        if (Intrinsics.areEqual(this.getAuth(), "session")) {
            url2 = (String)url2 + "&token=" + this.generateSessionToken(playerId);
        }
        return url2;
    }

    @Nullable
    public final Player getPlayer(@NotNull SocketIOClient client) {
        Player player;
        Intrinsics.checkNotNullParameter(client, "client");
        HandshakeData handshakeData = client.getHandshakeData();
        Intrinsics.checkNotNullExpressionValue(handshakeData, "getHandshakeData(...)");
        UUID uUID = this.getSessionToken(handshakeData);
        if (uUID == null) {
            return null;
        }
        UUID token2 = uUID;
        SessionData sessionData = this.sessionTokens.get(token2);
        if (sessionData == null) {
            return null;
        }
        SessionData session = sessionData;
        UUID uUID2 = session.getPlayerId();
        if (uUID2 != null) {
            UUID it = uUID2;
            boolean bl = false;
            player = TypewriterPaperPluginKt.getPlugin().getServer().getPlayer(it);
        } else {
            player = null;
        }
        return player;
    }

    @Nullable
    public final String getIconUrl(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter(sessionId, "sessionId");
        SocketIOServer socketIOServer = this.server;
        if (socketIOServer == null || (socketIOServer = socketIOServer.getClient(UUID.fromString(sessionId))) == null) {
            return null;
        }
        SocketIOServer client = socketIOServer;
        HandshakeData handshakeData = client.getHandshakeData();
        Intrinsics.checkNotNullExpressionValue(handshakeData, "getHandshakeData(...)");
        UUID uUID = this.getSessionToken(handshakeData);
        if (uUID == null) {
            return null;
        }
        UUID token2 = uUID;
        return this.getIconUrl(token2);
    }

    private final String getIconUrl(UUID token2) {
        String string;
        SessionData sessionData = this.sessionTokens.get(token2);
        if (sessionData == null) {
            return null;
        }
        SessionData session = sessionData;
        UUID uUID = session.getPlayerId();
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            string = "https://crafatar.com/avatars/" + it + "?size=64&overlay";
        } else {
            string = null;
        }
        return string;
    }

    public final void shutdown() {
        if (!this.getEnabled()) {
            return;
        }
        SocketIOServer socketIOServer = this.server;
        if (socketIOServer != null) {
            socketIOServer.stop();
        }
        this.getPanelHost().dispose();
        this.getWriters().dispose();
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    private static final SessionData initialize$lambda$3$lambda$1(SocketIOClient $socket, UUID uUID, SessionData session) {
        Intrinsics.checkNotNullParameter(uUID, "<unused var>");
        Intrinsics.checkNotNullParameter(session, "session");
        return SessionData.copy$default(session, null, null, $socket.getSessionId(), 3, null);
    }

    private static final SessionData initialize$lambda$3$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (SessionData)$tmp0.invoke(p0, p1);
    }

    private static final void initialize$lambda$3(CommunicationHandler this$0, SocketIOClient socket) {
        TypewriterPaperPluginKt.getLogger().info("Client connected: " + socket.getRemoteAddress());
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue(this$0.getStagingManager().getStagingState().name().toLowerCase(Locale.ROOT), "toLowerCase(...)");
        socket.sendEvent("stagingState", objectArray);
        HandshakeData handshakeData = socket.getHandshakeData();
        Intrinsics.checkNotNullExpressionValue(handshakeData, "getHandshakeData(...)");
        UUID token2 = this$0.getSessionToken(handshakeData);
        if (token2 != null) {
            this$0.sessionTokens.computeIfPresent(token2, (arg_0, arg_1) -> CommunicationHandler.initialize$lambda$3$lambda$2((arg_0, arg_1) -> CommunicationHandler.initialize$lambda$3$lambda$1(socket, arg_0, arg_1), arg_0, arg_1));
        }
        String iconUrl = this$0.getIconUrl(token2);
        Writers writers = this$0.getWriters();
        String string = socket.getSessionId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        writers.addWriter(string, iconUrl);
        WritersKt.broadcastWriters(this$0.server, this$0.getWriters());
    }

    private static final void initialize$lambda$4(CommunicationHandler this$0, SocketIOClient it) {
        TypewriterPaperPluginKt.getLogger().info("Client disconnected: " + it.getRemoteAddress());
        SocketIOServer socketIOServer = this$0.server;
        if (socketIOServer != null && (socketIOServer = socketIOServer.getBroadcastOperations()) != null) {
            Object[] objectArray = new Object[]{it.getSessionId().toString()};
            socketIOServer.sendEvent("disconnectWriter", it, objectArray);
        }
        Writers writers = this$0.getWriters();
        String string = it.getSessionId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        writers.removeWriter(string);
        WritersKt.broadcastWriters(this$0.server, this$0.getWriters());
    }

    private static final Unit initialize$lambda$5(CommunicationHandler this$0, StagingChangeEvent stagingChangeEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)stagingChangeEvent, "<destruct>");
            StagingState newState = stagingChangeEvent.component1();
            SocketIOServer socketIOServer = this$0.server;
            if (socketIOServer == null || (socketIOServer = socketIOServer.getBroadcastOperations()) == null) break block0;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(newState.name().toLowerCase(Locale.ROOT), "toLowerCase(...)");
            socketIOServer.sendEvent("stagingState", objectArray);
        }
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CommunicationHandler.class, "hostName", "getHostName()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(CommunicationHandler.class, "panelPort", "getPanelPort()I", 0)), Reflection.property1(new PropertyReference1Impl(CommunicationHandler.class, "panelAppendPort", "getPanelAppendPort()Ljava/lang/Boolean;", 0)), Reflection.property1(new PropertyReference1Impl(CommunicationHandler.class, "enabled", "getEnabled()Z", 0)), Reflection.property1(new PropertyReference1Impl(CommunicationHandler.class, "webSocketPort", "getWebSocketPort()I", 0)), Reflection.property1(new PropertyReference1Impl(CommunicationHandler.class, "auth", "getAuth()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(CommunicationHandler.class, "websocketHostname", "getWebsocketHostname()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(CommunicationHandler.class, "websocketAppendPort", "getWebsocketAppendPort()Ljava/lang/Boolean;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

