/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.interaction;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.ProtocolPacketEvent;
import com.typewritermc.engine.paper.interaction.InterceptionBundle;
import com.typewritermc.engine.paper.interaction.PacketInterception;
import com.typewritermc.engine.paper.interaction.PacketInterceptionSubscription;
import com.typewritermc.engine.paper.interaction.PlayerPacketInterceptor;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\r\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0010J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/typewritermc/engine/paper/interaction/PacketInterceptor;", "Lcom/github/retrooper/packetevents/event/PacketListenerAbstract;", "<init>", "()V", "blockers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/interaction/PlayerPacketInterceptor;", "initialize", "", "onPacketReceive", "event", "Lcom/github/retrooper/packetevents/event/PacketReceiveEvent;", "onPacketSend", "Lcom/github/retrooper/packetevents/event/PacketSendEvent;", "interceptPacket", "Lcom/typewritermc/engine/paper/interaction/PacketInterceptionSubscription;", "player", "interception", "Lcom/typewritermc/engine/paper/interaction/PacketInterception;", "cancel", "subscription", "bundle", "Lcom/typewritermc/engine/paper/interaction/InterceptionBundle;", "shutdown", "engine-paper"})
public final class PacketInterceptor
extends PacketListenerAbstract {
    @NotNull
    private final ConcurrentHashMap<UUID, PlayerPacketInterceptor> blockers = new ConcurrentHashMap();

    public final void initialize() {
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this);
    }

    public void onPacketReceive(@Nullable PacketReceiveEvent event) {
        if (event == null) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (player == null) {
            return;
        }
        PlayerPacketInterceptor playerPacketInterceptor = this.blockers.get(player.getUniqueId());
        if (playerPacketInterceptor == null) {
            return;
        }
        PlayerPacketInterceptor interceptor = playerPacketInterceptor;
        interceptor.trigger((ProtocolPacketEvent)event);
    }

    public void onPacketSend(@Nullable PacketSendEvent event) {
        if (event == null) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (player == null) {
            return;
        }
        PlayerPacketInterceptor playerPacketInterceptor = this.blockers.get(player.getUniqueId());
        if (playerPacketInterceptor == null) {
            return;
        }
        PlayerPacketInterceptor interceptor = playerPacketInterceptor;
        interceptor.trigger((ProtocolPacketEvent)event);
    }

    @NotNull
    public final PacketInterceptionSubscription interceptPacket(@NotNull UUID player, @NotNull PacketInterception interception) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(interception, "interception");
        PacketInterceptionSubscription subscription = new PacketInterceptionSubscription(null, 1, null);
        this.blockers.compute(player, (arg_0, arg_1) -> PacketInterceptor.interceptPacket$lambda$1((arg_0, arg_1) -> PacketInterceptor.interceptPacket$lambda$0(subscription, interception, arg_0, arg_1), arg_0, arg_1));
        return subscription;
    }

    public final void cancel(@NotNull UUID player, @NotNull PacketInterceptionSubscription subscription) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(subscription, "subscription");
        this.blockers.compute(player, (arg_0, arg_1) -> PacketInterceptor.cancel$lambda$3((arg_0, arg_1) -> PacketInterceptor.cancel$lambda$2(subscription, arg_0, arg_1), arg_0, arg_1));
    }

    public final void cancel(@NotNull UUID player, @NotNull InterceptionBundle bundle) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        this.blockers.compute(player, (arg_0, arg_1) -> PacketInterceptor.cancel$lambda$5((arg_0, arg_1) -> PacketInterceptor.cancel$lambda$4(bundle, arg_0, arg_1), arg_0, arg_1));
    }

    public final void shutdown() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this);
        this.blockers.clear();
    }

    private static final PlayerPacketInterceptor interceptPacket$lambda$0(PacketInterceptionSubscription $subscription, PacketInterception $interception, UUID uUID, PlayerPacketInterceptor interceptor) {
        Intrinsics.checkNotNullParameter(uUID, "<unused var>");
        PlayerPacketInterceptor playerPacketInterceptor = interceptor;
        if (playerPacketInterceptor == null) {
            playerPacketInterceptor = new PlayerPacketInterceptor(null, 1, null);
        }
        PlayerPacketInterceptor newInterceptor = playerPacketInterceptor;
        newInterceptor.intercept($subscription, $interception);
        return newInterceptor;
    }

    private static final PlayerPacketInterceptor interceptPacket$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (PlayerPacketInterceptor)$tmp0.invoke(p0, p1);
    }

    private static final PlayerPacketInterceptor cancel$lambda$2(PacketInterceptionSubscription $subscription, UUID uUID, PlayerPacketInterceptor blocker) {
        Intrinsics.checkNotNullParameter(uUID, "<unused var>");
        PlayerPacketInterceptor playerPacketInterceptor = blocker;
        if (playerPacketInterceptor == null) {
            return null;
        }
        PlayerPacketInterceptor newBlocker = playerPacketInterceptor;
        return newBlocker.cancel($subscription) ? null : newBlocker;
    }

    private static final PlayerPacketInterceptor cancel$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return (PlayerPacketInterceptor)$tmp0.invoke(p0, p1);
    }

    private static final PlayerPacketInterceptor cancel$lambda$4(InterceptionBundle $bundle, UUID uUID, PlayerPacketInterceptor blocker) {
        Intrinsics.checkNotNullParameter(uUID, "<unused var>");
        PlayerPacketInterceptor playerPacketInterceptor = blocker;
        if (playerPacketInterceptor == null) {
            return null;
        }
        PlayerPacketInterceptor newBlocker = playerPacketInterceptor;
        return newBlocker.cancel($bundle) ? null : newBlocker;
    }

    private static final PlayerPacketInterceptor cancel$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        return (PlayerPacketInterceptor)$tmp0.invoke(p0, p1);
    }
}

