/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.interaction;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19_3;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import com.github.shynixn.mccoroutine.bukkit.MCCoroutineKt;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.interaction.ChatHistory;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import lirand.api.extensions.server.ServerExtensionsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0017H\u0007J\u0006\u0010\u0018\u001a\u00020\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/typewritermc/engine/paper/interaction/ChatHistoryHandler;", "Lcom/github/retrooper/packetevents/event/PacketListenerAbstract;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "initialize", "", "histories", "", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/interaction/ChatHistory;", "onPacketSend", "event", "Lcom/github/retrooper/packetevents/event/PacketSendEvent;", "findMessage", "Lnet/kyori/adventure/text/Component;", "getHistory", "pid", "player", "Lorg/bukkit/entity/Player;", "blockMessages", "unblockMessages", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "shutdown", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nChatHistoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatHistoryHandler.kt\ncom/typewritermc/engine/paper/interaction/ChatHistoryHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,218:1\n381#2,7:219\n*S KotlinDebug\n*F\n+ 1 ChatHistoryHandler.kt\ncom/typewritermc/engine/paper/interaction/ChatHistoryHandler\n*L\n95#1:219,7\n*E\n"})
public final class ChatHistoryHandler
extends PacketListenerAbstract
implements Listener {
    @NotNull
    private final Map<UUID, ChatHistory> histories = new LinkedHashMap();

    public ChatHistoryHandler() {
        super(PacketListenerPriority.HIGH);
    }

    public final void initialize() {
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this);
        PluginManager pluginManager = ServerExtensionsKt.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        MCCoroutineKt.registerSuspendingEvents(pluginManager, this, TypewriterPaperPluginKt.getPlugin());
    }

    public void onPacketSend(@Nullable PacketSendEvent event) {
        try {
            if (event == null) {
                return;
            }
            Component component = this.findMessage(event);
            if (component == null) {
                return;
            }
            Component component2 = component;
            UUID uUID = event.getUser().getUUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUUID(...)");
            ChatHistory history = this.getHistory(uUID);
            if (component2 instanceof TextComponent) {
                String string = ((TextComponent)component2).content();
                Intrinsics.checkNotNullExpressionValue(string, "content(...)");
                if (StringsKt.startsWith$default(string, "no-index", false, 2, null)) {
                    String string2 = ((TextComponent)component2).content();
                    Intrinsics.checkNotNullExpressionValue(string2, "content(...)");
                    if (StringsKt.endsWith$default(string2, "resend", false, 2, null)) {
                        return;
                    }
                    history.allowedMessageThrough();
                    return;
                }
            }
            history.addMessage(component2);
            if (history.isBlocking()) {
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final Component findMessage(PacketSendEvent event) {
        Component component;
        PacketTypeCommon packetTypeCommon = event.getPacketType();
        if (packetTypeCommon == PacketType.Play.Server.CHAT_MESSAGE) {
            WrapperPlayServerChatMessage packet = new WrapperPlayServerChatMessage(event);
            ChatMessage chatMessage = packet.getMessage();
            ChatMessage_v1_19_3 chatMessage_v1_19_3 = chatMessage instanceof ChatMessage_v1_19_3 ? (ChatMessage_v1_19_3)chatMessage : null;
            if (chatMessage_v1_19_3 == null) {
                return packet.getMessage().getChatContent();
            }
            ChatMessage_v1_19_3 message = chatMessage_v1_19_3;
            component = message.getUnsignedChatContent().orElseGet(() -> ChatHistoryHandler.findMessage$lambda$0(message));
        } else if (packetTypeCommon == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
            WrapperPlayServerSystemChatMessage packet = new WrapperPlayServerSystemChatMessage(event);
            if (packet.isOverlay()) {
                return null;
            }
            component = packet.getMessage();
        } else {
            component = null;
        }
        return component;
    }

    @NotNull
    public final ChatHistory getHistory(@NotNull UUID pid) {
        ChatHistory chatHistory;
        Intrinsics.checkNotNullParameter(pid, "pid");
        Map<UUID, ChatHistory> $this$getOrPut$iv = this.histories;
        boolean $i$f$getOrPut = false;
        ChatHistory value$iv = $this$getOrPut$iv.get(pid);
        if (value$iv == null) {
            boolean bl = false;
            ChatHistory answer$iv = new ChatHistory();
            $this$getOrPut$iv.put(pid, answer$iv);
            chatHistory = answer$iv;
        } else {
            chatHistory = value$iv;
        }
        return chatHistory;
    }

    @NotNull
    public final ChatHistory getHistory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        return this.getHistory(uUID);
    }

    public final void blockMessages(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.getHistory(player).startBlocking();
    }

    public final void unblockMessages(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.getHistory(player).stopBlocking();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.histories.remove(event.getPlayer().getUniqueId());
    }

    public final void shutdown() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this);
    }

    private static final Component findMessage$lambda$0(ChatMessage_v1_19_3 $message) {
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.component((String)"name", (ComponentLike)((ComponentLike)$message.getChatFormatting().getName())), Placeholder.component((String)"message", (ComponentLike)((ComponentLike)$message.getChatContent()))};
        return MiniMessagesKt.asMiniWithResolvers("\\<<name>> <message>", tagResolverArray);
    }
}

