/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.interaction;

import com.typewritermc.engine.paper.interaction.BlockingStatus;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import com.typewritermc.engine.paper.interaction.OldMessage;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u0013\u001a\u00020\bJ\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\bJ\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/engine/paper/interaction/ChatHistory;", "", "<init>", "()V", "messages", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/typewritermc/engine/paper/interaction/OldMessage;", "blocking", "", "blockingState", "Lcom/typewritermc/engine/paper/interaction/BlockingStatus;", "startBlocking", "", "stopBlocking", "isBlocking", "addMessage", "message", "Lnet/kyori/adventure/text/Component;", "hasMessage", "clear", "allowedMessageThrough", "clearMessage", "", "resendMessages", "player", "Lorg/bukkit/entity/Player;", "composeDarkMessage", "composeEmptyMessage", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nChatHistoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatHistoryHandler.kt\ncom/typewritermc/engine/paper/interaction/ChatHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1755#2,3:219\n1863#2,2:222\n1863#2,2:224\n1863#2,2:226\n*S KotlinDebug\n*F\n+ 1 ChatHistoryHandler.kt\ncom/typewritermc/engine/paper/interaction/ChatHistory\n*L\n151#1:219,3\n170#1:222,2\n175#1:224,2\n185#1:226,2\n*E\n"})
public final class ChatHistory {
    @NotNull
    private final ConcurrentLinkedQueue<OldMessage> messages = new ConcurrentLinkedQueue();
    private boolean blocking;
    @NotNull
    private BlockingStatus blockingState = BlockingStatus.FullBlocking.INSTANCE;

    public final void startBlocking() {
        this.blockingState = new BlockingStatus.PartialBlocking(0);
        this.blocking = true;
    }

    public final void stopBlocking() {
        this.blocking = false;
    }

    public final boolean isBlocking() {
        return this.blocking;
    }

    public final void addMessage(@NotNull Component message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.blocking) {
            this.blockingState = this.blockingState.addMessage();
        }
        this.messages.add(new OldMessage(message));
        while (this.messages.size() > 100) {
            this.messages.poll();
        }
    }

    public final boolean hasMessage(@NotNull Component message) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(message, "message");
            Iterable $this$any$iv = this.messages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OldMessage it = (OldMessage)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getMessage(), message)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void clear() {
        this.messages.clear();
    }

    public final void allowedMessageThrough() {
        this.blockingState = BlockingStatus.FullBlocking.INSTANCE;
    }

    private final String clearMessage() {
        return StringsKt.repeat("\n", 100 - Math.min(this.messages.size(), ChatHistoryHandlerKt.access$getDarkenLimit()));
    }

    public final void resendMessages(@NotNull Player player, boolean clear) {
        Intrinsics.checkNotNullParameter(player, "player");
        BlockingStatus status = this.blockingState;
        if (status instanceof BlockingStatus.FullBlocking) {
            TextComponent msg = null;
            TextComponent textComponent = Component.text((String)"no-index-resend");
            Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
            msg = textComponent;
            if (clear) {
                msg = msg.append((Component)Component.text((String)this.clearMessage()));
            }
            Iterable $this$forEach$iv = this.messages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OldMessage it = (OldMessage)element$iv;
                boolean bl = false;
                msg = ((TextComponent)msg.append((Component)Component.text((String)"\n"))).append(it.getMessage());
            }
            player.sendMessage((Component)msg);
        } else if (status instanceof BlockingStatus.PartialBlocking) {
            Iterable $this$forEach$iv = CollectionsKt.take(CollectionsKt.reversed((Iterable)this.messages), ((BlockingStatus.PartialBlocking)status).getNewMessages());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OldMessage it = (OldMessage)element$iv;
                boolean bl = false;
                player.sendMessage(it.getMessage());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.blockingState = new BlockingStatus.PartialBlocking(0);
    }

    public static /* synthetic */ void resendMessages$default(ChatHistory chatHistory, Player player, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        chatHistory.resendMessages(player, bl);
    }

    @NotNull
    public final Component composeDarkMessage(@NotNull Component message, boolean clear) {
        Intrinsics.checkNotNullParameter(message, "message");
        TextComponent msg = null;
        TextComponent textComponent = Component.text((String)"no-index");
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        msg = textComponent;
        if (clear) {
            msg = msg.append((Component)Component.text((String)this.clearMessage()));
        }
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)this.messages, ChatHistoryHandlerKt.access$getDarkenLimit());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OldMessage it = (OldMessage)element$iv;
            boolean bl = false;
            msg = msg.append(it.getDarkenMessage());
        }
        msg = msg.append((Component)Component.text((String)StringsKt.repeat("\n", ChatHistoryHandlerKt.access$getSpacing())));
        Component component = msg.append(message);
        Intrinsics.checkNotNullExpressionValue(component, "append(...)");
        return component;
    }

    public static /* synthetic */ Component composeDarkMessage$default(ChatHistory chatHistory, Component component, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return chatHistory.composeDarkMessage(component, bl);
    }

    @NotNull
    public final Component composeEmptyMessage(@NotNull Component message, boolean clear) {
        Intrinsics.checkNotNullParameter(message, "message");
        TextComponent textComponent = Component.text((String)"no-index");
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        TextComponent msg = textComponent;
        if (clear) {
            msg = (TextComponent)msg.append((Component)Component.text((String)this.clearMessage()));
        }
        Component component = msg.append(message);
        Intrinsics.checkNotNullExpressionValue(component, "append(...)");
        return component;
    }

    public static /* synthetic */ Component composeEmptyMessage$default(ChatHistory chatHistory, Component component, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return chatHistory.composeEmptyMessage(component, bl);
    }
}

