/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.interaction;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerActionBar;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import com.github.shynixn.mccoroutine.bukkit.MCCoroutineKt;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.interaction.ActionBarBlocker;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lirand.api.extensions.server.ServerExtensionsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0016H\u0007J\u0006\u0010\u0017\u001a\u00020\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/typewritermc/engine/paper/interaction/ActionBarBlockerHandler;", "Lcom/github/retrooper/packetevents/event/PacketListenerAbstract;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "initialize", "", "blockers", "", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/interaction/ActionBarBlocker;", "onPacketSend", "event", "Lcom/github/retrooper/packetevents/event/PacketSendEvent;", "acceptMessage", "player", "Lorg/bukkit/entity/Player;", "message", "Lnet/kyori/adventure/text/Component;", "enable", "disable", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "shutdown", "engine-paper"})
public final class ActionBarBlockerHandler
extends PacketListenerAbstract
implements Listener {
    @NotNull
    private final Map<UUID, ActionBarBlocker> blockers = new LinkedHashMap();

    public ActionBarBlockerHandler() {
        super(PacketListenerPriority.HIGH);
    }

    public final void initialize() {
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this);
        PluginManager pluginManager = ServerExtensionsKt.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        MCCoroutineKt.registerSuspendingEvents(pluginManager, this, TypewriterPaperPluginKt.getPlugin());
    }

    public void onPacketSend(@Nullable PacketSendEvent event) {
        Component component;
        if (event == null) {
            return;
        }
        ActionBarBlocker actionBarBlocker = this.blockers.get(event.getUser().getUUID());
        if (actionBarBlocker == null) {
            return;
        }
        ActionBarBlocker blocker = actionBarBlocker;
        PacketTypeCommon packetTypeCommon = event.getPacketType();
        if (packetTypeCommon == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
            packet = new WrapperPlayServerSystemChatMessage(event);
            if (!packet.isOverlay()) {
                return;
            }
            component = packet.getMessage();
        } else if (packetTypeCommon == PacketType.Play.Server.ACTION_BAR) {
            packet = new WrapperPlayServerActionBar(event);
            component = packet.getActionBarText();
            if (component == null) {
                return;
            }
        } else {
            return;
        }
        Component component2 = component;
        Intrinsics.checkNotNull(component2);
        if (blocker.isMessageAccepted(component2)) {
            return;
        }
        event.setCancelled(true);
    }

    public final void acceptMessage(@NotNull Player player, @NotNull Component message) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(message, "message");
        ActionBarBlocker actionBarBlocker = this.blockers.get(player.getUniqueId());
        if (actionBarBlocker == null) {
            return;
        }
        ActionBarBlocker blocker = actionBarBlocker;
        blocker.acceptMessage(message);
    }

    public final void enable(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.blockers.containsKey(player.getUniqueId())) {
            return;
        }
        this.blockers.put(player.getUniqueId(), new ActionBarBlocker());
    }

    public final void disable(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.blockers.remove(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.blockers.remove(event.getPlayer().getUniqueId());
    }

    public final void shutdown() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this);
    }
}

