/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPI;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIHandler;
import com.typewritermc.engine.paper.extensions.commandapi.CommandRegistrationStrategy;
import com.typewritermc.engine.paper.extensions.commandapi.PaperCommandRegistration;
import com.typewritermc.engine.paper.extensions.commandapi.SafeVarHandle;
import com.typewritermc.engine.paper.extensions.commandapi.SpigotCommandRegistration;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.ArgumentSubType;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.SuggestionProviders;
import com.typewritermc.engine.paper.extensions.commandapi.commandsenders.AbstractCommandSender;
import com.typewritermc.engine.paper.extensions.commandapi.commandsenders.BukkitCommandSender;
import com.typewritermc.engine.paper.extensions.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import com.typewritermc.engine.paper.extensions.commandapi.nms.NMS_Common;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.ComplexRecipeImpl;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.FloatRange;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.FunctionWrapper;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.IntegerRange;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.Location2D;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.NativeProxyCommandSender;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.ParticleData;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.ScoreboardSlot;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreHolder;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_21_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.CraftSound;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_21_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.potion.CraftPotionEffectType;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;

public class NMS_1_21_R2
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final Field serverFunctionLibraryDispatcher;
    private static final boolean vanillaCommandDispatcherFieldExists;
    private static final SafeVarHandle<MinecraftServer, FuelValues> minecraftServerFuelValues;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(MinecraftKey key2) {
        return NamespacedKey.fromString((String)(key2.b() + ":" + key2.a()));
    }

    @Override
    public ArgumentType<?> _ArgumentAdvancement() {
        return ResourceKeyArgument.a((ResourceKey)Registries.bj);
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.aO);
    }

    @Override
    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public ArgumentType<?> _ArgumentRecipe() {
        return ResourceKeyArgument.a((ResourceKey)Registries.bk);
    }

    @Override
    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.aI);
    }

    @Override
    public final Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.21.2", "1.21.3"};
    }

    private static String serializeNMSItemStack(ItemStack is) {
        return new ArgumentPredicateItemStack(is.i(), is.e()).a((HolderLookup.a)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final String convert(org.bukkit.inventory.ItemStack is) {
        return NMS_1_21_R2.serializeNMSItemStack(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)is));
    }

    @Override
    public final String convert(ParticleData<?> particle) {
        ParticleParam particleOptions = CraftParticle.createParticleParam((org.bukkit.Particle)particle.particle(), particle.data());
        MinecraftKey particleKey = BuiltInRegistries.i.b((Object)particleOptions.a());
        Codec codec = particleOptions.a().c().codec();
        DataResult result = codec.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)particleOptions);
        NBTTagCompound particleOptionsTag = (NBTTagCompound)result.result().get();
        String dataString = particleOptionsTag.e().isEmpty() ? "" : particleOptionsTag.u_();
        return particleKey.toString() + dataString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runCommandFunction(CommandFunction<CommandListenerWrapper> commandFunction, CommandListenerWrapper css) {
        GameProfilerFiller profiler = Profiler.a();
        profiler.a(() -> "function " + String.valueOf(commandFunction.a()));
        AtomicInteger result = new AtomicInteger();
        CommandResultCallback onCommandResult = (succeeded, resultValue) -> result.set(resultValue);
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.a((NBTTagCompound)null, this.getBrigadierDispatcher());
            net.minecraft.commands.CommandDispatcher.a((CommandListenerWrapper)css, executioncontext -> ExecutionContext.a((ExecutionContext)executioncontext, (InstantiatedFunction)instantiatedFunction, (ExecutionCommandSource)css, (CommandResultCallback)onCommandResult));
        }
        catch (FunctionInstantiationException instantiatedFunction) {
        }
        catch (Exception exception) {
            LogUtils.getLogger().warn("Failed to execute function {}", (Object)commandFunction.a(), (Object)exception);
        }
        finally {
            profiler.c();
        }
        return result.get();
    }

    private final SimpleFunctionWrapper convertFunction(CommandFunction<CommandListenerWrapper> commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> this.runCommandFunction(commandFunction, (CommandListenerWrapper)css);
        String[] commands = new String[]{};
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.a((NBTTagCompound)null, this.getBrigadierDispatcher());
            List cArr = instantiatedFunction.b();
            commands = new String[cArr.size()];
            int size2 = cArr.size();
            for (int i = 0; i < size2; ++i) {
                commands[i] = cArr.get(i).toString();
            }
        }
        catch (FunctionInstantiationException functionInstantiationException) {
            // empty catch block
        }
        return new SimpleFunctionWrapper(NMS_1_21_R2.fromResourceLocation(commandFunction.a()), appliedObj, commands);
    }

    @Override
    public final void createDispatcherFile(File file2, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.asCharSink((File)file2, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentUtils.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    @Override
    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return ResourceKeyArgument.e(cmdCtx, (String)key2).toBukkit();
    }

    @Override
    public Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key2), (HolderLookup.a)COMMAND_BUILD_CONTEXT));
    }

    @Override
    public NamedTextColor getAdventureChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        Integer color = ArgumentChatFormat.a(cmdCtx, (String)key2).f();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    @Override
    public final Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key2), (HolderLookup.a)COMMAND_BUILD_CONTEXT));
    }

    @Override
    public final Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key2, ArgumentSubType subType) throws CommandSyntaxException {
        MinecraftKey resourceLocation = ResourceArgument.a(cmdCtx, (String)key2, (ResourceKey)Registries.aI).h().a();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_21_R2.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    @Override
    public final Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key2);
        return block2 -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).e(), new BlockPosition(block2.getX(), block2.getY(), block2.getZ()), true));
    }

    @Override
    public final BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key2).a());
    }

    @Override
    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender.getSource());
    }

    @Override
    public final BaseComponent[] getChat(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key2), (HolderLookup.a)COMMAND_BUILD_CONTEXT));
    }

    @Override
    public final World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key2).getWorld();
    }

    @Override
    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Enchantment enchantment = (Enchantment)ResourceArgument.g(cmdCtx, (String)key2).a();
        MinecraftKey resource2 = ((MinecraftServer)this.getMinecraftServer()).ba().e(Registries.aO).b((Object)enchantment);
        return (org.bukkit.enchantments.Enchantment)Registry.ENCHANTMENT.get(NMS_1_21_R2.fromResourceLocation(resource2));
    }

    @Override
    public final Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        EntitySelector argument2 = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorUsesSelector.set(argument2, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument2.b((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument2.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument2.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument2.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
            }
        }
        return object;
    }

    @Override
    public final EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return EntityType.fromName((String)EntityTypes.a((EntityTypes)((EntityTypes)ResourceArgument.e(cmdCtx, (String)key2).a())).a());
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        CriterionConditionValue.DoubleRange range = ArgumentCriterionValue.a.a(cmdCtx, (String)key2);
        Double lowBoxed = range.a().orElse(null);
        Double highBoxed = range.b().orElse(null);
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    @Override
    public final FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CommandFunction commandFunction : ArgumentTag.a(cmdCtx, (String)key2)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction((CommandFunction<CommandListenerWrapper>)commandFunction), css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key2) {
        MinecraftKey resourceLocation = MinecraftKey.a((String)key2.getNamespace(), (String)key2.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).aE().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((CommandFunction<CommandListenerWrapper>)((CommandFunction)commandFunctionOptional.get()));
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key2) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aE().d()) {
            result.add(NMS_1_21_R2.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key2);
        Integer lowBoxed = range.a().orElse(null);
        Integer highBoxed = range.b().orElse(null);
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    @Override
    public final org.bukkit.inventory.ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key2);
        ItemStack item = input.a(1, false);
        return CraftItemStack.asBukkitCopy((ItemStack)item);
    }

    @Override
    public final Predicate<org.bukkit.inventory.ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        ArgumentItemPredicate.d predicate = ArgumentItemPredicate.a(cmdCtx, (String)key2);
        return arg_0 -> NMS_1_21_R2.lambda$getItemStackPredicate$6((Predicate)predicate, arg_0);
    }

    @Override
    public final Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key2);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), blockPos.c(), blockPos.d());
    }

    @Override
    public final Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key2);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public final Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.c(cmdCtx, (String)key2);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    @Override
    public final Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.b(cmdCtx, (String)key2).a((CommandListenerWrapper)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    @Override
    public final LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return CraftLootTable.minecraftToBukkit((MinecraftKey)ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key2));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return NMS_1_21_R2.fromResourceLocation(ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key2));
    }

    @Override
    public final ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        org.bukkit.Particle particle;
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key2);
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            particle = CraftParticle.minecraftToBukkit((Particle)particleOptions.a());
        } else {
            particle = null;
        }
        if (particleOptions instanceof ParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options2 = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)options2.b()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options3 = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options3);
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options4 = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options4.b().x() * 255.0f)), (int)((int)(options4.b().y() * 255.0f)), (int)((int)(options4.b().z() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options4.d()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options5 = (ParticleParamItem)particleOptions;
            return new ParticleData<org.bukkit.inventory.ItemStack>(particle, CraftItemStack.asBukkitCopy((ItemStack)options5.b()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options6 = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options6);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options7 = (ShriekParticleOption)particleOptions;
            return new ParticleData<Integer>(particle, options7.b());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options8 = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData<Float>(particle, Float.valueOf(options8.b()));
        }
        if (particleOptions instanceof ColorParticleOption) {
            ColorParticleOption options9 = (ColorParticleOption)particleOptions;
            return this.getParticleDataAsColorParticleOption(particle, options9);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Color> getParticleDataAsColorParticleOption(org.bukkit.Particle particle, ColorParticleOption options2) {
        Color color = Color.fromARGB((int)((int)(options2.e() * 255.0f)), (int)((int)(options2.b() * 255.0f)), (int)((int)(options2.c() * 255.0f)), (int)((int)(options2.d() * 255.0f)));
        return new ParticleData<Color>(particle, color);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(org.bukkit.Particle particle, DustColorTransitionOptions options2) {
        Color color = Color.fromRGB((int)((int)(options2.b().x() * 255.0f)), (int)((int)(options2.b().y() * 255.0f)), (int)((int)(options2.b().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options2.c().x() * 255.0f)), (int)((int)(options2.c().y() * 255.0f)), (int)((int)(options2.c().z() * 255.0f)));
        return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options2.d()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, org.bukkit.Particle particle, VibrationParticleOption options2) {
        Vec3D origin = ((CommandListenerWrapper)cmdCtx.getSource()).d();
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.d, origin.e, origin.f);
        PositionSource positionSource = options2.b();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options2.b()));
            return new ParticleData<Object>(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        Vec3D to = (Vec3D)positionSource2.a((net.minecraft.world.level.World)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData<Vibration>(particle, new Vibration(from, (Vibration.Destination)destination, options2.c()));
    }

    @Override
    public Object getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key2, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.minecraftToBukkit((MobEffectList)((MobEffectList)ResourceArgument.f(cmdCtx, (String)key2).a()));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> NMS_1_21_R2.fromResourceLocation(ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key2));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final Recipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        RecipeHolder recipe = ResourceKeyArgument.d(cmdCtx, (String)key2);
        return new ComplexRecipeImpl(NMS_1_21_R2.fromResourceLocation(recipe.a().b()), recipe.toBukkitRecipe());
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return ScoreboardSlot.ofMinecraft(ArgumentScoreboardSlot.a(cmdCtx, (String)key2).a());
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Collection scoreHolders = ArgumentScoreholder.b(cmdCtx, (String)key2);
        HashSet<String> scoreHolderNames = new HashSet<String>();
        for (ScoreHolder scoreHolder : scoreHolders) {
            scoreHolderNames.add(scoreHolder.cI());
        }
        return scoreHolderNames;
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key2).cI();
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        Vec3D pos = css.d();
        Vec2F rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        Entity proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    @Override
    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key2, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key2);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                Optional soundEvent = BuiltInRegistries.b.c(soundResource);
                if (soundEvent.isEmpty()) {
                    yield null;
                }
                yield CraftSound.minecraftToBukkit((SoundEffect)((SoundEffect)((Holder.c)soundEvent.get()).a()));
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).aE();
                ICompletionProvider.a((Iterable)functionData.e(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.d(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).aI().e().stream().map(holder -> holder.a().a()), (SuggestionsBuilder)builder);
            case SuggestionProviders.SOUNDS -> CompletionProviders.b;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).aD().b().stream().map(AdvancementHolder::a), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).bc().a(Registries.bg), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> CompletionProviders.c;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public final SimpleFunctionWrapper[] getTag(NamespacedKey key2) {
        List customFunctions = ((MinecraftServer)this.getMinecraftServer()).aE().b(MinecraftKey.a((String)key2.getNamespace(), (String)key2.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (CommandFunction customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction((CommandFunction<CommandListenerWrapper>)customFunction);
        }
        return convertedCustomFunctions;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aE().e()) {
            result.add(NMS_1_21_R2.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    @Override
    public final void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = ((MinecraftServer)this.getMinecraftServer()).aA;
        serverResources.b().d = ((MinecraftServer)this.getMinecraftServer()).aG();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aF().e());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aZ().D().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aF().c()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            ResourcePackRepository serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aF();
            ArrayList<IResourcePack> packResources = new ArrayList<IResourcePack>();
            for (String packID : collection) {
                ResourcePackLoader pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.f());
            }
            return packResources;
        });
        CompletionStage second2 = first.thenCompose(packResources -> {
            ResourceManager resourceManager = new ResourceManager(EnumResourcePackType.b, packResources);
            CompletableFuture simpleReloadInstance = Reloadable.a((IResourceManager)resourceManager, (List)serverResources.b().f(), (Executor)((MinecraftServer)this.getMinecraftServer()).ay, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(Unit.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second2).thenAcceptAsync(resources2 -> {
            ((MinecraftServer)this.getMinecraftServer()).aA.close();
            ((MinecraftServer)this.getMinecraftServer()).aA = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aF().b(collection);
            FeatureFlagSet enabledFeatures = ((MinecraftServer)this.getMinecraftServer()).aZ().D().b();
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aF().e();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aF().c());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aZ().a(new WorldDataConfiguration(new DataPackConfiguration((List)enabledIDs, disabledIDs), enabledFeatures));
            ((MinecraftServer)this.getMinecraftServer()).aA.b().g();
            ((MinecraftServer)this.getMinecraftServer()).aA.b().c().a(enabledFeatures);
            ((MinecraftServer)this.getMinecraftServer()).aY().a((IResourceManager)((MinecraftServer)this.getMinecraftServer()).aA.a());
            minecraftServerFuelValues.set((MinecraftServer)this.getMinecraftServer(), FuelValues.a((HolderLookup.a)((MinecraftServer)this.getMinecraftServer()).bb().a(), (FeatureFlagSet)enabledFeatures));
        });
        if (((MinecraftServer)this.getMinecraftServer()).bx()) {
            ((MinecraftServer)this.getMinecraftServer()).b(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json, (HolderLookup.a)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.W);
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.z);
    }

    @Override
    public CommandRegistrationStrategy<CommandListenerWrapper> createCommandRegistrationStrategy() {
        Class<?> bukkitCommandNode_bukkitBrigCommand;
        if (vanillaCommandDispatcherFieldExists) {
            return new SpigotCommandRegistration<CommandListenerWrapper>(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).aG().a(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
        }
        try {
            bukkitCommandNode_bukkitBrigCommand = Class.forName("io.papermc.paper.command.brigadier.bukkit.BukkitCommandNode$BukkitBrigCommand");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Expected to find class", e);
        }
        return new PaperCommandRegistration<CommandListenerWrapper>(() -> ((MinecraftServer)this.getMinecraftServer()).aG().a(), node -> bukkitCommandNode_bukkitBrigCommand.isInstance(node.getCommand()));
    }

    private static /* synthetic */ boolean lambda$getItemStackPredicate$6(Predicate predicate, org.bukkit.inventory.ItemStack item) {
        return predicate.test(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item));
    }

    static {
        boolean fieldExists;
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = CommandBuildContext.a((HolderLookup.a)server2.getServer().ba(), (FeatureFlagSet)server2.getServer().aZ().D().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(EntitySelector.class, "p", "usesSelector");
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(CustomFunctionManager.class, "h", "dispatcher");
        try {
            MinecraftServer.class.getDeclaredField("vanillaCommandDispatcher");
            fieldExists = true;
        }
        catch (NoSuchFieldException | SecurityException e) {
            fieldExists = false;
        }
        vanillaCommandDispatcherFieldExists = fieldExists;
        minecraftServerFuelValues = SafeVarHandle.ofOrNull(MinecraftServer.class, "aE", "fuelValues", FuelValues.class);
    }
}

