/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi.nms;

import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPI;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIBukkit;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIHandler;
import com.typewritermc.engine.paper.extensions.commandapi.CommandRegistrationStrategy;
import com.typewritermc.engine.paper.extensions.commandapi.SafeVarHandle;
import com.typewritermc.engine.paper.extensions.commandapi.SpigotCommandRegistration;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.ArgumentSubType;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.SuggestionProviders;
import com.typewritermc.engine.paper.extensions.commandapi.commandsenders.AbstractCommandSender;
import com.typewritermc.engine.paper.extensions.commandapi.commandsenders.BukkitCommandSender;
import com.typewritermc.engine.paper.extensions.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.ComplexRecipeImpl;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.FloatRange;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.FunctionWrapper;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.IntegerRange;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.Location2D;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.MathOperation;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.NativeProxyCommandSender;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.ParticleData;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.Rotation;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.ScoreboardSlot;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_16_R3.Advancement;
import net.minecraft.server.v1_16_R3.ArgumentAngle;
import net.minecraft.server.v1_16_R3.ArgumentBlockPredicate;
import net.minecraft.server.v1_16_R3.ArgumentChat;
import net.minecraft.server.v1_16_R3.ArgumentChatComponent;
import net.minecraft.server.v1_16_R3.ArgumentChatFormat;
import net.minecraft.server.v1_16_R3.ArgumentCriterionValue;
import net.minecraft.server.v1_16_R3.ArgumentDimension;
import net.minecraft.server.v1_16_R3.ArgumentEnchantment;
import net.minecraft.server.v1_16_R3.ArgumentEntity;
import net.minecraft.server.v1_16_R3.ArgumentEntitySummon;
import net.minecraft.server.v1_16_R3.ArgumentItemPredicate;
import net.minecraft.server.v1_16_R3.ArgumentItemStack;
import net.minecraft.server.v1_16_R3.ArgumentMathOperation;
import net.minecraft.server.v1_16_R3.ArgumentMinecraftKeyRegistered;
import net.minecraft.server.v1_16_R3.ArgumentMobEffect;
import net.minecraft.server.v1_16_R3.ArgumentNBTTag;
import net.minecraft.server.v1_16_R3.ArgumentParticle;
import net.minecraft.server.v1_16_R3.ArgumentPosition;
import net.minecraft.server.v1_16_R3.ArgumentPredicateItemStack;
import net.minecraft.server.v1_16_R3.ArgumentProfile;
import net.minecraft.server.v1_16_R3.ArgumentRegistry;
import net.minecraft.server.v1_16_R3.ArgumentRotation;
import net.minecraft.server.v1_16_R3.ArgumentRotationAxis;
import net.minecraft.server.v1_16_R3.ArgumentScoreboardCriteria;
import net.minecraft.server.v1_16_R3.ArgumentScoreboardObjective;
import net.minecraft.server.v1_16_R3.ArgumentScoreboardSlot;
import net.minecraft.server.v1_16_R3.ArgumentScoreboardTeam;
import net.minecraft.server.v1_16_R3.ArgumentScoreholder;
import net.minecraft.server.v1_16_R3.ArgumentTag;
import net.minecraft.server.v1_16_R3.ArgumentTile;
import net.minecraft.server.v1_16_R3.ArgumentTime;
import net.minecraft.server.v1_16_R3.ArgumentUUID;
import net.minecraft.server.v1_16_R3.ArgumentVec2;
import net.minecraft.server.v1_16_R3.ArgumentVec2I;
import net.minecraft.server.v1_16_R3.ArgumentVec3;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.BlockPosition2D;
import net.minecraft.server.v1_16_R3.CommandListenerWrapper;
import net.minecraft.server.v1_16_R3.CompletionProviders;
import net.minecraft.server.v1_16_R3.CriterionConditionValue;
import net.minecraft.server.v1_16_R3.CustomFunction;
import net.minecraft.server.v1_16_R3.CustomFunctionData;
import net.minecraft.server.v1_16_R3.CustomFunctionManager;
import net.minecraft.server.v1_16_R3.DataPackResources;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntitySelector;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumChatFormat;
import net.minecraft.server.v1_16_R3.EnumDirection;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.ICompletionProvider;
import net.minecraft.server.v1_16_R3.IRecipe;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.IReloadableResourceManager;
import net.minecraft.server.v1_16_R3.IWorldReader;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.ParticleParam;
import net.minecraft.server.v1_16_R3.ParticleParamBlock;
import net.minecraft.server.v1_16_R3.ParticleParamItem;
import net.minecraft.server.v1_16_R3.ParticleParamRedstone;
import net.minecraft.server.v1_16_R3.ParticleType;
import net.minecraft.server.v1_16_R3.ShapeDetectorBlock;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.SystemUtils;
import net.minecraft.server.v1_16_R3.Vec2F;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_16_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_16_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftSound;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_16_R3.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_16_R3.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_16_R3.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class NMS_1_16_R3
extends CommandAPIBukkit<CommandListenerWrapper> {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorCheckPermissions;
    private static final SafeVarHandle<ParticleParamBlock, IBlockData> particleParamBlockData;
    private static final SafeVarHandle<ParticleParamItem, ItemStack> particleParamItemStack;
    private static final SafeVarHandle<ParticleParamRedstone, Float> particleParamRedstoneSize;
    private static final SafeVarHandle<ArgumentPredicateItemStack, NBTTagCompound> itemStackPredicateArgument;
    private static final Field customFunctionManagerBrigadierDispatcher;
    private static final SafeVarHandle<DataPackResources, IReloadableResourceManager> dataPackResources;

    protected NamespacedKey fromMinecraftKey(MinecraftKey key2) {
        return NamespacedKey.fromString((String)(key2.getNamespace() + ":" + key2.getKey()));
    }

    @Override
    public ArgumentType<?> _ArgumentAdvancement() {
        return this._ArgumentMinecraftKeyRegistered();
    }

    @Override
    public ArgumentType<?> _ArgumentAngle() {
        return ArgumentAngle.a();
    }

    @Override
    public ArgumentType<?> _ArgumentAxis() {
        return ArgumentRotationAxis.a();
    }

    @Override
    public ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChat() {
        return ArgumentChat.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatFormat() {
        return ArgumentChatFormat.a();
    }

    @Override
    public ArgumentType<?> _ArgumentDimension() {
        return ArgumentDimension.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEnchantment() {
        return ArgumentEnchantment.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.multipleEntities();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ArgumentEntitySummon.a();
    }

    @Override
    public ArgumentType<?> _ArgumentFloatRange() {
        return ArgumentCriterionValue.b();
    }

    @Override
    public ArgumentType<?> _ArgumentIntRange() {
        return ArgumentCriterionValue.a();
    }

    @Override
    public ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMathOperation() {
        return ArgumentMathOperation.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ArgumentMobEffect.a();
    }

    @Override
    public ArgumentType<?> _ArgumentNBTCompound() {
        return ArgumentNBTTag.a();
    }

    @Override
    public ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a();
    }

    @Override
    public ArgumentType<?> _ArgumentPosition() {
        return ArgumentPosition.a();
    }

    @Override
    public ArgumentType<?> _ArgumentPosition2D() {
        return ArgumentVec2I.a();
    }

    @Override
    public ArgumentType<?> _ArgumentProfile() {
        return ArgumentProfile.a();
    }

    @Override
    public ArgumentType<?> _ArgumentRecipe() {
        return this._ArgumentMinecraftKeyRegistered();
    }

    @Override
    public ArgumentType<?> _ArgumentRotation() {
        return ArgumentRotation.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ArgumentScoreboardCriteria.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardObjective() {
        return ArgumentScoreboardObjective.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardSlot() {
        return ArgumentScoreboardSlot.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardTeam() {
        return ArgumentScoreboardTeam.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> ArgumentScoreholder.a();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> ArgumentScoreholder.b();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return this._ArgumentMinecraftKeyRegistered();
    }

    @Override
    public ArgumentType<?> _ArgumentTag() {
        return ArgumentTag.a();
    }

    @Override
    public ArgumentType<?> _ArgumentTime() {
        return ArgumentTime.a();
    }

    @Override
    public ArgumentType<?> _ArgumentUUID() {
        return ArgumentUUID.a();
    }

    @Override
    public ArgumentType<?> _ArgumentVec2(boolean centerPosition) {
        return new ArgumentVec2(centerPosition);
    }

    @Override
    public ArgumentType<?> _ArgumentVec3(boolean centerPosition) {
        return ArgumentVec3.a((boolean)centerPosition);
    }

    @Override
    public Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.16.5"};
    }

    @Override
    public String convert(org.bukkit.inventory.ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)is).getOrCreateTag().asString();
    }

    @Override
    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), particle.data()).a();
    }

    @Override
    public String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String convert(Sound sound) {
        return sound.getKey().toString();
    }

    private SimpleFunctionWrapper convertFunction(CustomFunction customFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = clw -> ((MinecraftServer)this.getMinecraftServer()).getFunctionData().a(customFunction, clw);
        CustomFunction.c[] cArr = customFunction.b();
        String[] result = new String[cArr.length];
        int size2 = cArr.length;
        for (int i = 0; i < size2; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(this.fromMinecraftKey(customFunction.a()), appliedObj, result);
    }

    @Override
    public void createDispatcherFile(File file2, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentRegistry.a(dispatcher, (CommandNode)dispatcher.getRoot())), (File)file2, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public org.bukkit.advancement.Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key2).bukkit;
    }

    @Override
    public final Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key2)));
    }

    @Override
    public final NamedTextColor getAdventureChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        Integer color = ArgumentChatFormat.a(cmdCtx, (String)key2).e();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.ofExact((int)color);
    }

    @Override
    public final Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key2)));
    }

    @Override
    public float getAngle(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return ArgumentAngle.a(cmdCtx, (String)key2);
    }

    @Override
    public EnumSet<Axis> getAxis(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        EnumSet<Axis> set2 = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = ArgumentRotationAxis.a(cmdCtx, (String)key2);
        for (EnumDirection.EnumAxis element : parsedEnumSet) {
            set2.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case EnumDirection.EnumAxis.X -> Axis.X;
                case EnumDirection.EnumAxis.Y -> Axis.Y;
                case EnumDirection.EnumAxis.Z -> Axis.Z;
            });
        }
        return set2;
    }

    @Override
    public Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key2, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)((MinecraftKey)cmdCtx.getArgument(key2, MinecraftKey.class)).getKey().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var4_6 = biome;
                yield var4_6;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var4_7;
                yield var4_7 = this.fromMinecraftKey((MinecraftKey)cmdCtx.getArgument(key2, MinecraftKey.class));
            }
            default -> {
                NamespacedKey var4_8;
                yield var4_8 = null;
            }
        };
    }

    @Override
    public Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key2);
        return block2 -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).getWorld(), new BlockPosition(block2.getX(), block2.getY(), block2.getZ()), true));
    }

    @Override
    public BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key2).a());
    }

    @Override
    public BaseComponent[] getChat(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key2)));
    }

    @Override
    public ChatColor getChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return CraftChatMessage.getColor((EnumChatFormat)ArgumentChatFormat.a(cmdCtx, (String)key2));
    }

    @Override
    public BaseComponent[] getChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key2)));
    }

    @Override
    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        return VanillaCommandWrapper.getListener((CommandSender)senderWrapper.getSource());
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandListenerWrapper clw) {
        try {
            return this.wrapCommandSender(clw.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key2).getWorld();
    }

    @Override
    public Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return new CraftEnchantment(ArgumentEnchantment.a(cmdCtx, (String)key2));
    }

    @Override
    public Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        EntitySelector argument2 = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorCheckPermissions.set(argument2, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument2.getEntities((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument2.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument2.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument2.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
            }
        }
        return object;
    }

    @Override
    public EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return EntityType.fromName((String)EntityTypes.getName((EntityTypes)((EntityTypes)IRegistry.ENTITY_TYPE.get(ArgumentEntitySummon.a(cmdCtx, (String)key2)))).getKey());
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        CriterionConditionValue.FloatRange range = (CriterionConditionValue.FloatRange)cmdCtx.getArgument(key2, CriterionConditionValue.FloatRange.class);
        float low = range.a() == null ? -3.4028235E38f : ((Float)range.a()).floatValue();
        float high = range.b() == null ? Float.MAX_VALUE : ((Float)range.b()).floatValue();
        return new FloatRange(low, high);
    }

    @Override
    public FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper commandListenerWrapper = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction customFunction : ArgumentTag.a(cmdCtx, (String)key2)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(customFunction), commandListenerWrapper, e -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)e).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key2) {
        return this.convertFunction((CustomFunction)((MinecraftServer)this.getMinecraftServer()).getFunctionData().a(new MinecraftKey(key2.getNamespace(), key2.getKey())).get());
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> functions2 = new HashSet<NamespacedKey>();
        for (MinecraftKey key2 : ((MinecraftServer)this.getMinecraftServer()).getFunctionData().f()) {
            functions2.add(this.fromMinecraftKey(key2));
        }
        return functions2;
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key2);
        int low = range.a() == null ? Integer.MIN_VALUE : (Integer)range.a();
        int high = range.b() == null ? Integer.MAX_VALUE : (Integer)range.b();
        return new IntegerRange(low, high);
    }

    @Override
    public org.bukkit.inventory.ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key2);
        ItemStack itemWithMaybeTag = input.a(1, false);
        NBTTagCompound tag = itemStackPredicateArgument.get(input);
        if (tag != null) {
            byte count = tag.getByte("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        org.bukkit.inventory.ItemStack result = CraftItemStack.asBukkitCopy((ItemStack)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((ItemStack)itemWithMaybeTag));
        return result;
    }

    @Override
    public Predicate<org.bukkit.inventory.ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key2);
        return item -> predicate.test(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item));
    }

    @Override
    public Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key2);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), blockPos.a, blockPos.b);
    }

    @Override
    public Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key2);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.b(cmdCtx, (String)key2);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    @Override
    public Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.a(cmdCtx, (String)key2);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.x, vecPos.y, vecPos.z);
    }

    @Override
    public LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        MinecraftKey minecraftKey = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key2);
        return new CraftLootTable(this.fromMinecraftKey(minecraftKey), ((MinecraftServer)this.getMinecraftServer()).getLootTableRegistry().getLootTable(minecraftKey));
    }

    @Override
    public MathOperation getMathOperation(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        ArgumentMathOperation.a(cmdCtx, (String)key2);
        return MathOperation.fromString(CommandAPIHandler.getRawArgumentInput(cmdCtx, key2));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key2);
        return new NamespacedKey(resourceLocation.getNamespace(), resourceLocation.getKey());
    }

    @Override
    public <NBTContainer> Object getNBTCompound(CommandContext<CommandListenerWrapper> cmdCtx, String key2, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(ArgumentNBTTag.a(cmdCtx, (String)key2));
    }

    @Override
    public Objective getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws IllegalArgumentException, CommandSyntaxException {
        String objectiveName = ArgumentScoreboardObjective.a(cmdCtx, (String)key2).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    @Override
    public String getObjectiveCriteria(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return ArgumentScoreboardCriteria.a(cmdCtx, (String)key2).getName();
    }

    @Override
    public OfflinePlayer getOfflinePlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key2).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    @Override
    public ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key2);
        Particle particle = CraftParticle.toBukkit((ParticleParam)particleOptions);
        if (particleOptions instanceof ParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options2 = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)particleParamBlockData.get(options2)));
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options3 = (ParticleParamRedstone)particleOptions;
            return this.getParticleDataAsDustOptions(particle, options3);
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options4 = (ParticleParamItem)particleOptions;
            return new ParticleData<org.bukkit.inventory.ItemStack>(particle, CraftItemStack.asBukkitCopy((ItemStack)particleParamItemStack.get(options4)));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.DustOptions> getParticleDataAsDustOptions(Particle particle, ParticleParamRedstone options2) {
        String optionsStr = options2.a();
        String[] optionsArr = optionsStr.split(" ");
        float red = Float.parseFloat(optionsArr[1]);
        float green = Float.parseFloat(optionsArr[2]);
        float blue = Float.parseFloat(optionsArr[3]);
        Color color = Color.fromRGB((int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f)));
        return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, particleParamRedstoneSize.get(options2).floatValue()));
    }

    @Override
    public Player getPlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        Player target = Bukkit.getPlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key2).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    @Override
    public Object getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key2, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> new CraftPotionEffectType(ArgumentMobEffect.a(cmdCtx, (String)key2));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> this.fromMinecraftKey(ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key2));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    public ComplexRecipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        IRecipe recipe = ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key2);
        return new ComplexRecipeImpl(this.fromMinecraftKey(recipe.getKey()), recipe.toBukkitRecipe());
    }

    @Override
    public Rotation getRotation(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        Vec2F vec = ArgumentRotation.a(cmdCtx, (String)key2).b((CommandListenerWrapper)cmdCtx.getSource());
        return new Rotation(vec.j, vec.i);
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return ScoreboardSlot.ofMinecraft(ArgumentScoreboardSlot.a(cmdCtx, (String)key2));
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return ArgumentScoreholder.b(cmdCtx, (String)key2);
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key2);
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper clw = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = clw.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        Vec3D pos = clw.getPosition();
        Vec2F rot = clw.i();
        World world = this.getWorldForCSS(clw);
        Location location = new Location(world, pos.getX(), pos.getY(), pos.getZ(), rot.j, rot.i);
        Entity proxyEntity = clw.getEntity();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    @Override
    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key2, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key2);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                SoundEffect soundEffect = (SoundEffect)IRegistry.SOUND_EVENT.get(soundResource);
                if (soundEffect == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((SoundEffect)soundEffect);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> this.fromMinecraftKey(soundResource);
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).getFunctionData();
                ICompletionProvider.a((Iterable)functionData.g(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.f(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).getAdvancementData().getAdvancements().stream().map(Advancement::getName), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).getLootTableRegistry().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> CompletionProviders.d;
            case SuggestionProviders.ENTITIES -> CompletionProviders.e;
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> ICompletionProvider.a((Iterable)IRegistry.MOB_EFFECT.keySet(), (SuggestionsBuilder)builder);
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public SimpleFunctionWrapper[] getTag(NamespacedKey key2) {
        ArrayList customFunctions = new ArrayList(((MinecraftServer)this.getMinecraftServer()).getFunctionData().b(new MinecraftKey(key2.getNamespace(), key2.getKey())).getTagged());
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size2 = customFunctions.size();
        for (int i = 0; i < size2; ++i) {
            result[i] = this.convertFunction((CustomFunction)customFunctions.get(i));
        }
        return result;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> functions2 = new HashSet<NamespacedKey>();
        for (MinecraftKey key2 : ((MinecraftServer)this.getMinecraftServer()).getFunctionData().g()) {
            functions2.add(this.fromMinecraftKey(key2));
        }
        return functions2;
    }

    @Override
    public Team getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key2) throws CommandSyntaxException {
        String teamName = ArgumentScoreboardTeam.a(cmdCtx, (String)key2).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    @Override
    public int getTime(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return (Integer)cmdCtx.getArgument(key2, Integer.class);
    }

    @Override
    public UUID getUUID(CommandContext<CommandListenerWrapper> cmdCtx, String key2) {
        return ArgumentUUID.a(cmdCtx, (String)key2);
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper clw) {
        return clw.getWorld() == null ? null : clw.getWorld().getWorld();
    }

    @Override
    public void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        DataPackResources datapackResources = ((MinecraftServer)this.getMinecraftServer()).dataPackResources;
        datapackResources.commandDispatcher = ((MinecraftServer)this.getMinecraftServer()).getCommandDispatcher();
        try {
            customFunctionManagerBrigadierDispatcher.set(datapackResources.a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        CompletableFuture unitCompletableFuture = dataPackResources.get(datapackResources).a(SystemUtils.f(), Runnable::run, ((MinecraftServer)this.getMinecraftServer()).getResourcePackRepository().f(), CompletableFuture.completedFuture(null));
        CompletionStage completablefuture = ((CompletableFuture)unitCompletableFuture.whenComplete((u, t) -> {
            if (t != null) {
                datapackResources.close();
            }
        })).thenApply(u -> datapackResources);
        try {
            ((DataPackResources)((CompletableFuture)completablefuture).get()).i();
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    @Override
    public CommandRegistrationStrategy<CommandListenerWrapper> createCommandRegistrationStrategy() {
        return new SpigotCommandRegistration<CommandListenerWrapper>(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).getCommandDispatcher().a(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
    }

    static {
        entitySelectorCheckPermissions = CommandAPIHandler.getField(EntitySelector.class, "checkPermissions", "checkPermissions");
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
        particleParamBlockData = SafeVarHandle.ofOrNull(ParticleParamBlock.class, "c", "c", IBlockData.class);
        particleParamItemStack = SafeVarHandle.ofOrNull(ParticleParamItem.class, "c", "c", ItemStack.class);
        particleParamRedstoneSize = SafeVarHandle.ofOrNull(ParticleParamRedstone.class, "g", "g", Float.TYPE);
        itemStackPredicateArgument = SafeVarHandle.ofOrNull(ArgumentPredicateItemStack.class, "c", "c", NBTTagCompound.class);
        customFunctionManagerBrigadierDispatcher = CommandAPIHandler.getField(CustomFunctionManager.class, "h", "h");
        dataPackResources = SafeVarHandle.ofOrNull(DataPackResources.class, "b", "b", IReloadableResourceManager.class);
    }
}

