/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIBukkit;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.CommandAPIArgumentType;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.LocationType;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.SafeOverrideableArgument;
import com.typewritermc.engine.paper.extensions.commandapi.executors.CommandArguments;
import org.bukkit.Location;

public class LocationArgument
extends SafeOverrideableArgument<Location, Location> {
    private final boolean isPrecise;

    public LocationArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public LocationArgument(String nodeName, LocationType type2) {
        this(nodeName, type2, true);
    }

    public LocationArgument(String nodeName, LocationType type2, boolean centerPosition) {
        super(nodeName, type2 == LocationType.BLOCK_POSITION ? CommandAPIBukkit.get()._ArgumentPosition() : CommandAPIBukkit.get()._ArgumentVec3(centerPosition), type2 == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockY() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getY() + " " + l.getZ());
        this.isPrecise = type2 == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location> getPrimitiveType() {
        return Location.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION;
    }

    @Override
    public <CommandSourceStack> Location parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key2, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? CommandAPIBukkit.get().getLocationPrecise(cmdCtx, key2) : CommandAPIBukkit.get().getLocationBlock(cmdCtx, key2);
    }
}

