/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIBukkit;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.CommandAPIArgumentType;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.LocationType;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.SafeOverrideableArgument;
import com.typewritermc.engine.paper.extensions.commandapi.executors.CommandArguments;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.Location2D;

public class Location2DArgument
extends SafeOverrideableArgument<Location2D, Location2D> {
    private final boolean isPrecise;

    public Location2DArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public Location2DArgument(String nodeName, LocationType type2) {
        this(nodeName, type2, true);
    }

    public Location2DArgument(String nodeName, LocationType type2, boolean centerPosition) {
        super(nodeName, type2 == LocationType.BLOCK_POSITION ? CommandAPIBukkit.get()._ArgumentPosition2D() : CommandAPIBukkit.get()._ArgumentVec2(centerPosition), type2 == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getZ());
        this.isPrecise = type2 == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location2D> getPrimitiveType() {
        return Location2D.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION_2D;
    }

    @Override
    public <CommandSourceStack> Location2D parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key2, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? CommandAPIBukkit.get().getLocation2DPrecise(cmdCtx, key2) : CommandAPIBukkit.get().getLocation2DBlock(cmdCtx, key2);
    }
}

