/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIBukkit;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.Argument;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.ArgumentSubType;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.CommandAPIArgumentType;
import com.typewritermc.engine.paper.extensions.commandapi.executors.CommandArguments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntitySelectorArgument {
    private EntitySelectorArgument() {
        throw new IllegalStateException("Use EntitySelectorArgument.OneEntity/OnePlayer/ManyEntities/ManyPlayers instead");
    }

    public static class ManyPlayers
    extends Argument<Collection> {
        private final boolean allowEmpty;

        public ManyPlayers(String nodeName) {
            this(nodeName, true);
        }

        public ManyPlayers(String nodeName, boolean allowEmpty) {
            super(nodeName, CommandAPIBukkit.get()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS));
            this.allowEmpty = allowEmpty;
        }

        @Override
        public Class<Collection> getPrimitiveType() {
            return Collection.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Collection<Player> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key2, CommandArguments previousArgs) throws CommandSyntaxException {
            return (Collection)CommandAPIBukkit.get().getEntitySelector(cmdCtx, key2, ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS, this.allowEmpty);
        }

        @Override
        public List<String> getEntityNames(Object argument2) {
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Player entity : (List)argument2) {
                playerNames.add(entity.getName());
            }
            return playerNames;
        }
    }

    public static class ManyEntities
    extends Argument<Collection> {
        private final boolean allowEmpty;

        public ManyEntities(String nodeName) {
            this(nodeName, true);
        }

        public ManyEntities(String nodeName, boolean allowEmpty) {
            super(nodeName, CommandAPIBukkit.get()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES));
            this.allowEmpty = allowEmpty;
        }

        @Override
        public Class<Collection> getPrimitiveType() {
            return Collection.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Collection<Entity> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key2, CommandArguments previousArgs) throws CommandSyntaxException {
            return (Collection)CommandAPIBukkit.get().getEntitySelector(cmdCtx, key2, ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES, this.allowEmpty);
        }

        @Override
        public List<String> getEntityNames(Object argument2) {
            ArrayList<String> entityNames = new ArrayList<String>();
            for (Entity entity : (List)argument2) {
                entityNames.add(entity.getName());
            }
            return entityNames;
        }
    }

    public static class OnePlayer
    extends Argument<Player> {
        public OnePlayer(String nodeName) {
            super(nodeName, CommandAPIBukkit.get()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER));
        }

        @Override
        public Class<Player> getPrimitiveType() {
            return Player.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Player parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key2, CommandArguments previousArgs) throws CommandSyntaxException {
            return (Player)CommandAPIBukkit.get().getEntitySelector(cmdCtx, key2, ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER, true);
        }

        @Override
        public List<String> getEntityNames(Object argument2) {
            return List.of(((Player)argument2).getName());
        }
    }

    public static class OneEntity
    extends Argument<Entity> {
        public OneEntity(String nodeName) {
            super(nodeName, CommandAPIBukkit.get()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY));
        }

        @Override
        public Class<Entity> getPrimitiveType() {
            return Entity.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Entity parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key2, CommandArguments previousArgs) throws CommandSyntaxException {
            return (Entity)CommandAPIBukkit.get().getEntitySelector(cmdCtx, key2, ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY, true);
        }

        @Override
        public List<String> getEntityNames(Object argument2) {
            return List.of(((Entity)argument2).getName());
        }
    }
}

