/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIBukkit;
import com.typewritermc.engine.paper.extensions.commandapi.SuggestionInfo;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.Argument;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.ArgumentSuggestions;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.CommandAPIArgumentType;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.GreedyArgument;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.SuggestionsBranch;
import com.typewritermc.engine.paper.extensions.commandapi.executors.CommandArguments;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.CommandResult;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;

public class CommandArgument
extends Argument<CommandResult>
implements GreedyArgument {
    SuggestionsBranch<CommandSender> replacements = SuggestionsBranch.suggest(new ArgumentSuggestions[0]);

    public CommandArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)StringArgumentType.greedyString());
        this.applySuggestions();
    }

    private void applySuggestions() {
        super.replaceSuggestions((SuggestionInfo<CommandSender> info, SuggestionsBuilder builder) -> {
            Player player;
            Block block2;
            CommandSender sender = (CommandSender)info.sender();
            SimpleCommandMap commandMap = CommandAPIBukkit.get().getSimpleCommandMap();
            String command = info.currentArg();
            StringReader context = new StringReader(command);
            if (!command.contains(" ")) {
                ArgumentSuggestions<CommandSender> replacement = this.replacements.getNextSuggestion(sender, new String[0]);
                if (replacement != null) {
                    return replacement.suggest(new SuggestionInfo<CommandSender>(sender, new CommandArguments(new Object[0], new LinkedHashMap<String, Object>(), new String[0], new LinkedHashMap<String, String>(), info.currentInput()), command, command), builder);
                }
                List results = commandMap.tabComplete(sender, command);
                if (results == null) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)context);
                }
                if (sender instanceof Player) {
                    for (String result : results) {
                        builder.suggest(result.substring(1));
                    }
                } else {
                    for (String result : results) {
                        builder.suggest(result);
                    }
                }
                return builder.buildFuture();
            }
            String commandLabel = command.substring(0, command.indexOf(" "));
            Command target = commandMap.getCommand(commandLabel);
            if (target == null) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)context);
            }
            String[] arguments2 = command.split(" ");
            if (!arguments2[0].isEmpty() && command.endsWith(" ")) {
                arguments2 = Arrays.copyOf(arguments2, arguments2.length + 1);
                arguments2[arguments2.length - 1] = "";
            }
            builder = builder.createOffset(builder.getStart() + command.lastIndexOf(" ") + 1);
            int lastIndex = arguments2.length - 1;
            Object[] previousArguments = Arrays.copyOf(arguments2, lastIndex);
            ArgumentSuggestions<CommandSender> replacement = this.replacements.getNextSuggestion(sender, (String[])previousArguments);
            if (replacement != null) {
                return replacement.suggest(new SuggestionInfo<CommandSender>(sender, new CommandArguments(previousArguments, new LinkedHashMap<String, Object>(), (String[])previousArguments, new LinkedHashMap<String, String>(), info.currentInput()), command, arguments2[lastIndex]), builder);
            }
            arguments2 = Arrays.copyOfRange(arguments2, 1, arguments2.length);
            Location location = null;
            if (sender instanceof Player && (block2 = (player = (Player)sender).getTargetBlockExact(5, FluidCollisionMode.NEVER)) != null) {
                location = block2.getLocation();
            }
            for (String tabCompletion : target.tabComplete(sender, commandLabel, arguments2, location)) {
                builder.suggest(tabCompletion);
            }
            return builder.buildFuture();
        });
    }

    @SafeVarargs
    public final CommandArgument replaceSuggestions(ArgumentSuggestions<CommandSender> ... suggestions) {
        this.replacements = SuggestionsBranch.suggest(suggestions);
        return this;
    }

    @Override
    public CommandArgument replaceSuggestions(ArgumentSuggestions<CommandSender> suggestions) {
        this.replacements = SuggestionsBranch.suggest(suggestions);
        return this;
    }

    @SafeVarargs
    public final Argument<CommandResult> branchSuggestions(SuggestionsBranch<CommandSender> ... branches) {
        this.replacements.branch(branches);
        return this;
    }

    @Override
    public Class<CommandResult> getPrimitiveType() {
        return CommandResult.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.COMMAND;
    }

    @Override
    public <CommandSourceStack> CommandResult parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key2, CommandArguments previousArgs) throws CommandSyntaxException {
        String command = (String)cmdCtx.getArgument(key2, String.class);
        SimpleCommandMap commandMap = CommandAPIBukkit.get().getSimpleCommandMap();
        CommandSender sender = (CommandSender)CommandAPIBukkit.get().getSenderForCommand((CommandContext)cmdCtx, false).getSource();
        StringReader context = new StringReader(command);
        String[] arguments2 = command.split(" ");
        String commandLabel = arguments2[0];
        Command target = commandMap.getCommand(commandLabel);
        if (target == null) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)context);
        }
        this.replacements.enforceReplacements(sender, arguments2);
        return new CommandResult(target, Arrays.copyOfRange(arguments2, 1, arguments2.length));
    }
}

