/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi;

import com.typewritermc.engine.paper.extensions.commandapi.CommandAPI;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIBukkit;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPICommand;
import com.typewritermc.engine.paper.extensions.commandapi.CommandPermission;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.Argument;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.GreedyStringArgument;
import com.typewritermc.engine.paper.extensions.commandapi.executors.NativeCommandExecutor;
import com.typewritermc.engine.paper.extensions.commandapi.wrappers.NativeProxyCommandSender;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.java.JavaPlugin;

public final class Converter {
    private static final List<Argument<?>> PLAIN_ARGUMENTS = List.of(new GreedyStringArgument("args"));
    private static final Set<String> CALLER_METHODS = Set.of("isPermissionSet", "hasPermission", "addAttachment", "removeAttachment", "recalculatePermissions", "getEffectivePermissions", "isOp", "setOp");

    private Converter() {
    }

    public static void convert(JavaPlugin plugin) {
        CommandAPI.logInfo("Converting commands for " + plugin.getName() + ":");
        for (String commandName : plugin.getDescription().getCommands().keySet()) {
            Converter.convertPluginCommand(plugin, commandName, PLAIN_ARGUMENTS);
        }
    }

    public static void convert(JavaPlugin plugin, String cmdName) {
        Converter.convertPluginCommand(plugin, cmdName, PLAIN_ARGUMENTS);
    }

    public static void convert(JavaPlugin plugin, String cmdName, Argument<?> ... arguments2) {
        Converter.convertPluginCommand(plugin, cmdName, Arrays.asList(arguments2));
    }

    public static void convert(JavaPlugin plugin, String cmdName, List<Argument<?>> arguments2) {
        Converter.convertPluginCommand(plugin, cmdName, arguments2);
    }

    public static void convert(String cmdName) {
        Converter.convertCommand(cmdName, PLAIN_ARGUMENTS);
    }

    public static void convert(String cmdName, List<Argument<?>> arguments2) {
        Converter.convertCommand(cmdName, arguments2);
    }

    private static void convertCommand(String commandName, List<Argument<?>> arguments2) {
        CommandAPI.logInfo("Converting command /" + commandName);
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(commandName).withPermission(CommandPermission.NONE)).executesNative((sender, args2) -> Bukkit.dispatchCommand((CommandSender)Converter.mergeProxySender(sender), (String)commandName))).register();
        CommandAPICommand multiArgs = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(commandName).withPermission(CommandPermission.NONE)).withArguments(arguments2)).executesNative((sender, args2) -> {
            CommandSender proxiedSender = Converter.mergeProxySender(sender);
            Bukkit.dispatchCommand((CommandSender)proxiedSender, (String)(commandName + " " + String.join((CharSequence)" ", (String[])args2.args())));
        });
        multiArgs.setConverted(true);
        multiArgs.register();
    }

    private static String[] unpackAliases(Object aliasObj) {
        if (aliasObj == null) {
            return new String[0];
        }
        if (aliasObj instanceof String) {
            String aliasStr = (String)aliasObj;
            return new String[]{aliasStr};
        }
        if (aliasObj instanceof List) {
            List aliasList = (List)aliasObj;
            return aliasList.toArray(new String[0]);
        }
        throw new IllegalStateException("Invalid type for aliases. Expected String or List, but got " + aliasObj.getClass().getSimpleName());
    }

    private static void convertPluginCommand(JavaPlugin plugin, String commandName, List<Argument<?>> arguments2) {
        CommandAPI.logInfo("Converting " + plugin.getName() + " command /" + commandName);
        Map cmdData = (Map)plugin.getDescription().getCommands().get(commandName);
        if (cmdData == null) {
            CommandAPI.logError("Couldn't find /" + commandName + " in " + plugin.getName() + "'s plugin.yml. Are you sure you're not confusing it with an alias?");
            return;
        }
        Object[] aliases = Converter.unpackAliases(cmdData.get("aliases"));
        if (aliases.length != 0) {
            CommandAPI.logInfo("Aliases for command /" + commandName + " found. Using aliases " + Arrays.deepToString(aliases));
        }
        String fullDescription = null;
        Object descriptionObj = cmdData.get("description");
        if (descriptionObj != null && descriptionObj instanceof String) {
            String descriptionStr;
            fullDescription = descriptionStr = (String)descriptionObj;
        }
        CommandPermission permissionNode = null;
        String permission = (String)cmdData.get("permission");
        if (permission == null) {
            permissionNode = CommandPermission.NONE;
        } else {
            CommandAPI.logInfo("Permission for command /" + commandName + " found. Using " + permission);
            permissionNode = CommandPermission.fromString(permission);
        }
        NativeCommandExecutor executor = (sender, args2) -> {
            PluginCommand command = plugin.getCommand(commandName);
            if (command == null) {
                command = CommandAPIBukkit.get().getSimpleCommandMap().getCommand(commandName);
            }
            CommandSender proxiedSender = CommandAPI.getConfiguration().shouldSkipSenderProxy(plugin.getName()) ? sender.getCallee() : Converter.mergeProxySender(sender);
            Object[] patt0$temp = args2.args();
            if (patt0$temp instanceof String[]) {
                String[] argsArr = (String[])patt0$temp;
                command.execute(proxiedSender, commandName, argsArr);
            } else {
                command.execute(proxiedSender, commandName, new String[0]);
            }
        };
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(commandName).withPermission(permissionNode)).withAliases((String[])aliases)).withFullDescription(fullDescription)).executesNative(executor)).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(commandName).withPermission(permissionNode)).withAliases((String[])aliases)).withArguments(arguments2)).withFullDescription(fullDescription)).executesNative(executor)).setConverted(true)).register();
    }

    private static CommandSender mergeProxySender(NativeProxyCommandSender proxySender) {
        HashSet calleeInterfacesList = new HashSet();
        Class currentClass = proxySender.getCallee().getClass();
        if (currentClass.isInterface()) {
            calleeInterfacesList.add(currentClass);
        }
        while (currentClass != null) {
            calleeInterfacesList.addAll(Arrays.asList(currentClass.getInterfaces()));
            currentClass = currentClass.getSuperclass();
        }
        Class[] calleeInterfaces = calleeInterfacesList.toArray(new Class[0]);
        InvocationHandler handler = (p, method2, args2) -> {
            switch (method2.getName()) {
                case "getLocation": {
                    return proxySender.getLocation();
                }
                case "getBlock": {
                    return proxySender.getLocation().getBlock();
                }
                case "getEyeLocation": {
                    CommandSender patt0$temp = proxySender.getCallee();
                    if (patt0$temp instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)patt0$temp;
                        Location loc = proxySender.getLocation();
                        loc.setY(loc.getY() + livingEntity.getEyeHeight());
                        return loc;
                    }
                    return proxySender.getLocation();
                }
                case "getWorld": {
                    return proxySender.getWorld();
                }
            }
            return method2.invoke((Object)(CALLER_METHODS.contains(method2.getName()) ? proxySender.getCaller() : proxySender.getCallee()), args2);
        };
        return (CommandSender)Proxy.newProxyInstance(CommandSender.class.getClassLoader(), calleeInterfaces, handler);
    }
}

