/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.typewritermc.engine.paper.extensions.commandapi.RegisteredCommand;
import com.typewritermc.engine.paper.extensions.commandapi.SafeVarHandle;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class CommandRegistrationStrategy<Source> {
    static final SafeVarHandle<CommandNode<?>, Map> commandNodeChildren = SafeVarHandle.ofOrNull(CommandNode.class, "children", "children", Map.class);
    private static final SafeVarHandle<CommandNode<?>, Map> commandNodeLiterals = SafeVarHandle.ofOrNull(CommandNode.class, "literals", "literals", Map.class);
    private static final SafeVarHandle<CommandNode<?>, Map> commandNodeArguments = SafeVarHandle.ofOrNull(CommandNode.class, "arguments", "arguments", Map.class);

    protected void removeBrigadierCommands(RootCommandNode<Source> root, String commandName, boolean unregisterNamespaces, Predicate<CommandNode<Source>> extraCheck) {
        Map children2 = commandNodeChildren.get((CommandNode<?>)root);
        Map literals = commandNodeLiterals.get((CommandNode<?>)root);
        Map arguments2 = commandNodeArguments.get((CommandNode<?>)root);
        CommandRegistrationStrategy.removeCommandFromMapIfCheckPasses(children2, commandName, extraCheck);
        CommandRegistrationStrategy.removeCommandFromMapIfCheckPasses(literals, commandName, extraCheck);
        CommandRegistrationStrategy.removeCommandFromMapIfCheckPasses(arguments2, commandName, extraCheck);
        if (unregisterNamespaces) {
            CommandRegistrationStrategy.removeCommandNamespace(children2, commandName, extraCheck);
            CommandRegistrationStrategy.removeCommandNamespace(literals, commandName, extraCheck);
            CommandRegistrationStrategy.removeCommandNamespace(arguments2, commandName, extraCheck);
        }
    }

    protected static <T> void removeCommandNamespace(Map<String, T> map2, String commandName, Predicate<T> extraCheck) {
        for (String key2 : new HashSet<String>(map2.keySet())) {
            if (!CommandRegistrationStrategy.isThisTheCommandButNamespaced(commandName, key2)) continue;
            CommandRegistrationStrategy.removeCommandFromMapIfCheckPasses(map2, key2, extraCheck);
        }
    }

    protected static <T> void removeCommandFromMapIfCheckPasses(Map<String, T> map2, String key2, Predicate<T> extraCheck) {
        T element = map2.get(key2);
        if (element == null) {
            return;
        }
        if (extraCheck.test(element)) {
            map2.remove(key2);
        }
    }

    protected static boolean isThisTheCommandButNamespaced(String commandName, String key2) {
        if (!key2.contains(":")) {
            return false;
        }
        String[] split = key2.split(":");
        if (split.length < 2) {
            return false;
        }
        return split[1].equalsIgnoreCase(commandName);
    }

    public abstract CommandDispatcher<Source> getBrigadierDispatcher();

    public abstract void runTasksAfterServerStart();

    public abstract void postCommandRegistration(RegisteredCommand var1, LiteralCommandNode<Source> var2, List<LiteralCommandNode<Source>> var3);

    public abstract LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> var1, String var2);

    public abstract void unregister(String var1, boolean var2, boolean var3);

    public abstract void preReloadDataPacks();
}

