/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi;

import java.util.Objects;
import java.util.Optional;

public class CommandPermission {
    public static final CommandPermission NONE = new CommandPermission(PermissionNode.NONE);
    public static final CommandPermission OP = new CommandPermission(PermissionNode.OP);
    private boolean negated = false;
    private String permission;
    private PermissionNode permissionNode;

    public static CommandPermission fromString(String permission) {
        return new CommandPermission(permission);
    }

    private CommandPermission(PermissionNode permissionNode) {
        this.permission = null;
        this.permissionNode = permissionNode;
    }

    private CommandPermission(String permission) {
        this.permission = permission;
        this.permissionNode = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CommandPermission)) {
            return false;
        }
        CommandPermission other = (CommandPermission)obj;
        return this.negated == other.negated && Objects.equals(this.permission, other.permission) && this.permissionNode == other.permissionNode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.negated, this.permission, this.permissionNode});
    }

    public String toString() {
        String result = this.permissionNode != null ? (this.permissionNode == PermissionNode.OP ? "OP" : "NONE") : this.permission;
        return (this.negated ? "not " : "") + result;
    }

    public Optional<String> getPermission() {
        return Optional.ofNullable(this.permission);
    }

    public boolean isNegated() {
        return this.negated;
    }

    PermissionNode getPermissionNode() {
        return this.permissionNode;
    }

    CommandPermission negate() {
        this.negated = true;
        return this;
    }

    private static enum PermissionNode {
        NONE,
        OP;

    }
}

