/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.extensions.commandapi;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.RootCommandNode;
import com.typewritermc.engine.paper.extensions.commandapi.AbstractCommandAPICommand;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIHandler;
import com.typewritermc.engine.paper.extensions.commandapi.CommandAPIPlatform;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.AbstractArgument;
import com.typewritermc.engine.paper.extensions.commandapi.arguments.Literal;
import com.typewritermc.engine.paper.extensions.commandapi.commandsenders.AbstractCommandSender;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;

public final class Brigadier {
    private Brigadier() {
    }

    public static CommandDispatcher getCommandDispatcher() {
        return CommandAPIHandler.getInstance().getPlatform().getBrigadierDispatcher();
    }

    public static RootCommandNode getRootNode() {
        return Brigadier.getCommandDispatcher().getRoot();
    }

    public static <CommandSender, Argument extends AbstractArgument<String, ?, ?, CommandSender>> LiteralArgumentBuilder fromLiteralArgument(Literal<Argument> literalArgument2) {
        CommandAPIHandler<?, ?, ?> handler = CommandAPIHandler.getInstance();
        return handler.getLiteralArgumentBuilderArgument(literalArgument2.getLiteral(), ((AbstractArgument)literalArgument2.instance()).getArgumentPermission(), ((AbstractArgument)literalArgument2.instance()).getRequirements());
    }

    public static <CommandSender, Argument extends AbstractArgument<?, ?, Argument, CommandSender>> RedirectModifier fromPredicate(BiPredicate<CommandSender, Object[]> predicate, List<Argument> args2) {
        return cmdCtx -> {
            if (predicate.test(Brigadier.getCommandSenderFromContext(cmdCtx), Brigadier.parseArguments(cmdCtx, args2))) {
                return Collections.singleton(cmdCtx.getSource());
            }
            return Collections.emptyList();
        };
    }

    public static <Argument extends AbstractArgument<?, ?, Argument, CommandSender>, CommandSender> Command fromCommand(AbstractCommandAPICommand<?, Argument, CommandSender> command) {
        CommandAPIHandler<?, ?, ?> handler = CommandAPIHandler.getInstance();
        return handler.generateCommand((AbstractArgument[])command.getArguments().toArray(AbstractArgument[]::new), command.getExecutor(), command.isConverted());
    }

    public static <Argument extends AbstractArgument<?, ?, Argument, ?>> RequiredArgumentBuilder fromArgument(List<Argument> args2, Argument argument2) {
        CommandAPIHandler<?, ?, ?> handler = CommandAPIHandler.getInstance();
        return handler.getRequiredArgumentBuilderDynamic((AbstractArgument[])args2.toArray(AbstractArgument[]::new), argument2);
    }

    public static <Argument extends AbstractArgument<?, ?, Argument, ?>> RequiredArgumentBuilder fromArgument(Argument argument2) {
        CommandAPIHandler<?, ?, ?> handler = CommandAPIHandler.getInstance();
        return handler.getRequiredArgumentBuilderDynamic(new AbstractArgument[]{argument2}, argument2);
    }

    public static <Argument extends AbstractArgument<?, ?, Argument, ?>> SuggestionProvider toSuggestions(Argument argument2, List<Argument> args2) {
        CommandAPIHandler<?, ?, ?> handler = CommandAPIHandler.getInstance();
        return handler.toSuggestions(argument2, (AbstractArgument[])args2.toArray(AbstractArgument[]::new), true);
    }

    public static <Argument extends AbstractArgument<?, ?, Argument, ?>> Object[] parseArguments(CommandContext cmdCtx, List<Argument> args2) throws CommandSyntaxException {
        CommandAPIHandler<?, ?, ?> handler = CommandAPIHandler.getInstance();
        return handler.argsToCommandArgs(cmdCtx, (AbstractArgument[])args2.toArray(AbstractArgument[]::new)).args();
    }

    public static <CommandSender> Object getBrigadierSourceFromCommandSender(CommandSender sender) {
        CommandAPIPlatform<?, ?, ?> platform = CommandAPIHandler.getInstance().getPlatform();
        return platform.getBrigadierSourceFromCommandSender(platform.wrapCommandSender(sender));
    }

    public static <CommandSender> CommandSender getCommandSenderFromContext(CommandContext cmdCtx) {
        CommandAPIPlatform<?, ?, ?> platform = CommandAPIHandler.getInstance().getPlatform();
        AbstractCommandSender<?> abstractSender = platform.getSenderForCommand(cmdCtx, false);
        return (CommandSender)abstractSender.getSource();
    }
}

