/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.roadnetwork.pathfinding;

import com.extollit.gaming.ai.path.model.IBlockDescription;
import com.extollit.gaming.ai.path.model.IBlockObject;
import com.extollit.linalg.immutable.AxisAlignedBBox;
import com.typewritermc.engine.paper.entry.roadnetwork.pathfinding.PFBlockKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/engine/paper/entry/roadnetwork/pathfinding/PFBlock;", "Lcom/extollit/gaming/ai/path/model/IBlockDescription;", "Lcom/extollit/gaming/ai/path/model/IBlockObject;", "location", "Lorg/bukkit/Location;", "type", "Lorg/bukkit/Material;", "data", "Lorg/bukkit/block/data/BlockData;", "<init>", "(Lorg/bukkit/Location;Lorg/bukkit/Material;Lorg/bukkit/block/data/BlockData;)V", "getLocation", "()Lorg/bukkit/Location;", "getType", "()Lorg/bukkit/Material;", "getData", "()Lorg/bukkit/block/data/BlockData;", "bounds", "Lcom/extollit/linalg/immutable/AxisAlignedBBox;", "isFenceLike", "", "isClimbable", "isDoor", "isIntractable", "isImpeding", "isFullyBounded", "isLiquid", "isIncinerating", "engine-paper"})
public final class PFBlock
implements IBlockDescription,
IBlockObject {
    @NotNull
    private final Location location;
    @NotNull
    private final Material type;
    @NotNull
    private final BlockData data;

    public PFBlock(@NotNull Location location, @NotNull Material type2, @NotNull BlockData data2) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.location = location;
        this.type = type2;
        this.data = data2;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final Material getType() {
        return this.type;
    }

    @NotNull
    public final BlockData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public AxisAlignedBBox bounds() {
        VoxelShape voxelShape = this.data.getCollisionShape(this.location);
        Intrinsics.checkNotNullExpressionValue(voxelShape, "getCollisionShape(...)");
        VoxelShape collisionShape = voxelShape;
        return PFBlockKt.access$toAABB(collisionShape);
    }

    @Override
    public boolean isFenceLike() {
        String string = this.type.getKey().getKey();
        Intrinsics.checkNotNullExpressionValue(string, "getKey(...)");
        if (StringsKt.contains$default((CharSequence)string, "fence", false, 2, null)) {
            return true;
        }
        String string2 = this.type.getKey().getKey();
        Intrinsics.checkNotNullExpressionValue(string2, "getKey(...)");
        return StringsKt.endsWith$default(string2, "wall", false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isClimbable() {
        if (this.type == Material.LADDER) return true;
        String string = this.type.getKey().getKey();
        Intrinsics.checkNotNullExpressionValue(string, "getKey(...)");
        if (!StringsKt.contains$default((CharSequence)string, "vine", false, 2, null)) return false;
        return true;
    }

    @Override
    public boolean isDoor() {
        String string = this.type.getKey().getKey();
        Intrinsics.checkNotNullExpressionValue(string, "getKey(...)");
        return StringsKt.endsWith$default(string, "door", false, 2, null);
    }

    @Override
    public boolean isIntractable() {
        return false;
    }

    @Override
    public boolean isImpeding() {
        return this.type.isSolid();
    }

    @Override
    public boolean isFullyBounded() {
        VoxelShape voxelShape = this.data.getCollisionShape(this.location);
        Intrinsics.checkNotNullExpressionValue(voxelShape, "getCollisionShape(...)");
        VoxelShape voxelShape2 = voxelShape;
        if (voxelShape2.getBoundingBoxes().size() != 1) {
            return false;
        }
        Collection collection = voxelShape2.getBoundingBoxes();
        Intrinsics.checkNotNullExpressionValue(collection, "getBoundingBoxes(...)");
        BoundingBox boundingBox = (BoundingBox)CollectionsKt.first(collection);
        return boundingBox.getMinX() == 0.0 && boundingBox.getMinY() == 0.0 && boundingBox.getMinZ() == 0.0 && boundingBox.getWidthX() == 1.0 && boundingBox.getHeight() == 1.0 && boundingBox.getWidthZ() == 1.0;
    }

    @Override
    public boolean isLiquid() {
        return this.type == Material.WATER || this.type == Material.LAVA;
    }

    @Override
    public boolean isIncinerating() {
        return this.type == Material.LAVA || this.type == Material.FIRE || this.type == Material.SOUL_FIRE || this.type == Material.MAGMA_BLOCK;
    }
}

