/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.roadnetwork.content;

import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerParticle;
import com.typewritermc.engine.paper.content.ContentComponent;
import com.typewritermc.engine.paper.entry.entries.RoadEdge;
import com.typewritermc.engine.paper.entry.entries.RoadNode;
import com.typewritermc.engine.paper.entry.entries.RoadNodeId;
import com.typewritermc.engine.paper.entry.roadnetwork.content.RoadNetworkContentModeKt;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/typewritermc/engine/paper/entry/roadnetwork/content/NetworkEdgesComponent;", "Lcom/typewritermc/engine/paper/content/ContentComponent;", "fetchNodes", "Lkotlin/Function0;", "", "Lcom/typewritermc/engine/paper/entry/entries/RoadNode;", "fetchEdges", "Lcom/typewritermc/engine/paper/entry/entries/RoadEdge;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "cycle", "", "showingEdges", "Lcom/typewritermc/engine/paper/entry/roadnetwork/content/NetworkEdgesComponent$ShowingEdge;", "initialize", "", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshEdges", "tick", "easeInOutQuad", "", "dispose", "ShowingEdge", "Companion", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nRoadNetworkContentMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoadNetworkContentMode.kt\ncom/typewritermc/engine/paper/entry/roadnetwork/content/NetworkEdgesComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n1202#2,2:389\n1230#2,4:391\n774#2:395\n865#2,2:396\n1611#2,9:398\n1863#2:407\n1864#2:409\n1620#2:410\n1863#2,2:411\n1#3:408\n*S KotlinDebug\n*F\n+ 1 RoadNetworkContentMode.kt\ncom/typewritermc/engine/paper/entry/roadnetwork/content/NetworkEdgesComponent\n*L\n273#1:389,2\n273#1:391,4\n275#1:395\n275#1:396,2\n279#1:398,9\n279#1:407\n279#1:409\n279#1:410\n292#1:411,2\n279#1:408\n*E\n"})
public final class NetworkEdgesComponent
implements ContentComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<List<RoadNode>> fetchNodes;
    @NotNull
    private final Function0<List<RoadEdge>> fetchEdges;
    private int cycle;
    @NotNull
    private List<ShowingEdge> showingEdges;
    public static final int EDGE_SHOW_DURATION = 50;

    public NetworkEdgesComponent(@NotNull Function0<? extends List<RoadNode>> fetchNodes, @NotNull Function0<? extends List<RoadEdge>> fetchEdges) {
        Intrinsics.checkNotNullParameter(fetchNodes, "fetchNodes");
        Intrinsics.checkNotNullParameter(fetchEdges, "fetchEdges");
        this.fetchNodes = fetchNodes;
        this.fetchEdges = fetchEdges;
        this.showingEdges = CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public Object initialize(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        this.cycle = 0;
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final void refreshEdges(Player player) {
        $this$associateBy$iv = this.fetchNodes.invoke();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        var6_6 = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        $i$f$associateByTo = false;
        for (T element$iv$iv : $this$associateByTo$iv$iv) {
            var11_14 = (RoadNode)element$iv$iv;
            var20_19 = destination$iv$iv;
            $i$a$-associateBy-NetworkEdgesComponent$refreshEdges$nodes$1 = false;
            var20_19.put(RoadNodeId.box-impl(it.getId-HTzf43A()), element$iv$iv);
        }
        nodes = destination$iv$iv;
        $this$associateBy$iv = this.fetchEdges.invoke();
        var20_19 = this;
        $i$f$filter = false;
        capacity$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (RoadEdge)element$iv$iv;
            $i$a$-filter-NetworkEdgesComponent$refreshEdges$1 = false;
            v0 = (RoadNode)nodes.get(RoadNodeId.box-impl(it.getStart-HTzf43A()));
            if (v0 == null || (v0 = v0.getLocation()) == null) ** GOTO lbl-1000
            v1 = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(v1, "getLocation(...)");
            if ((v0 = ExtensionsKt.distanceSqrt((Location)v0, v1)) != null) {
                v2 = v0.doubleValue();
            } else lbl-1000:
            // 2 sources

            {
                v2 = 1.7976931348623157E308;
            }
            v3 = v2 < RoadNetworkContentModeKt.access$getShowEdgeDistance() * RoadNetworkContentModeKt.access$getShowEdgeDistance();
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var10_13 = $this$forEach$iv$iv$iv.iterator();
        while (var10_13.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var10_13.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            edge = (RoadEdge)element$iv$iv;
            $i$a$-mapNotNull-NetworkEdgesComponent$refreshEdges$2 = false;
            v4 = (RoadNode)nodes.get(RoadNodeId.box-impl(edge.getStart-HTzf43A()));
            if (v4 == null || (v4 = v4.getLocation()) == null) {
                v5 = null;
            } else {
                start = v4;
                v6 = (RoadNode)nodes.get(RoadNodeId.box-impl(edge.getEnd-HTzf43A()));
                if (v6 == null || (v6 = v6.getLocation()) == null) {
                    v5 = null;
                } else {
                    end = v6;
                    v5 = new ShowingEdge((Location)start, (Location)end, NetworkEdgesComponent.Companion.colorFromHash(RoadNodeId.hashCode-impl(edge.getStart-HTzf43A())));
                }
            }
            if (v5 == null) continue;
            it$iv$iv = v5;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        var20_19.showingEdges = (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object tick(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        if (this.cycle == 0) {
            this.refreshEdges(player);
        }
        double progress = this.easeInOutQuad((double)this.cycle / (double)50);
        Iterable $this$forEach$iv = this.showingEdges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShowingEdge edge = (ShowingEdge)element$iv;
            boolean bl = false;
            Location start2 = edge.getStartLocation();
            Location end2 = edge.getEndLocation();
            for (int i = 0; i < 2; ++i) {
                double percentage = progress - (double)i * 0.05;
                Location location = ExtensionsKt.lerp(start2, end2, percentage);
                PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerParticle(new Particle(ParticleTypes.DUST, (ParticleData)new ParticleDustData(1.0f, RoadNetworkContentModeKt.toPacketColor(edge.getColor()))), true, PlayerPacketsKt.toVector3d(location), Vector3f.zero(), 0.0f, 1), player);
            }
        }
        int n = this.cycle;
        this.cycle = n + 1;
        if (this.cycle > 50) {
            this.cycle = 0;
        }
        return Unit.INSTANCE;
    }

    private final double easeInOutQuad(double $this$easeInOutQuad) {
        return $this$easeInOutQuad < 0.5 ? (double)2 * $this$easeInOutQuad * $this$easeInOutQuad : (double)-1 + ((double)4 - (double)2 * $this$easeInOutQuad) * $this$easeInOutQuad;
    }

    @Override
    @Nullable
    public Object dispose(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/typewritermc/engine/paper/entry/roadnetwork/content/NetworkEdgesComponent$Companion;", "", "<init>", "()V", "EDGE_SHOW_DURATION", "", "colorFromHash", "Lorg/bukkit/Color;", "hash", "engine-paper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color colorFromHash(int hash) {
            double r = (double)(hash >> 16 & 0xFF) / 255.0;
            double g = (double)(hash >> 8 & 0xFF) / 255.0;
            double b = (double)(hash & 0xFF) / 255.0;
            Color color = Color.fromRGB((int)((int)(r * (double)255)), (int)((int)(g * (double)255)), (int)((int)(b * (double)255)));
            Intrinsics.checkNotNullExpressionValue(color, "fromRGB(...)");
            return color;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/typewritermc/engine/paper/entry/roadnetwork/content/NetworkEdgesComponent$ShowingEdge;", "", "startLocation", "Lorg/bukkit/Location;", "endLocation", "color", "Lorg/bukkit/Color;", "<init>", "(Lorg/bukkit/Location;Lorg/bukkit/Location;Lorg/bukkit/Color;)V", "getStartLocation", "()Lorg/bukkit/Location;", "getEndLocation", "getColor", "()Lorg/bukkit/Color;", "engine-paper"})
    public static final class ShowingEdge {
        @NotNull
        private final Location startLocation;
        @NotNull
        private final Location endLocation;
        @NotNull
        private final Color color;

        public ShowingEdge(@NotNull Location startLocation, @NotNull Location endLocation, @NotNull Color color) {
            Intrinsics.checkNotNullParameter(startLocation, "startLocation");
            Intrinsics.checkNotNullParameter(endLocation, "endLocation");
            Intrinsics.checkNotNullParameter(color, "color");
            this.startLocation = startLocation;
            this.endLocation = endLocation;
            this.color = color;
        }

        public /* synthetic */ ShowingEdge(Location location, Location location2, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                color = Color.RED;
            }
            this(location, location2, color);
        }

        @NotNull
        public final Location getStartLocation() {
            return this.startLocation;
        }

        @NotNull
        public final Location getEndLocation() {
            return this.endLocation;
        }

        @NotNull
        public final Color getColor() {
            return this.color;
        }
    }
}

