/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.quest;

import com.typewritermc.core.entries.Entry;
import com.typewritermc.core.entries.Query;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.FactListenerSubscription;
import com.typewritermc.engine.paper.entry.FactWatcherKt;
import com.typewritermc.engine.paper.entry.entries.QuestEntry;
import com.typewritermc.engine.paper.entry.entries.ReadableFactEntry;
import com.typewritermc.engine.paper.entry.quest.QuestStatus;
import com.typewritermc.engine.paper.entry.quest.QuestTracker$refreshWatchedFacts$;
import com.typewritermc.engine.paper.entry.quest.QuestTracker$setup$;
import com.typewritermc.engine.paper.entry.quest.QuestTrackerKt;
import com.typewritermc.engine.paper.events.AsyncQuestStatusUpdate;
import com.typewritermc.engine.paper.events.AsyncTrackedQuestUpdate;
import com.typewritermc.engine.paper.utils.ThreadType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0006\u0010\u0013\u001a\u00020\u0011J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0017J\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0017J\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0017J\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u001e\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ\u0014\u0010\u001f\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010 \u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/typewritermc/engine/paper/entry/quest/QuestTracker;", "", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "quests", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/QuestEntry;", "Lcom/typewritermc/engine/paper/entry/quest/QuestStatus;", "trackedQuest", "factWatchSubscription", "Lcom/typewritermc/engine/paper/entry/FactListenerSubscription;", "setup", "", "refreshWatchedFacts", "dispose", "refresh", "ref", "inactiveQuests", "", "activeQuests", "completedQuests", "isQuestInactive", "", "quest", "isQuestActive", "isQuestCompleted", "trackQuest", "unTrackQuest", "Companion", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nQuestTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestTracker.kt\ncom/typewritermc/engine/paper/entry/quest/QuestTracker\n+ 2 Query.kt\ncom/typewritermc/core/entries/Query$Companion\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,153:1\n154#2:154\n99#2:155\n154#2:159\n99#2:160\n99#2:182\n1317#3:156\n1318#3:158\n1317#3:183\n1318#3:185\n8#4:157\n8#4:184\n503#5,7:161\n503#5,7:168\n503#5,7:175\n*S KotlinDebug\n*F\n+ 1 QuestTracker.kt\ncom/typewritermc/engine/paper/entry/quest/QuestTracker\n*L\n26#1:154\n26#1:155\n33#1:159\n33#1:160\n37#1:182\n26#1:156\n26#1:158\n39#1:183\n39#1:185\n26#1:157\n40#1:184\n70#1:161,7\n71#1:168,7\n72#1:175,7\n*E\n"})
public final class QuestTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Player player;
    @NotNull
    private final ConcurrentHashMap<Ref<QuestEntry>, QuestStatus> quests;
    @Nullable
    private Ref<QuestEntry> trackedQuest;
    @Nullable
    private FactListenerSubscription factWatchSubscription;

    public QuestTracker(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.player = player;
        this.quests = new ConcurrentHashMap();
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    /*
     * WARNING - void declaration
     */
    public final void setup() {
        void this_$iv$iv;
        Query.Companion this_$iv = Query.Companion;
        boolean $i$f$find = false;
        Object object = this_$iv;
        Function1 filter$iv$iv = setup$$inlined$find$1.INSTANCE;
        boolean $i$f$findWhere = false;
        Sequence $this$forEach$iv = this_$iv$iv.findWhere(Reflection.getOrCreateKotlinClass(QuestEntry.class), filter$iv$iv);
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            QuestEntry it = (QuestEntry)element$iv;
            boolean bl = false;
            Entry $this$ref$iv = it;
            boolean $i$f$ref = false;
            this.refresh(new Ref<QuestEntry>($this$ref$iv.getId(), Reflection.getOrCreateKotlinClass(QuestEntry.class)));
        }
        this.refreshWatchedFacts();
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshWatchedFacts() {
        void this_$iv$iv;
        FactListenerSubscription factListenerSubscription = this.factWatchSubscription;
        if (factListenerSubscription != null) {
            factListenerSubscription.cancel(this.player);
        }
        Query.Companion this_$iv = Query.Companion;
        boolean $i$f$find = false;
        Query.Companion companion = this_$iv;
        Function1 filter$iv$iv = refreshWatchedFacts$$inlined$find$1.INSTANCE;
        boolean $i$f$findWhere = false;
        List<Ref<ReadableFactEntry>> facts2 = SequencesKt.toList(SequencesKt.flatMapIterable(this_$iv$iv.findWhere(Reflection.getOrCreateKotlinClass(QuestEntry.class), filter$iv$iv), QuestTracker::refreshWatchedFacts$lambda$1));
        this.factWatchSubscription = FactWatcherKt.listenForFacts(this.player, facts2, (arg_0, arg_1) -> QuestTracker.refreshWatchedFacts$lambda$4(this, arg_0, arg_1));
    }

    public final void dispose() {
        block0: {
            FactListenerSubscription factListenerSubscription = this.factWatchSubscription;
            if (factListenerSubscription == null) break block0;
            factListenerSubscription.cancel(this.player);
        }
    }

    private final void refresh(Ref<QuestEntry> ref) {
        QuestEntry questEntry = ref.get();
        if (questEntry == null) {
            return;
        }
        QuestEntry quest = questEntry;
        QuestStatus status = quest.questStatus(this.player);
        QuestStatus oldStatus = this.quests.get(ref);
        ((Map)this.quests).put(ref, status);
        if (oldStatus == null) {
            return;
        }
        if (oldStatus == status) {
            return;
        }
        if (oldStatus != QuestStatus.ACTIVE && status == QuestStatus.ACTIVE) {
            this.trackQuest(ref);
        } else if (Intrinsics.areEqual(this.trackedQuest, ref)) {
            this.unTrackQuest();
        }
        ThreadType.DISPATCHERS_ASYNC.launch((Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this, ref, oldStatus, status, null){
            int label;
            final /* synthetic */ QuestTracker this$0;
            final /* synthetic */ Ref<QuestEntry> $ref;
            final /* synthetic */ QuestStatus $oldStatus;
            final /* synthetic */ QuestStatus $status;
            {
                this.this$0 = $receiver;
                this.$ref = $ref;
                this.$oldStatus = $oldStatus;
                this.$status = $status;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        new AsyncQuestStatusUpdate(this.this$0.getPlayer(), this.$ref, this.$oldStatus, this.$status).callEvent();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public final List<Ref<QuestEntry>> inactiveQuests() {
        Map $this$filterValues$iv = this.quests;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            QuestStatus it = (QuestStatus)((Object)entry$iv.getValue());
            boolean bl = false;
            if (!(it == QuestStatus.INACTIVE)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.toList(((Map)result$iv).keySet());
    }

    @NotNull
    public final List<Ref<QuestEntry>> activeQuests() {
        Map $this$filterValues$iv = this.quests;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            QuestStatus it = (QuestStatus)((Object)entry$iv.getValue());
            boolean bl = false;
            if (!(it == QuestStatus.ACTIVE)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.toList(((Map)result$iv).keySet());
    }

    @NotNull
    public final List<Ref<QuestEntry>> completedQuests() {
        Map $this$filterValues$iv = this.quests;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            QuestStatus it = (QuestStatus)((Object)entry$iv.getValue());
            boolean bl = false;
            if (!(it == QuestStatus.COMPLETED)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.toList(((Map)result$iv).keySet());
    }

    public final boolean isQuestInactive(@NotNull Ref<QuestEntry> quest) {
        Intrinsics.checkNotNullParameter(quest, "quest");
        return this.quests.get(quest) == QuestStatus.INACTIVE;
    }

    public final boolean isQuestActive(@NotNull Ref<QuestEntry> quest) {
        Intrinsics.checkNotNullParameter(quest, "quest");
        return this.quests.get(quest) == QuestStatus.ACTIVE;
    }

    public final boolean isQuestCompleted(@NotNull Ref<QuestEntry> quest) {
        Intrinsics.checkNotNullParameter(quest, "quest");
        return this.quests.get(quest) == QuestStatus.COMPLETED;
    }

    @Nullable
    public final Ref<QuestEntry> trackedQuest() {
        return this.trackedQuest;
    }

    public final void trackQuest(@NotNull Ref<QuestEntry> quest) {
        Intrinsics.checkNotNullParameter(quest, "quest");
        Ref<QuestEntry> from = this.trackedQuest;
        this.trackedQuest = quest;
        ThreadType.DISPATCHERS_ASYNC.launch((Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this, from, quest, null){
            int label;
            final /* synthetic */ QuestTracker this$0;
            final /* synthetic */ Ref<QuestEntry> $from;
            final /* synthetic */ Ref<QuestEntry> $quest;
            {
                this.this$0 = $receiver;
                this.$from = $from;
                this.$quest = $quest;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        new AsyncTrackedQuestUpdate(this.this$0.getPlayer(), this.$from, this.$quest).callEvent();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final void unTrackQuest() {
        Ref<QuestEntry> from = this.trackedQuest;
        this.trackedQuest = null;
        ThreadType.DISPATCHERS_ASYNC.launch((Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this, from, null){
            int label;
            final /* synthetic */ QuestTracker this$0;
            final /* synthetic */ Ref<QuestEntry> $from;
            {
                this.this$0 = $receiver;
                this.$from = $from;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        new AsyncTrackedQuestUpdate(this.this$0.getPlayer(), this.$from, null).callEvent();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final Iterable refreshWatchedFacts$lambda$1(QuestEntry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getFacts();
    }

    private static final boolean refreshWatchedFacts$lambda$4$lambda$2(Ref $ref, QuestEntry quest) {
        Intrinsics.checkNotNullParameter(quest, "quest");
        return quest.getFacts().contains($ref);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit refreshWatchedFacts$lambda$4(QuestTracker this$0, Player player, Ref ref) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(player, "<unused var>");
        Intrinsics.checkNotNullParameter(ref, "ref");
        Query.Companion companion = Query.Companion;
        Function1<QuestEntry, Boolean> filter$iv = arg_0 -> QuestTracker.refreshWatchedFacts$lambda$4$lambda$2(ref, arg_0);
        boolean $i$f$findWhere = false;
        Sequence<QuestEntry> $this$forEach$iv = this_$iv.findWhere(Reflection.getOrCreateKotlinClass(QuestEntry.class), filter$iv);
        boolean $i$f$forEach = false;
        Iterator<QuestEntry> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            QuestEntry element$iv;
            QuestEntry it = element$iv = iterator2.next();
            boolean bl = false;
            Entry $this$ref$iv = it;
            boolean $i$f$ref = false;
            this$0.refresh(new Ref<QuestEntry>($this$ref$iv.getId(), Reflection.getOrCreateKotlinClass(QuestEntry.class)));
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final List<Ref<QuestEntry>> inactiveQuests(@NotNull Player player) {
        return Companion.inactiveQuests(player);
    }

    @JvmStatic
    @NotNull
    public static final List<Ref<QuestEntry>> activeQuests(@NotNull Player player) {
        return Companion.activeQuests(player);
    }

    @JvmStatic
    @NotNull
    public static final List<Ref<QuestEntry>> completedQuests(@NotNull Player player) {
        return Companion.completedQuests(player);
    }

    @JvmStatic
    public static final boolean isQuestInactive(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
        return Companion.isQuestInactive(player, quest);
    }

    @JvmStatic
    public static final boolean isQuestActive(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
        return Companion.isQuestActive(player, quest);
    }

    @JvmStatic
    public static final boolean isQuestCompleted(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
        return Companion.isQuestCompleted(player, quest);
    }

    @JvmStatic
    @Nullable
    public static final Ref<QuestEntry> trackedQuest(@NotNull Player player) {
        return Companion.trackedQuest(player);
    }

    @JvmStatic
    public static final boolean isQuestTracked(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
        return Companion.isQuestTracked(player, quest);
    }

    @JvmStatic
    @Nullable
    public static final Unit trackQuest(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
        return Companion.trackQuest(player, quest);
    }

    @JvmStatic
    @Nullable
    public static final Unit unTrackQuest(@NotNull Player player) {
        return Companion.unTrackQuest(player);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\u001e\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\u0012\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J%\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/typewritermc/engine/paper/entry/quest/QuestTracker$Companion;", "", "<init>", "()V", "inactiveQuests", "", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/QuestEntry;", "player", "Lorg/bukkit/entity/Player;", "activeQuests", "completedQuests", "isQuestInactive", "", "quest", "isQuestActive", "isQuestCompleted", "trackedQuest", "isQuestTracked", "trackQuest", "", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/core/entries/Ref;)Lkotlin/Unit;", "unTrackQuest", "(Lorg/bukkit/entity/Player;)Lkotlin/Unit;", "engine-paper"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<Ref<QuestEntry>> inactiveQuests(@NotNull Player player) {
            Intrinsics.checkNotNullParameter(player, "player");
            return QuestTrackerKt.inactiveQuests(player);
        }

        @JvmStatic
        @NotNull
        public final List<Ref<QuestEntry>> activeQuests(@NotNull Player player) {
            Intrinsics.checkNotNullParameter(player, "player");
            return QuestTrackerKt.activeQuests(player);
        }

        @JvmStatic
        @NotNull
        public final List<Ref<QuestEntry>> completedQuests(@NotNull Player player) {
            Intrinsics.checkNotNullParameter(player, "player");
            return QuestTrackerKt.completedQuests(player);
        }

        @JvmStatic
        public final boolean isQuestInactive(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(quest, "quest");
            return QuestTrackerKt.isQuestInactive(player, quest);
        }

        @JvmStatic
        public final boolean isQuestActive(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(quest, "quest");
            return QuestTrackerKt.isQuestActive(player, quest);
        }

        @JvmStatic
        public final boolean isQuestCompleted(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(quest, "quest");
            return QuestTrackerKt.isQuestCompleted(player, quest);
        }

        @JvmStatic
        @Nullable
        public final Ref<QuestEntry> trackedQuest(@NotNull Player player) {
            Intrinsics.checkNotNullParameter(player, "player");
            return QuestTrackerKt.trackedQuest(player);
        }

        @JvmStatic
        public final boolean isQuestTracked(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(quest, "quest");
            return QuestTrackerKt.isQuestTracked(player, quest);
        }

        @JvmStatic
        @Nullable
        public final Unit trackQuest(@NotNull Player player, @NotNull Ref<QuestEntry> quest) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(quest, "quest");
            return QuestTrackerKt.trackQuest(player, quest);
        }

        @JvmStatic
        @Nullable
        public final Unit unTrackQuest(@NotNull Player player) {
            Intrinsics.checkNotNullParameter(player, "player");
            return QuestTrackerKt.unTrackQuest(player);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

