/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entries;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.QuestEntry;
import com.typewritermc.engine.paper.entry.quest.QuestStatus;
import com.typewritermc.engine.paper.entry.quest.QuestTrackerKt;
import com.typewritermc.engine.paper.events.AsyncQuestStatusUpdate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/typewritermc/engine/paper/entry/entries/QuestAudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "quest", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/QuestEntry;", "<init>", "(Lcom/typewritermc/core/entries/Ref;)V", "filter", "", "player", "Lorg/bukkit/entity/Player;", "onQuestStatusUpdate", "", "event", "Lcom/typewritermc/engine/paper/events/AsyncQuestStatusUpdate;", "engine-paper"})
public final class QuestAudienceFilter
extends AudienceFilter {
    @NotNull
    private final Ref<QuestEntry> quest;

    public QuestAudienceFilter(@NotNull Ref<QuestEntry> quest) {
        Intrinsics.checkNotNullParameter(quest, "quest");
        super(quest);
        this.quest = quest;
    }

    @Override
    public boolean filter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return QuestTrackerKt.isQuestActive(player, this.quest);
    }

    @EventHandler
    public final void onQuestStatusUpdate(@NotNull AsyncQuestStatusUpdate event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!Intrinsics.areEqual(event.getQuest(), this.quest)) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this.updateFilter(player, event.getTo() == QuestStatus.ACTIVE);
    }
}

