/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entries;

import com.github.retrooper.packetevents.protocol.score.ScoreFormat;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisplayScoreboard;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerResetScore;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerScoreboardObjective;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateScore;
import com.typewritermc.core.entries.LibraryKt;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.AudienceManagerKt;
import com.typewritermc.engine.paper.entry.entries.AudienceEntry;
import com.typewritermc.engine.paper.entry.entries.LinesEntry;
import com.typewritermc.engine.paper.entry.entries.PlayerSingleDisplay;
import com.typewritermc.engine.paper.entry.entries.SidebarEntry;
import com.typewritermc.engine.paper.entry.entries.SingleFilter;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.extensions.placeholderapi.PlaceholderExpansionKt;
import com.typewritermc.engine.paper.utils.MiniMessagesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\u001e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\t0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/typewritermc/engine/paper/entry/entries/PlayerSidebarDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/PlayerSingleDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/SidebarEntry;", "player", "Lorg/bukkit/entity/Player;", "displayKClass", "Lkotlin/reflect/KClass;", "Lcom/typewritermc/engine/paper/entry/entries/SingleFilter;", "current", "Lcom/typewritermc/core/entries/Ref;", "<init>", "(Lorg/bukkit/entity/Player;Lkotlin/reflect/KClass;Lcom/typewritermc/core/entries/Ref;)V", "lines", "", "Lcom/typewritermc/engine/paper/entry/entries/LinesEntry;", "lastTitle", "", "lastLines", "initialize", "", "setup", "tick", "dispose", "createSidebar", "title", "disposeSidebar", "refreshSidebar", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nSidebarEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SidebarEntry.kt\ncom/typewritermc/engine/paper/entry/entries/PlayerSidebarDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n774#2:171\n865#2,2:172\n1062#2:174\n1611#2,9:175\n1863#2:184\n1864#2:186\n1620#2:187\n1368#2:188\n1454#2,5:189\n1#3:185\n*S KotlinDebug\n*F\n+ 1 SidebarEntry.kt\ncom/typewritermc/engine/paper/entry/entries/PlayerSidebarDisplay\n*L\n90#1:171\n90#1:172,2\n91#1:174\n92#1:175,9\n92#1:184\n92#1:186\n92#1:187\n93#1:188\n93#1:189,5\n92#1:185\n*E\n"})
final class PlayerSidebarDisplay
extends PlayerSingleDisplay<SidebarEntry> {
    @NotNull
    private List<Ref<LinesEntry>> lines;
    @NotNull
    private String lastTitle;
    @NotNull
    private List<String> lastLines;

    public PlayerSidebarDisplay(@NotNull Player player, @NotNull KClass<? extends SingleFilter<SidebarEntry, ?>> displayKClass, @NotNull Ref<SidebarEntry> current) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(displayKClass, "displayKClass");
        Intrinsics.checkNotNullParameter(current, "current");
        super(player, displayKClass, current);
        this.lines = CollectionsKt.emptyList();
        this.lastTitle = "";
        this.lastLines = CollectionsKt.emptyList();
    }

    @Override
    public void initialize() {
        super.initialize();
        SidebarEntry sidebarEntry = (SidebarEntry)this.getRef().get();
        if (sidebarEntry == null) {
            return;
        }
        SidebarEntry sidebar = sidebarEntry;
        String title = sidebar.display(this.getPlayer());
        this.createSidebar(title);
    }

    @Override
    public void setup() {
        super.setup();
        this.lines = AudienceManagerKt.descendants(this.getRef(), Reflection.getOrCreateKotlinClass(LinesEntry.class));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable $this$sortedByDescending$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        super.tick();
        SidebarEntry sidebarEntry = (SidebarEntry)this.getRef().get();
        if (sidebarEntry == null) {
            return;
        }
        SidebarEntry sidebar = sidebarEntry;
        String title = sidebar.display(this.getPlayer());
        Iterable iterable = this.lines;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Ref)element$iv$iv;
            boolean bl = false;
            if (!AudienceManagerKt.inAudience(this.getPlayer(), (Ref<? extends AudienceEntry>)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Ref it = (Ref)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(LibraryKt.getPriority(it));
                it = (Ref)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, LibraryKt.getPriority(it));
            }
        });
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Ref it2 = (Ref)element$iv$iv;
            boolean bl2 = false;
            LinesEntry linesEntry = (LinesEntry)it2.get();
            if ((linesEntry != null ? linesEntry.lines(this.getPlayer()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = StringsKt.lines(PlaceholderExpansionKt.parsePlaceholders((String)it, this.getPlayer()));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List lines = (List)destination$iv$iv;
        if (!Intrinsics.areEqual(lines, this.lastLines) || !Intrinsics.areEqual(title, this.lastTitle)) {
            this.refreshSidebar(title, lines);
            this.lastTitle = title;
            this.lastLines = lines;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeSidebar();
        this.lines = CollectionsKt.emptyList();
        this.lastTitle = "";
        this.lastLines = CollectionsKt.emptyList();
    }

    private final void createSidebar(String title) {
        PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerScoreboardObjective("typewriter", WrapperPlayServerScoreboardObjective.ObjectiveMode.CREATE, MiniMessagesKt.asMini(title), WrapperPlayServerScoreboardObjective.RenderType.INTEGER, (ScoreFormat)ScoreFormat.blankScore()), this.getPlayer());
        PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerDisplayScoreboard(1, "typewriter"), this.getPlayer());
    }

    private final void disposeSidebar() {
        PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerScoreboardObjective("typewriter", WrapperPlayServerScoreboardObjective.ObjectiveMode.REMOVE, (Component)Component.empty(), null, null), this.getPlayer());
    }

    private final void refreshSidebar(String title, List<String> lines) {
        WrapperPlayServerScoreboardObjective packet = new WrapperPlayServerScoreboardObjective("typewriter", WrapperPlayServerScoreboardObjective.ObjectiveMode.UPDATE, MiniMessagesKt.asMini(title), WrapperPlayServerScoreboardObjective.RenderType.INTEGER, (ScoreFormat)ScoreFormat.blankScore());
        PlayerPacketsKt.sendPacketTo((PacketWrapper)packet, this.getPlayer());
        WrapperPlayServerDisplayScoreboard displayPacket = new WrapperPlayServerDisplayScoreboard(1, "typewriter");
        PlayerPacketsKt.sendPacketTo((PacketWrapper)displayPacket, this.getPlayer());
        for (IndexedValue indexedValue : CollectionsKt.take(CollectionsKt.withIndex((Iterable)lines), 15)) {
            int index = indexedValue.component1();
            String line = (String)indexedValue.component2();
            String lastLine = CollectionsKt.getOrNull(this.lastLines, index);
            if (Intrinsics.areEqual(lastLine, line)) continue;
            PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerUpdateScore("typewriter_line_" + index, WrapperPlayServerUpdateScore.Action.CREATE_OR_UPDATE_ITEM, "typewriter", 15 - index, MiniMessagesKt.asMini(line), (ScoreFormat)ScoreFormat.blankScore()), this.getPlayer());
        }
        if (lines.size() < this.lastLines.size()) {
            int n = this.lastLines.size();
            for (int i = lines.size(); i < n; ++i) {
                PlayerPacketsKt.sendPacketTo((PacketWrapper)new WrapperPlayServerResetScore("typewriter_line_" + i, "typewriter"), this.getPlayer());
            }
        }
    }
}

