/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entries;

import com.typewritermc.core.entries.Entry;
import com.typewritermc.engine.paper.entry.entries.EntryTrigger;
import com.typewritermc.engine.paper.entry.entries.EventTrigger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\t\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0002J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0000J\u0013\u0010\u0016\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/engine/paper/entry/entries/Event;", "", "player", "Lorg/bukkit/entity/Player;", "triggers", "", "Lcom/typewritermc/engine/paper/entry/entries/EventTrigger;", "<init>", "(Lorg/bukkit/entity/Player;Ljava/util/List;)V", "", "(Lorg/bukkit/entity/Player;[Lcom/typewritermc/engine/paper/entry/entries/EventTrigger;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getTriggers", "()Ljava/util/List;", "contains", "", "trigger", "entry", "Lcom/typewritermc/core/entries/Entry;", "merge", "other", "equals", "hashCode", "", "toString", "", "distinct", "engine-paper"})
public final class Event {
    @NotNull
    private final Player player;
    @NotNull
    private final List<EventTrigger> triggers;

    public Event(@NotNull Player player, @NotNull List<? extends EventTrigger> triggers) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(triggers, "triggers");
        this.player = player;
        this.triggers = triggers;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final List<EventTrigger> getTriggers() {
        return this.triggers;
    }

    public Event(@NotNull Player player, EventTrigger ... triggers) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(triggers, "triggers");
        this(player, ArraysKt.toList(triggers));
    }

    public final boolean contains(@NotNull EventTrigger trigger) {
        Intrinsics.checkNotNullParameter(trigger, "trigger");
        return this.triggers.contains(trigger);
    }

    public final boolean contains(@NotNull Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        return this.triggers.contains(new EntryTrigger(entry.getId()));
    }

    @NotNull
    public final Event merge(@Nullable Event other) {
        if (other == null) {
            return this;
        }
        if (!Intrinsics.areEqual(this.player.getUniqueId(), other.player.getUniqueId())) {
            return this;
        }
        return new Event(this.player, CollectionsKt.plus((Collection)this.triggers, (Iterable)other.triggers));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Event)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.triggers, ((Event)other).triggers)) {
            return false;
        }
        return Intrinsics.areEqual(this.player.getUniqueId(), ((Event)other).player.getUniqueId());
    }

    public int hashCode() {
        int result = ((Object)this.triggers).hashCode();
        result = 31 * result + this.player.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "Event(player=" + this.player.getName() + ", triggers=" + this.triggers + ")";
    }

    @NotNull
    public final Event distinct() {
        return new Event(this.player, CollectionsKt.distinct((Iterable)this.triggers));
    }
}

