/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entries;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.AudienceManager;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplay;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplayState;
import com.typewritermc.engine.paper.entry.entries.AudienceFilterEntry;
import com.typewritermc.engine.paper.entry.entries.Invertible;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lirand.api.extensions.server.ServerExtensionsKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.koin.java.KoinJavaComponent;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eH&J\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\bJ\n\u0010\u001a\u001a\u00020\u0018*\u00020\u000eJ\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000bJ\u0011\u0010!\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0096\u0002J\u0011\u0010!\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000bH\u0096\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplay;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilterEntry;", "<init>", "(Lcom/typewritermc/core/entries/Ref;)V", "inverted", "", "filteredPlayers", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Ljava/util/UUID;", "players", "", "Lorg/bukkit/entity/Player;", "getPlayers", "()Ljava/util/List;", "consideredPlayers", "getConsideredPlayers", "displayState", "Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplayState;", "player", "filter", "updateFilter", "", "isFiltered", "refresh", "onPlayerAdd", "onPlayerRemove", "onPlayerFilterAdded", "onPlayerFilterRemoved", "canConsider", "uuid", "contains", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nAudienceEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudienceEntry.kt\ncom/typewritermc/engine/paper/entry/entries/AudienceFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n774#2:285\n865#2,2:286\n*S KotlinDebug\n*F\n+ 1 AudienceEntry.kt\ncom/typewritermc/engine/paper/entry/entries/AudienceFilter\n*L\n116#1:285\n116#1:286,2\n*E\n"})
public abstract class AudienceFilter
extends AudienceDisplay {
    @NotNull
    private final Ref<? extends AudienceFilterEntry> ref;
    private final boolean inverted;
    @NotNull
    private final ConcurrentSkipListSet<UUID> filteredPlayers;

    public AudienceFilter(@NotNull Ref<? extends AudienceFilterEntry> ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        this.ref = ref;
        AudienceFilterEntry audienceFilterEntry = this.ref.get();
        Invertible invertible = audienceFilterEntry instanceof Invertible ? (Invertible)((Object)audienceFilterEntry) : null;
        this.inverted = invertible != null ? invertible.getInverted() : false;
        this.filteredPlayers = new ConcurrentSkipListSet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Player> getPlayers() {
        void $this$filterTo$iv$iv;
        Collection collection = ServerExtensionsKt.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!this.filteredPlayers.contains(it.getUniqueId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final List<Player> getConsideredPlayers() {
        return super.getPlayers();
    }

    @Override
    @NotNull
    public AudienceDisplayState displayState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.contains(player)) {
            return AudienceDisplayState.IN_AUDIENCE;
        }
        if (this.canConsider(player)) {
            return AudienceDisplayState.BLOCKED;
        }
        return AudienceDisplayState.NOT_CONSIDERED;
    }

    public abstract boolean filter(@NotNull Player var1);

    public final void updateFilter(@NotNull Player $this$updateFilter, boolean isFiltered) {
        boolean allow;
        Intrinsics.checkNotNullParameter($this$updateFilter, "<this>");
        boolean bl = allow = !this.inverted == isFiltered && this.canConsider($this$updateFilter);
        if (allow) {
            if (this.filteredPlayers.add($this$updateFilter.getUniqueId())) {
                this.onPlayerFilterAdded($this$updateFilter);
                ((AudienceManager)KoinJavaComponent.get$default(AudienceManager.class, null, null, 6, null)).addPlayerToChildren($this$updateFilter, this.ref);
            }
        } else if (this.filteredPlayers.remove($this$updateFilter.getUniqueId())) {
            this.onPlayerFilterRemoved($this$updateFilter);
            ((AudienceManager)KoinJavaComponent.get$default(AudienceManager.class, null, null, 6, null)).removePlayerFromChildren($this$updateFilter, this.ref);
        }
    }

    public final void refresh(@NotNull Player $this$refresh) {
        Intrinsics.checkNotNullParameter($this$refresh, "<this>");
        this.updateFilter($this$refresh, this.filter($this$refresh));
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.refresh(player);
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.updateFilter(player, false);
    }

    public void onPlayerFilterAdded(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
    }

    public void onPlayerFilterRemoved(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
    }

    public final boolean canConsider(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return super.contains(player);
    }

    public final boolean canConsider(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return super.contains(uuid);
    }

    @Override
    public boolean contains(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        return this.contains(uUID);
    }

    @Override
    public boolean contains(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return this.filteredPlayers.contains(uuid);
    }
}

