/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entries;

import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplayState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lirand.api.extensions.events.ListenerExtensionsKt;
import lirand.api.extensions.server.ServerExtensionsKt;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rJ\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rH&J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rH&J\u0011\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\rH\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\nH\u0096\u0002R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplay;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "value", "", "isActive", "()Z", "playerIds", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Ljava/util/UUID;", "players", "", "Lorg/bukkit/entity/Player;", "getPlayers", "()Ljava/util/List;", "displayState", "Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplayState;", "player", "initialize", "", "dispose", "addPlayer", "removePlayer", "onPlayerAdd", "onPlayerRemove", "contains", "uuid", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nAudienceEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudienceEntry.kt\ncom/typewritermc/engine/paper/entry/entries/AudienceDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n774#2:285\n865#2,2:286\n1863#2,2:288\n*S KotlinDebug\n*F\n+ 1 AudienceEntry.kt\ncom/typewritermc/engine/paper/entry/entries/AudienceDisplay\n*L\n66#1:285\n66#1:286,2\n82#1:288,2\n*E\n"})
public abstract class AudienceDisplay
implements Listener {
    private boolean isActive;
    @NotNull
    private final ConcurrentSkipListSet<UUID> playerIds = new ConcurrentSkipListSet();

    public final boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Player> getPlayers() {
        void $this$filterTo$iv$iv;
        Collection collection = ServerExtensionsKt.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!this.playerIds.contains(it.getUniqueId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public AudienceDisplayState displayState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.playerIds.contains(player.getUniqueId())) {
            return AudienceDisplayState.IN_AUDIENCE;
        }
        return AudienceDisplayState.NOT_CONSIDERED;
    }

    public void initialize() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        ServerExtensionsKt.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)TypewriterPaperPluginKt.getPlugin());
    }

    public void dispose() {
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        Iterable $this$forEach$iv = this.getPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.removePlayer(it);
        }
        ListenerExtensionsKt.unregister(this);
    }

    public final void addPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.playerIds.isEmpty()) {
            this.initialize();
        }
        if (!this.playerIds.add(player.getUniqueId())) {
            return;
        }
        this.onPlayerAdd(player);
    }

    public final void removePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!this.playerIds.remove(player.getUniqueId())) {
            return;
        }
        this.onPlayerRemove(player);
        if (this.playerIds.isEmpty()) {
            this.dispose();
        }
    }

    public abstract void onPlayerAdd(@NotNull Player var1);

    public abstract void onPlayerRemove(@NotNull Player var1);

    public boolean contains(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.playerIds.contains(player.getUniqueId());
    }

    public boolean contains(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return this.playerIds.contains(uuid);
    }
}

