/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.ActivityCreator;
import com.typewritermc.engine.paper.entry.entity.ActivityEntityDisplay;
import com.typewritermc.engine.paper.entry.entity.ActivityManager;
import com.typewritermc.engine.paper.entry.entity.DisplayEntity;
import com.typewritermc.engine.paper.entry.entity.DisplayEntityKt;
import com.typewritermc.engine.paper.entry.entity.EntityCreator;
import com.typewritermc.engine.paper.entry.entity.EntityState;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.PositionPropertyKt;
import com.typewritermc.engine.paper.entry.entity.SharedActivityContext;
import com.typewritermc.engine.paper.entry.entity.SharedActivityEntityDisplayKt;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.EntityDefinitionEntry;
import com.typewritermc.engine.paper.entry.entries.EntityInstanceEntry;
import com.typewritermc.engine.paper.entry.entries.PropertySupplier;
import com.typewritermc.engine.paper.entry.entries.TickableDisplay;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BM\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001c\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010&\u001a\u00020\"H\u0016J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u000fH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00112\u0006\u0010(\u001a\u00020\u001bH\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u001bH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/typewritermc/engine/paper/entry/entity/SharedActivityEntityDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/TickableDisplay;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityEntityDisplay;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityInstanceEntry;", "creator", "Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;", "activityCreators", "Lcom/typewritermc/engine/paper/entry/entity/ActivityCreator;", "suppliers", "", "Lkotlin/Pair;", "Lcom/typewritermc/engine/paper/entry/entries/PropertySupplier;", "", "spawnPosition", "Lcom/typewritermc/core/utils/point/Position;", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;Lcom/typewritermc/engine/paper/entry/entity/ActivityCreator;Ljava/util/List;Lcom/typewritermc/core/utils/point/Position;)V", "getCreator", "()Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;", "activityManager", "Lcom/typewritermc/engine/paper/entry/entity/ActivityManager;", "Lcom/typewritermc/engine/paper/entry/entity/SharedActivityContext;", "entities", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/entry/entity/DisplayEntity;", "filter", "", "player", "Lorg/bukkit/entity/Player;", "initialize", "", "onPlayerFilterAdded", "tick", "onPlayerFilterRemoved", "dispose", "playerSeesEntity", "playerId", "entityId", "position", "canView", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nSharedActivityEntityDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedActivityEntityDisplay.kt\ncom/typewritermc/engine/paper/entry/entity/SharedActivityEntityDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1863#2,2:87\n1863#2,2:89\n1863#2,2:91\n*S KotlinDebug\n*F\n+ 1 SharedActivityEntityDisplay.kt\ncom/typewritermc/engine/paper/entry/entity/SharedActivityEntityDisplay\n*L\n50#1:87,2\n58#1:89,2\n68#1:91,2\n*E\n"})
public final class SharedActivityEntityDisplay
extends AudienceFilter
implements TickableDisplay,
ActivityEntityDisplay {
    @NotNull
    private final Ref<? extends EntityInstanceEntry> ref;
    @NotNull
    private final EntityCreator creator;
    @NotNull
    private final ActivityCreator activityCreators;
    @NotNull
    private final List<Pair<PropertySupplier<?>, Integer>> suppliers;
    @NotNull
    private final Position spawnPosition;
    @Nullable
    private ActivityManager<SharedActivityContext> activityManager;
    @NotNull
    private final ConcurrentHashMap<UUID, DisplayEntity> entities;

    public SharedActivityEntityDisplay(@NotNull Ref<? extends EntityInstanceEntry> ref, @NotNull EntityCreator creator, @NotNull ActivityCreator activityCreators, @NotNull List<? extends Pair<? extends PropertySupplier<?>, Integer>> suppliers, @NotNull Position spawnPosition) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        Intrinsics.checkNotNullParameter(creator, "creator");
        Intrinsics.checkNotNullParameter(activityCreators, "activityCreators");
        Intrinsics.checkNotNullParameter(suppliers, "suppliers");
        Intrinsics.checkNotNullParameter(spawnPosition, "spawnPosition");
        super(ref);
        this.ref = ref;
        this.creator = creator;
        this.activityCreators = activityCreators;
        this.suppliers = suppliers;
        this.spawnPosition = spawnPosition;
        this.entities = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public EntityCreator getCreator() {
        return this.creator;
    }

    @Override
    public boolean filter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        if (activityManager == null || (activityManager = activityManager.getPosition()) == null) {
            return false;
        }
        ActivityManager<SharedActivityContext> npcLocation = activityManager;
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Double d = ((PositionProperty)((Object)npcLocation)).distanceSqrt(location);
        if (d == null) {
            return false;
        }
        double distance = d;
        return distance <= SharedActivityEntityDisplayKt.getEntityShowRange() * SharedActivityEntityDisplayKt.getEntityShowRange();
    }

    @Override
    public void initialize() {
        block0: {
            super.initialize();
            SharedActivityContext context = new SharedActivityContext(this.ref, this.getPlayers(), null, 4, null);
            ActivityManager<SharedActivityContext> activityManager = this.activityManager = new ActivityManager<ActivityContext>(this.activityCreators.create(context, PositionPropertyKt.toProperty(this.spawnPosition)));
            if (activityManager == null) break block0;
            activityManager.initialize((SharedActivityContext)((ActivityContext)context));
        }
    }

    @Override
    public void onPlayerFilterAdded(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        super.onPlayerFilterAdded(player);
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        if (activityManager == null) {
            return;
        }
        ActivityManager<SharedActivityContext> activityManager2 = activityManager;
        this.entities.computeIfAbsent(player.getUniqueId(), arg_0 -> SharedActivityEntityDisplay.onPlayerFilterAdded$lambda$1(arg_0 -> SharedActivityEntityDisplay.onPlayerFilterAdded$lambda$0(player, this, activityManager2, arg_0), arg_0));
    }

    @Override
    public void tick() {
        Iterable $this$forEach$iv = this.getConsideredPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.refresh(it);
        }
        Collection<DisplayEntity> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Object object = (DisplayEntity)CollectionsKt.firstOrNull((Iterable)collection);
        if (object == null || (object = ((DisplayEntity)object).getState()) == null) {
            object = new EntityState(0.0, 1, null);
        }
        Object entityState = object;
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        if (activityManager != null) {
            activityManager.tick((SharedActivityContext)((ActivityContext)new SharedActivityContext(this.ref, this.getPlayers(), (EntityState)entityState)));
        }
        Collection<DisplayEntity> collection2 = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $this$forEach$iv2 = collection2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            DisplayEntity it = (DisplayEntity)element$iv;
            boolean bl = false;
            it.tick();
        }
    }

    @Override
    public void onPlayerFilterRemoved(@NotNull Player player) {
        block0: {
            Intrinsics.checkNotNullParameter(player, "player");
            super.onPlayerFilterRemoved(player);
            DisplayEntity displayEntity = this.entities.remove(player.getUniqueId());
            if (displayEntity == null) break block0;
            displayEntity.dispose();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        Collection<DisplayEntity> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisplayEntity it = (DisplayEntity)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.entities.clear();
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        if (activityManager != null) {
            activityManager.dispose((SharedActivityContext)((ActivityContext)new SharedActivityContext(this.ref, this.getPlayers(), null, 4, null)));
        }
        this.activityManager = null;
    }

    @Override
    public boolean playerSeesEntity(@NotNull UUID playerId, int entityId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return displayEntity != null ? displayEntity.contains(entityId) : false;
    }

    @Override
    @Nullable
    public Position position(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        ActivityManager<SharedActivityContext> activityManager = this.activityManager;
        return activityManager != null ? activityManager.getPosition() : null;
    }

    @Override
    public boolean canView(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        return this.canConsider(playerId);
    }

    @Override
    public int entityId(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return displayEntity != null ? displayEntity.getEntityId() : 0;
    }

    @Override
    @Nullable
    public EntityDefinitionEntry getDefinition() {
        return ActivityEntityDisplay.DefaultImpls.getDefinition(this);
    }

    private static final DisplayEntity onPlayerFilterAdded$lambda$0(Player $player, SharedActivityEntityDisplay this$0, ActivityManager $activityManager, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new DisplayEntity($player, this$0.getCreator(), $activityManager, DisplayEntityKt.toCollectors(this$0.suppliers));
    }

    private static final DisplayEntity onPlayerFilterAdded$lambda$1(Function1 $tmp0, Object p0) {
        return (DisplayEntity)$tmp0.invoke(p0);
    }
}

